/*
 * Decompiled with CFR 0.152.
 */
package com.gmo_pg.g_pay.client.tran;

import com.gmo_pg.g_pay.client.common.PaymentException;
import com.gmo_pg.g_pay.client.common.log.Log;
import com.gmo_pg.g_pay.client.input.AcsParam;
import com.gmo_pg.g_pay.client.input.EntryExecTranInput;
import com.gmo_pg.g_pay.client.input.EntryTranInput;
import com.gmo_pg.g_pay.client.input.ExecTranInput;
import com.gmo_pg.g_pay.client.input.SecureTranInput;
import com.gmo_pg.g_pay.client.output.EntryExecTranOutput;
import com.gmo_pg.g_pay.client.output.EntryTranOutput;
import com.gmo_pg.g_pay.client.output.ExecTranOutput;
import com.gmo_pg.g_pay.client.output.SecureTranOutput;
import com.gmo_pg.g_pay.client.tran.EntryTran;
import com.gmo_pg.g_pay.client.tran.ExecTran;
import com.gmo_pg.g_pay.client.tran.SecureTran;
import com.gmo_pg.g_pay.client.util.RedirectUtil;

public class EntryExecTran {
    private static final Log log = new Log(EntryExecTran.class);
    private EntryTran entryTran = null;
    private ExecTran execTran = null;
    private SecureTran secureTran = null;
    private RedirectUtil redirectUtil = null;

    public EntryExecTran() {
        this.entryTran = new EntryTran();
        this.execTran = new ExecTran();
        this.secureTran = new SecureTran();
        this.redirectUtil = new RedirectUtil();
    }

    public EntryExecTran(EntryTran entryTran, ExecTran execTran, SecureTran secureTran, RedirectUtil redirectUtil) {
        this.entryTran = entryTran;
        this.execTran = execTran;
        this.secureTran = secureTran;
        this.redirectUtil = redirectUtil;
    }

    public EntryExecTranOutput exec(EntryExecTranInput input) throws PaymentException {
        EntryTranInput entryTranInput = input.getEntryTranInput();
        ExecTranInput execTranInput = input.getExecTranInput();
        EntryExecTranOutput output = new EntryExecTranOutput();
        String accessId = execTranInput.getAccessId();
        String accessPass = execTranInput.getAccessPass();
        if (null == accessId || 0 == accessId.length() || null == accessPass) {
            log.debug("\u53d6\u5f15\u767b\u9332\u5b9f\u884c");
            EntryTranOutput entryTranOutput = this.entryTran.exec(entryTranInput);
            accessId = entryTranOutput.getAccessId();
            accessPass = entryTranOutput.getAccessPass();
            execTranInput.setAccessId(accessId);
            execTranInput.setAccessPass(accessPass);
            output.setEntryTranOutput(entryTranOutput);
        } else {
            output.setAccessId(accessId);
            output.setAccessPass(accessPass);
        }
        log.debug("\u53d6\u5f15ID : [{0}]  \u53d6\u5f15\u30d1\u30b9\u30ef\u30fc\u30c9 : [{1}]", new Object[]{accessId, accessPass});
        if (output.isEntryErrorOccurred()) {
            log.debug("<<<\u53d6\u5f15\u767b\u9332\u5931\u6557>>>");
            return output;
        }
        log.debug("\u6c7a\u6e08\u5b9f\u884c");
        ExecTranOutput execTranOutput = this.execTran.exec(execTranInput);
        output.setExecTranOutput(execTranOutput);
        return output;
    }

    public String createRedirectPage(String pagePath, EntryExecTranOutput execResult, String termUrl, String encode) throws PaymentException {
        AcsParam param = new AcsParam();
        param.setAcsUrl(execResult.getAcsUrl());
        param.setMd(execResult.getMd());
        param.setPaReq(execResult.getPaReq());
        param.setTermUrl(termUrl);
        return this.redirectUtil.createRedirectPage(pagePath, param, encode);
    }

    public SecureTranOutput requestSecureTran(String paRes, String md) throws PaymentException {
        SecureTranInput input = new SecureTranInput();
        input.setPaRes(paRes);
        input.setMd(md);
        return this.requestSecureTran(input);
    }

    public SecureTranOutput requestSecureTran(SecureTranInput input) throws PaymentException {
        return this.secureTran.exec(input);
    }
}

