/*
 * Decompiled with CFR 0.152.
 */
package com.gmo_pg.g_pay.client.tran;

import com.gmo_pg.g_pay.client.common.Const;
import com.gmo_pg.g_pay.client.common.PaymentException;
import com.gmo_pg.g_pay.client.common.log.Log;
import com.gmo_pg.g_pay.client.common.util.ConnectUrlMap;
import com.gmo_pg.g_pay.client.common.util.Cryptgram;
import com.gmo_pg.g_pay.client.common.util.IgnoreCaseMap;
import com.gmo_pg.g_pay.client.common.util.ParamParserUtil;
import com.gmo_pg.g_pay.client.input.BaseInput;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.Properties;

public abstract class BaseTran {
    private static final Log log = new Log(BaseTran.class);
    protected Cryptgram cryptgram = new Cryptgram();
    private static final String ENCODE = "Windows-31J";

    protected URLConnection connect(String url) throws PaymentException {
        try {
            URL urlObj = new URL(url);
            URLConnection urlConnect = urlObj.openConnection();
            if (!(urlConnect instanceof HttpURLConnection)) {
                throw new PaymentException("\u672a\u5bfe\u5fdc\u306e\u30d7\u30ed\u30c8\u30b3\u30eb\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002[" + urlObj.getProtocol() + ']');
            }
            ((HttpURLConnection)urlConnect).setRequestMethod("POST");
            this.setTimeout(urlConnect);
            urlConnect.setDoOutput(true);
            urlConnect.connect();
            return urlConnect;
        }
        catch (MalformedURLException e) {
            throw new PaymentException("\u30d7\u30ed\u30c8\u30b3\u30eb\u30bf\u30a4\u30d7\u3078\u306e\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
        catch (ProtocolException e) {
            throw new PaymentException("\u30d7\u30ed\u30c8\u30b3\u30eb\u30bf\u30a4\u30d7\u3078\u306e\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
        catch (IOException e) {
            throw new PaymentException("\u30d7\u30ed\u30c8\u30b3\u30eb\u30bf\u30a4\u30d7\u3078\u306e\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTimeout(URLConnection urlConnect) {
        block19: {
            InputStream in = null;
            try {
                Properties prop = new Properties();
                in = Thread.currentThread().getContextClassLoader().getResourceAsStream("conf/gmoconnection.properties");
                if (null == in) {
                    log.debug("conf/gmoconnection.properties\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
                    break block19;
                }
                prop.load(in);
                try {
                    String connectTimeoutStr = prop.getProperty("com.gmo_pg.g_pay.client.BaseTran.connecttimeout");
                    if (connectTimeoutStr != null && !connectTimeoutStr.equals("")) {
                        int connecttimeout = Integer.parseInt(prop.getProperty("com.gmo_pg.g_pay.client.BaseTran.connecttimeout"));
                        urlConnect.setConnectTimeout(connecttimeout);
                        log.debug("setConnectTimeout : " + connecttimeout);
                    }
                }
                catch (Exception e) {
                    log.debug("urlConnect.setConnectTimeout()\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                }
                try {
                    String readtTimeoutStr = prop.getProperty("com.gmo_pg.g_pay.client.BaseTran.readtimeout");
                    if (readtTimeoutStr != null && !readtTimeoutStr.equals("")) {
                        int readtimeout = Integer.parseInt(prop.getProperty("com.gmo_pg.g_pay.client.BaseTran.readtimeout"));
                        urlConnect.setReadTimeout(readtimeout);
                        log.debug("setReadTimeout : " + readtimeout);
                    }
                }
                catch (Exception e) {
                    log.debug("urlConnect.setReadTimeout()\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                }
            }
            catch (Exception e) {
                log.debug(e.getMessage());
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    log.debug(e.getMessage());
                }
            }
        }
    }

    protected void sendData(URLConnection urlConnect, String params) throws PaymentException {
        if (null == params) {
            throw new PaymentException("\u30d1\u30e9\u30e1\u30fc\u30bf\u6587\u5b57\u5217\u304cnull\u3067\u3059\u3002");
        }
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter(urlConnect.getOutputStream(), ENCODE);
            osw.write(params);
            osw.flush();
        }
        catch (IOException e) {
            throw new PaymentException("\u30d7\u30ed\u30c8\u30b3\u30eb\u30bf\u30a4\u30d7\u3078\u306e\u30c7\u30fc\u30bf\u306e\u9001\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
        finally {
            if (null != osw) {
                try {
                    osw.close();
                }
                catch (IOException e) {
                    log.warn("\u51fa\u529b\u30b9\u30c8\u30ea\u30fc\u30e0\u306e\u30af\u30ed\u30fc\u30ba\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002 : " + e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String recvData(URLConnection urlConnect) throws PaymentException {
        BufferedReader br = null;
        try {
            String retData;
            String line;
            br = new BufferedReader(new InputStreamReader(urlConnect.getInputStream(), ENCODE));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                if (sb.length() != 0) {
                    sb.append(Const.RETURN_CODE);
                }
                sb.append(line);
            }
            String string = retData = sb.toString();
            return string;
        }
        catch (IOException e) {
            String string = "ErrCode=E91&ErrInfo=E91060001";
            return string;
        }
        finally {
            if (null != br) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    log.warn("\u5165\u529b\u30b9\u30c8\u30ea\u30fc\u30e0\u306e\u30af\u30ed\u30fc\u30ba\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002 : " + e.getMessage());
                }
            }
        }
    }

    public Map callProtocol(String url, String params, String[] keyList) throws PaymentException {
        log.debug("\u672c\u6587 : {0}", new Object[]{params});
        URLConnection urlConnect = this.connect(url);
        this.sendData(urlConnect, params);
        String retData = this.recvData(urlConnect);
        log.debug("\u623b\u308a\u5024 : {0}", new Object[]{retData});
        Map resultMap = url.indexOf("SearchTradeMulti", 0) > 0 ? ParamParserUtil.searchTrademultiParse(retData) : (url.indexOf("ListVirtualaccount", 0) > 0 || url.indexOf("InquiryVirtualaccountTransfer", 0) > 0 ? ParamParserUtil.parseCsv(retData, keyList) : ParamParserUtil.parse(retData, keyList));
        resultMap = new IgnoreCaseMap(resultMap);
        return resultMap;
    }

    public Map callProtocol(String params, String[] keyList) throws PaymentException {
        ConnectUrlMap urlMap = new ConnectUrlMap();
        String key = this.getClass().getName();
        String url = urlMap.getUrl(key);
        log.debug("\u30ad\u30fc\u5024 : {0}  \u53d6\u5f97URL : {1}", new Object[]{key, url});
        if (null == url) {
            throw new PaymentException("\u547c\u3073\u51fa\u3057\u5148\u306eURL\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002[" + key + ']');
        }
        return this.callProtocol(url, params, keyList);
    }

    public Map callProtocol(BaseInput input, String[] keyList) throws PaymentException {
        log.debug("\u5165\u529b\u30d1\u30e9\u30e1\u30fc\u30bf : {0}", new Object[]{input});
        String params = input.toDataString(true) + "&Version=" + Const.getVersion() + "&User=" + Const.getUser();
        return this.callProtocol(params, keyList);
    }
}

