/*
 * Decompiled with CFR 0.152.
 */
package com.gmo_pg.g_pay.client.output;

import com.gmo_pg.g_pay.client.common.util.CommonUtil;
import com.gmo_pg.g_pay.client.output.BaseOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SearchPrecaHistoryOutput
extends BaseOutput {
    private String precaNo;
    private Integer totalValue;
    private Integer cnt;
    private List searchPrecaHistoryList;

    public SearchPrecaHistoryOutput() {
        this.searchPrecaHistoryList = Collections.EMPTY_LIST;
    }

    public SearchPrecaHistoryOutput(Map params) {
        super(params);
        this.setPrecaNo(this.getStringValue(params, "PrecaNo"));
        this.setTotalValue(this.getIntegerValue(params, "TotalValue"));
        this.setCnt(this.getIntegerValue(params, "Cnt"));
        this.searchPrecaHistoryList = this.createSearchPrecaHistoryList(params);
    }

    public String getPrecaNo() {
        return this.precaNo;
    }

    public Integer getTotalValue() {
        return this.totalValue;
    }

    public Integer getCnt() {
        return this.cnt;
    }

    public void setPrecaNo(String precaNo) {
        this.precaNo = precaNo;
    }

    public void setTotalValue(Integer totalValue) {
        this.totalValue = totalValue;
    }

    public void setCnt(Integer cnt) {
        this.cnt = cnt;
    }

    public List getSearchPrecaHistoryList() {
        return null == this.searchPrecaHistoryList ? null : Collections.unmodifiableList(this.searchPrecaHistoryList);
    }

    public void setSearchPrecaHistoryList(List searchPrecaHistoryList) {
        this.searchPrecaHistoryList = searchPrecaHistoryList;
    }

    private List createSearchPrecaHistoryList(Map params) {
        String p_precaseq = this.nullToEmpty(params.get("PrecaSeq"));
        if (p_precaseq.trim().equals("")) {
            return Collections.EMPTY_LIST;
        }
        Object[] precaSeq = p_precaseq.split("\\|");
        Object[] processDate = this.nullToEmpty(params.get("ProcessDate")).split("\\|");
        Object[] processType = this.nullToEmpty(params.get("ProcessType")).split("\\|");
        Object[] value = this.nullToEmpty(params.get("Value")).split("\\|");
        Object[] validValue = this.nullToEmpty(params.get("ValidValue")).split("\\|");
        Object[] expireDate = this.nullToEmpty(params.get("ExpireDate")).split("\\|");
        Object[] targetPrecaSeq = this.nullToEmpty(params.get("TargetPrecaSeq")).split("\\|");
        Object[] clientField = this.nullToEmpty(params.get("ClientField")).split("\\|");
        ArrayList<SearchPrecaHistoryInfo> list = new ArrayList<SearchPrecaHistoryInfo>();
        for (int i = 0; i < precaSeq.length; ++i) {
            SearchPrecaHistoryInfo info = new SearchPrecaHistoryInfo();
            info.setPrecaSeq(CommonUtil.isEmpty(this.nullToEmpty(this.getElementSafe(precaSeq, i))) ? null : Integer.valueOf((String)precaSeq[i]));
            info.setProcessDate(this.nullToEmpty(this.getElementSafe(processDate, i)));
            info.setProcessType(this.nullToEmpty(this.getElementSafe(processType, i)));
            info.setValue(CommonUtil.isEmpty(this.nullToEmpty(this.getElementSafe(value, i))) ? null : Integer.valueOf((String)value[i]));
            info.setValidValue(CommonUtil.isEmpty(this.nullToEmpty(this.getElementSafe(validValue, i))) ? null : Integer.valueOf((String)validValue[i]));
            info.setExpireDate(this.nullToEmpty(this.getElementSafe(expireDate, i)));
            info.setTargetPrecaSeq(CommonUtil.isEmpty(this.nullToEmpty(this.getElementSafe(targetPrecaSeq, i))) ? null : Integer.valueOf((String)targetPrecaSeq[i]));
            info.setClientField(this.nullToEmpty(this.getElementSafe(clientField, i)));
            list.add(info);
        }
        return list;
    }

    public String toString() {
        int n;
        StringBuffer sb = new StringBuffer();
        sb.append("PrecaNo").append("=").append(this.getPrecaNo());
        sb.append("&");
        sb.append("TotalValue").append("=").append(this.getTotalValue());
        sb.append("&");
        sb.append("Cnt").append("=").append(this.getCnt());
        sb.append("&");
        StringBuffer precaSeqBuff = new StringBuffer();
        StringBuffer processDateBuff = new StringBuffer();
        StringBuffer processTypeBuff = new StringBuffer();
        StringBuffer valueBuff = new StringBuffer();
        StringBuffer validValueBuff = new StringBuffer();
        StringBuffer expireDateBuff = new StringBuffer();
        StringBuffer targetPrecaSeqBuff = new StringBuffer();
        StringBuffer clientFieldBuff = new StringBuffer();
        precaSeqBuff.append("PrecaSeq").append("=");
        processDateBuff.append("ProcessDate").append("=");
        processTypeBuff.append("ProcessType").append("=");
        valueBuff.append("Value").append("=");
        validValueBuff.append("ValidValue").append("=");
        expireDateBuff.append("ExpireDate").append("=");
        targetPrecaSeqBuff.append("TargetPrecaSeq").append("=");
        clientFieldBuff.append("ClientField").append("=");
        int n2 = n = null == this.searchPrecaHistoryList ? 0 : this.searchPrecaHistoryList.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                precaSeqBuff.append("|");
                processDateBuff.append("|");
                processTypeBuff.append("|");
                valueBuff.append("|");
                validValueBuff.append("|");
                expireDateBuff.append("|");
                targetPrecaSeqBuff.append("|");
                clientFieldBuff.append("|");
            }
            SearchPrecaHistoryInfo info = (SearchPrecaHistoryInfo)this.searchPrecaHistoryList.get(i);
            precaSeqBuff.append(info.getPrecaSeq());
            processDateBuff.append(info.getProcessDate());
            processTypeBuff.append(info.getProcessType());
            valueBuff.append(info.getValue());
            validValueBuff.append(info.getValidValue());
            expireDateBuff.append(info.getExpireDate());
            targetPrecaSeqBuff.append(info.getTargetPrecaSeq());
            clientFieldBuff.append(info.getClientField());
        }
        String historyListStr = precaSeqBuff.append("&").append(processDateBuff).append("&").append(processTypeBuff).append("&").append(valueBuff).append("&").append(validValueBuff).append("&").append(expireDateBuff).append("&").append(targetPrecaSeqBuff).append("&").append(clientFieldBuff).append("&").toString();
        sb.append(historyListStr);
        sb.append(super.toString());
        return sb.toString();
    }

    public class SearchPrecaHistoryInfo {
        private Integer precaSeq;
        private String processDate;
        private String processType;
        private Integer value;
        private Integer validValue;
        private String expireDate;
        private Integer targetPrecaSeq;
        private String clientField;

        public Integer getPrecaSeq() {
            return this.precaSeq;
        }

        public String getProcessDate() {
            return this.processDate;
        }

        public String getProcessType() {
            return this.processType;
        }

        public Integer getValue() {
            return this.value;
        }

        public Integer getValidValue() {
            return this.validValue;
        }

        public String getExpireDate() {
            return this.expireDate;
        }

        public Integer getTargetPrecaSeq() {
            return this.targetPrecaSeq;
        }

        public String getClientField() {
            return this.clientField;
        }

        public void setPrecaSeq(Integer precaSeq) {
            this.precaSeq = precaSeq;
        }

        public void setProcessDate(String processDate) {
            this.processDate = processDate;
        }

        public void setProcessType(String processType) {
            this.processType = processType;
        }

        public void setValue(Integer value) {
            this.value = value;
        }

        public void setValidValue(Integer validValue) {
            this.validValue = validValue;
        }

        public void setExpireDate(String expireDate) {
            this.expireDate = expireDate;
        }

        public void setTargetPrecaSeq(Integer targetPrecaSeq) {
            this.targetPrecaSeq = targetPrecaSeq;
        }

        public void setClientField(String clientField) {
            this.clientField = clientField;
        }
    }
}

