/*
 * Decompiled with CFR 0.152.
 */
package com.gmo_pg.g_pay.client.output;

import com.gmo_pg.g_pay.client.output.BaseOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SearchMemberOutput
extends BaseOutput {
    private List memberList;

    public SearchMemberOutput() {
        this.memberList = Collections.EMPTY_LIST;
    }

    public SearchMemberOutput(Map params) {
        super(params);
        this.memberList = this.createMemberList(params);
    }

    public List getMemberList() {
        return null == this.memberList ? null : Collections.unmodifiableList(this.memberList);
    }

    public void setMemberList(List cardList) {
        this.memberList = cardList;
    }

    private List createMemberList(Map params) {
        String p_memberid = this.nullToEmpty(params.get("MemberID"));
        if (p_memberid.trim().equals("")) {
            return Collections.EMPTY_LIST;
        }
        String[] memberIds = p_memberid.split("\\|");
        Object[] memberNames = this.nullToEmpty(params.get("MemberName")).split("\\|");
        Object[] deleteFlags = this.nullToEmpty(params.get("DeleteFlag")).split("\\|");
        ArrayList<MemberInfo> list = new ArrayList<MemberInfo>();
        for (int i = 0; i < memberIds.length; ++i) {
            MemberInfo info = new MemberInfo();
            info.setMemberId(memberIds[i]);
            info.setMemberName(this.nullToEmpty(this.getElementSafe(memberNames, i)));
            info.setDeleteFlag(this.nullToEmpty(this.getElementSafe(deleteFlags, i)));
            list.add(info);
        }
        return list;
    }

    public String toString() {
        int n;
        StringBuffer memberIdBuff = new StringBuffer();
        StringBuffer memberNameBuf = new StringBuffer();
        StringBuffer deleteFlagBuf = new StringBuffer();
        memberIdBuff.append("MemberID").append("=");
        memberNameBuf.append("MemberName").append("=");
        deleteFlagBuf.append("DeleteFlag").append("=");
        int n2 = n = null == this.memberList ? 0 : this.memberList.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                memberIdBuff.append('|');
                memberNameBuf.append('|');
                deleteFlagBuf.append('|');
            }
            MemberInfo info = (MemberInfo)this.memberList.get(i);
            memberIdBuff.append(info.getMemberId());
            memberNameBuf.append(info.getMemberName());
            deleteFlagBuf.append(info.getDeleteFlag());
        }
        return memberIdBuff.append("&").append(memberNameBuf).append("&").append(deleteFlagBuf).append("&").append(super.toString()).toString();
    }

    public class MemberInfo {
        private String memberId;
        private String memberName;
        private String deleteFlag;

        public String getMemberId() {
            return this.memberId;
        }

        public String getMemberName() {
            return this.memberName;
        }

        public String getDeleteFlag() {
            return this.deleteFlag;
        }

        public void setMemberId(String memberId) {
            this.memberId = memberId;
        }

        public void setMemberName(String memberName) {
            this.memberName = memberName;
        }

        public void setDeleteFlag(String deleteFlag) {
            this.deleteFlag = deleteFlag;
        }
    }
}

