/*
 * Decompiled with CFR 0.152.
 */
package com.gmo_pg.g_pay.client.output;

import com.gmo_pg.g_pay.client.output.BaseOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SearchCardReverseOutput
extends BaseOutput {
    private List cardList;

    public SearchCardReverseOutput() {
        this.cardList = Collections.EMPTY_LIST;
    }

    public SearchCardReverseOutput(Map params) {
        super(params);
        this.cardList = this.createCardList(params);
    }

    public List getCardList() {
        return null == this.cardList ? null : Collections.unmodifiableList(this.cardList);
    }

    public void setCardList(List cardList) {
        this.cardList = cardList;
    }

    private List createCardList(Map params) {
        String p_memberId = this.nullToEmpty(params.get("MemberID"));
        if (p_memberId.trim().equals("")) {
            return Collections.EMPTY_LIST;
        }
        Object[] memberIds = p_memberId.split("\\|");
        Object[] createDates = this.nullToEmpty(params.get("CreateDate")).split("\\|");
        Object[] deleteFlags = this.nullToEmpty(params.get("DeleteFlag")).split("\\|");
        ArrayList<MemberCardInfo> list = new ArrayList<MemberCardInfo>();
        for (int i = 0; i < memberIds.length; ++i) {
            MemberCardInfo info = new MemberCardInfo();
            info.setMemberId(this.nullToEmpty(this.getElementSafe(memberIds, i)));
            info.setCreateDate(this.nullToEmpty(this.getElementSafe(createDates, i)));
            info.setDeleteFlag(this.nullToEmpty(this.getElementSafe(deleteFlags, i)));
            list.add(info);
        }
        return list;
    }

    public String toString() {
        int n;
        StringBuffer memberIdBuf = new StringBuffer();
        StringBuffer createDateBuf = new StringBuffer();
        StringBuffer deleteFlagBuf = new StringBuffer();
        memberIdBuf.append("MemberID").append("=");
        createDateBuf.append("CreateDate").append("=");
        deleteFlagBuf.append("DeleteFlag").append("=");
        int n2 = n = null == this.cardList ? 0 : this.cardList.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                memberIdBuf.append('|');
                createDateBuf.append('|');
                deleteFlagBuf.append('|');
            }
            MemberCardInfo info = (MemberCardInfo)this.cardList.get(i);
            memberIdBuf.append(info.getMemberId());
            createDateBuf.append(info.getCreateDate());
            deleteFlagBuf.append(info.getDeleteFlag());
        }
        return memberIdBuf.append("&").append(createDateBuf).append("&").append(deleteFlagBuf).append("&").toString();
    }

    public class MemberCardInfo {
        private String memberId;
        private String createDate;
        private String deleteFlag;

        public String getDeleteFlag() {
            return this.deleteFlag;
        }

        public void setDeleteFlag(String deleteFlag) {
            this.deleteFlag = deleteFlag;
        }

        public String getMemberId() {
            return this.memberId;
        }

        public void setMemberId(String memberId) {
            this.memberId = memberId;
        }

        public String getCreateDate() {
            return this.createDate;
        }

        public void setCreateDate(String createDate) {
            this.createDate = createDate;
        }
    }
}

