/*
 * Decompiled with CFR 0.152.
 */
package com.gmo_pg.g_pay.client.output;

import com.gmo_pg.g_pay.client.output.BaseOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SearchCardOutput
extends BaseOutput {
    private List cardList;

    public SearchCardOutput() {
        this.cardList = Collections.EMPTY_LIST;
    }

    public SearchCardOutput(Map params) {
        super(params);
        this.cardList = this.createCardList(params);
    }

    public List getCardList() {
        return null == this.cardList ? null : Collections.unmodifiableList(this.cardList);
    }

    public void setCardList(List cardList) {
        this.cardList = cardList;
    }

    private List createCardList(Map params) {
        String p_cardseq = this.nullToEmpty(params.get("CardSeq"));
        if (p_cardseq.trim().equals("")) {
            return Collections.EMPTY_LIST;
        }
        String[] cardSeqs = p_cardseq.split("\\|");
        Object[] defaultFlags = this.nullToEmpty(params.get("DefaultFlag")).split("\\|");
        Object[] cardNames = this.nullToEmpty(params.get("CardName")).split("\\|");
        Object[] cardNos = this.nullToEmpty(params.get("CardNo")).split("\\|");
        Object[] expires = this.nullToEmpty(params.get("Expire")).split("\\|");
        Object[] holderNames = this.nullToEmpty(params.get("HolderName")).split("\\|");
        Object[] deleteFlags = this.nullToEmpty(params.get("DeleteFlag")).split("\\|");
        Object[] brand = this.nullToEmpty(params.get("Brand")).split("\\|");
        Object[] domesticFlag = this.nullToEmpty(params.get("DomesticFlag")).split("\\|");
        Object[] issuerCode = this.nullToEmpty(params.get("IssuerCode")).split("\\|");
        Object[] debitPrepaidIssuerName = this.nullToEmpty(params.get("DebitPrepaidIssuerName")).split("\\|");
        Object[] debitPrepaidFlag = this.nullToEmpty(params.get("DebitPrepaidFlag")).split("\\|");
        Object[] forwardFinal = this.nullToEmpty(params.get("ForwardFinal")).split("\\|");
        ArrayList<CardInfo> list = new ArrayList<CardInfo>();
        for (int i = 0; i < cardSeqs.length; ++i) {
            CardInfo info = new CardInfo();
            info.setCardSeq(Integer.valueOf(cardSeqs[i]));
            info.setDefaultFlag(this.nullToEmpty(this.getElementSafe(defaultFlags, i)));
            info.setCardName(this.nullToEmpty(this.getElementSafe(cardNames, i)));
            info.setCardNo(this.nullToEmpty(this.getElementSafe(cardNos, i)));
            info.setExpire(this.nullToEmpty(this.getElementSafe(expires, i)));
            info.setHolderName(this.nullToEmpty(this.getElementSafe(holderNames, i)));
            info.setDeleteFlag(this.nullToEmpty(this.getElementSafe(deleteFlags, i)));
            info.setBrand(this.nullToEmpty(this.getElementSafe(brand, i)));
            info.setDomesticFlag(this.nullToEmpty(this.getElementSafe(domesticFlag, i)));
            info.setIssuerCode(this.nullToEmpty(this.getElementSafe(issuerCode, i)));
            info.setDebitPrepaidIssuerName(this.nullToEmpty(this.getElementSafe(debitPrepaidIssuerName, i)));
            info.setDebitPrepaidFlag(this.nullToEmpty(this.getElementSafe(debitPrepaidFlag, i)));
            info.setForwardFinal(this.nullToEmpty(this.getElementSafe(forwardFinal, i)));
            list.add(info);
        }
        return list;
    }

    public String toString() {
        int n;
        StringBuffer cardSeqBuff = new StringBuffer();
        StringBuffer defaultFlagBuf = new StringBuffer();
        StringBuffer cardNameBuf = new StringBuffer();
        StringBuffer cardNoBuf = new StringBuffer();
        StringBuffer expireBuf = new StringBuffer();
        StringBuffer holderNameBuf = new StringBuffer();
        StringBuffer deleteFlagBuf = new StringBuffer();
        StringBuffer brandBuf = new StringBuffer();
        StringBuffer domesticFlagBuf = new StringBuffer();
        StringBuffer issuerCodeBuf = new StringBuffer();
        StringBuffer debitPrepaidFlagBuf = new StringBuffer();
        StringBuffer debitPrepaidIssuerNameBuf = new StringBuffer();
        StringBuffer forwardFinalBuf = new StringBuffer();
        cardSeqBuff.append("CardSeq").append("=");
        defaultFlagBuf.append("DefaultFlag").append("=");
        cardNameBuf.append("CardName").append("=");
        cardNoBuf.append("CardNo").append("=");
        expireBuf.append("Expire").append("=");
        holderNameBuf.append("HolderName").append("=");
        deleteFlagBuf.append("DeleteFlag").append("=");
        brandBuf.append("Brand").append("=");
        domesticFlagBuf.append("DomesticFlag").append("=");
        issuerCodeBuf.append("IssuerCode").append("=");
        debitPrepaidFlagBuf.append("DebitPrepaidFlag").append("=");
        debitPrepaidIssuerNameBuf.append("DebitPrepaidIssuerName").append("=");
        forwardFinalBuf.append("ForwardFinal").append("=");
        int n2 = n = null == this.cardList ? 0 : this.cardList.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                cardSeqBuff.append('|');
                defaultFlagBuf.append('|');
                cardNameBuf.append('|');
                cardNoBuf.append('|');
                expireBuf.append('|');
                holderNameBuf.append('|');
                deleteFlagBuf.append('|');
                brandBuf.append('|');
                domesticFlagBuf.append('|');
                issuerCodeBuf.append('|');
                debitPrepaidIssuerNameBuf.append('|');
                debitPrepaidFlagBuf.append('|');
                forwardFinalBuf.append('|');
            }
            CardInfo info = (CardInfo)this.cardList.get(i);
            cardSeqBuff.append(info.getCardSeq());
            defaultFlagBuf.append(info.getDefaultFlag());
            cardNameBuf.append(info.getCardName());
            cardNoBuf.append(info.getCardNo());
            expireBuf.append(info.getExpire());
            holderNameBuf.append(info.getHolderName());
            deleteFlagBuf.append(info.getDeleteFlag());
            brandBuf.append(info.getBrand());
            domesticFlagBuf.append(info.getDomesticFlag());
            issuerCodeBuf.append(info.getIssuerCode());
            debitPrepaidIssuerNameBuf.append(info.getDebitPrepaidIssuerName());
            debitPrepaidFlagBuf.append(info.getDebitPrepaidFlag());
            forwardFinalBuf.append(info.getForwardFinal());
        }
        return cardSeqBuff.append("&").append(defaultFlagBuf).append("&").append(cardNameBuf).append("&").append(cardNoBuf).append("&").append(expireBuf).append("&").append(holderNameBuf).append("&").append(deleteFlagBuf).append("&").append(brandBuf).append("&").append(domesticFlagBuf).append("&").append(issuerCodeBuf).append("&").append(debitPrepaidFlagBuf).append("&").append(debitPrepaidIssuerNameBuf).append("&").append(forwardFinalBuf).append("&").append(super.toString()).toString();
    }

    public class CardInfo {
        private Integer cardSeq;
        private String defaultFlag;
        private String cardName;
        private String cardNo;
        private String expire;
        private String holderName;
        private String deleteFlag;
        private String brand;
        private String domesticFlag;
        private String issuerCode;
        private String debitPrepaidIssuerName;
        private String debitPrepaidFlag;
        private String forwardFinal;

        public Integer getCardSeq() {
            return this.cardSeq;
        }

        public String getDefaultFlag() {
            return this.defaultFlag;
        }

        public String getCardName() {
            return this.cardName;
        }

        public String getCardNo() {
            return this.cardNo;
        }

        public String getExpire() {
            return this.expire;
        }

        public String getHolderName() {
            return this.holderName;
        }

        public String getDeleteFlag() {
            return this.deleteFlag;
        }

        public void setCardSeq(Integer cardSeq) {
            this.cardSeq = cardSeq;
        }

        public void setDefaultFlag(String defaultFlag) {
            this.defaultFlag = defaultFlag;
        }

        public void setCardName(String cardName) {
            this.cardName = cardName;
        }

        public void setCardNo(String cardNo) {
            this.cardNo = cardNo;
        }

        public void setExpire(String expire) {
            this.expire = expire;
        }

        public void setHolderName(String holderName) {
            this.holderName = holderName;
        }

        public void setDeleteFlag(String deleteFlag) {
            this.deleteFlag = deleteFlag;
        }

        public String getBrand() {
            return this.brand;
        }

        public void setBrand(String brand) {
            this.brand = brand;
        }

        public String getDomesticFlag() {
            return this.domesticFlag;
        }

        public void setDomesticFlag(String domesticFlag) {
            this.domesticFlag = domesticFlag;
        }

        public String getIssuerCode() {
            return this.issuerCode;
        }

        public void setIssuerCode(String issuerCode) {
            this.issuerCode = issuerCode;
        }

        public String getDebitPrepaidIssuerName() {
            return this.debitPrepaidIssuerName;
        }

        public void setDebitPrepaidIssuerName(String debitPrepaidIssuerName) {
            this.debitPrepaidIssuerName = debitPrepaidIssuerName;
        }

        public String getDebitPrepaidFlag() {
            return this.debitPrepaidFlag;
        }

        public void setDebitPrepaidFlag(String debitPrepaidFlag) {
            this.debitPrepaidFlag = debitPrepaidFlag;
        }

        public String getForwardFinal() {
            return this.forwardFinal;
        }

        public void setForwardFinal(String forwardFinal) {
            this.forwardFinal = forwardFinal;
        }
    }
}

