/*
 * Decompiled with CFR 0.152.
 */
package com.gmo_pg.g_pay.client.output;

import com.gmo_pg.g_pay.client.common.util.CommonUtil;
import com.gmo_pg.g_pay.client.common.util.ParamParserUtil;
import com.gmo_pg.g_pay.client.output.ErrHolder;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class BaseOutput
implements Serializable {
    private List errList = Collections.EMPTY_LIST;
    private String csvResponse;

    public BaseOutput() {
    }

    public BaseOutput(Map params) {
        this();
        String errInfo;
        String errCode = params.containsKey("ErrCode") ? (String)params.get("ErrCode") : null;
        String string = errInfo = params.containsKey("ErrInfo") ? (String)params.get("ErrInfo") : null;
        if (null != errCode && null != errInfo) {
            this.errList = ParamParserUtil.errParse(errCode, errInfo);
        }
        this.csvResponse = params.containsKey("CsvResponse") ? (String)params.get("CsvResponse") : null;
    }

    public List getErrList() {
        return null == this.errList ? null : Collections.unmodifiableList(this.errList);
    }

    public void setErrList(List errList) {
        this.errList = errList;
    }

    public String getCsvResponse() {
        return this.csvResponse;
    }

    public void setCsvResponse(String csvResponse) {
        this.csvResponse = csvResponse;
    }

    public boolean isErrorOccurred() {
        return false == this.errList.isEmpty();
    }

    protected String getStringValue(Map params, String name) {
        return CommonUtil.getStringValue(params, name, null);
    }

    protected Integer getIntegerValue(Map params, String name) {
        return CommonUtil.getIntegerValue(params, name, null);
    }

    protected BigDecimal getBigDecimalValue(Map params, String name) {
        return CommonUtil.getBigDecimalValue(params, name, null);
    }

    public String toString() {
        int n;
        StringBuffer errCodeBuffer = new StringBuffer(128);
        StringBuffer errInfoBuffer = new StringBuffer(64);
        errCodeBuffer.append("ErrCode").append("=");
        errInfoBuffer.append("ErrInfo").append("=");
        int n2 = n = null == this.errList ? -1 : this.errList.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                errCodeBuffer.append('|');
                errInfoBuffer.append('|');
            }
            ErrHolder errHolder = (ErrHolder)this.errList.get(i);
            errCodeBuffer.append(errHolder.getErrCode());
            errInfoBuffer.append(errHolder.getErrInfo());
        }
        return errCodeBuffer.append('&').append(errInfoBuffer).toString();
    }

    protected String nullToEmpty(Object obj) {
        return CommonUtil.nullToEmpty(obj);
    }

    protected Object getElementSafe(Object[] objects, int index) {
        return CommonUtil.getElementSafe(objects, index);
    }
}

