/*
 * Decompiled with CFR 0.152.
 */
package com.gmo_pg.g_pay.client.input;

import com.gmo_pg.g_pay.client.common.log.Log;
import com.gmo_pg.g_pay.client.common.util.CommonUtil;
import com.gmo_pg.g_pay.client.common.util.IgnoreCaseMap;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class BaseInput
implements Serializable {
    private static final Log log = new Log(BaseInput.class);
    private static final String ENCODE = "Windows-31J";

    public BaseInput() {
        this.setDefaultValues();
    }

    public BaseInput(Map params) {
        Map convertMap = this.convertParamsMap(params);
        this.setDefaultValues();
        this.setInputValues(convertMap);
    }

    protected String encodeStr(Object obj) {
        return this.encodeStr(obj, true);
    }

    protected String encodeStr(Object obj, boolean doEncode) {
        String strValue = this.nullToEmpty(obj);
        if (doEncode) {
            try {
                return URLEncoder.encode(strValue, ENCODE);
            }
            catch (UnsupportedEncodingException e) {
                log.warn("URL\u30a8\u30f3\u30b3\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f \uff1a " + e.getMessage());
            }
        }
        return strValue;
    }

    protected String getStringValue(Map params, String name, String defaultValue) {
        return CommonUtil.getStringValue(params, name, defaultValue);
    }

    protected Integer getIntegerValue(Map params, String name, Integer defaultValue) {
        return CommonUtil.getIntegerValue(params, name, defaultValue);
    }

    protected Long getLongValue(Map params, String name, Long defaultValue) {
        return CommonUtil.getLongValue(params, name, defaultValue);
    }

    protected List getListValue(Map params, String name, List defaultValue) {
        return CommonUtil.getListValue(params, name, defaultValue);
    }

    protected BigDecimal getBigDecimalValue(Map params, String name, BigDecimal defaultValue) {
        return CommonUtil.getBigDecimalValue(params, name, defaultValue);
    }

    protected Map convertParamsMap(Map params) {
        HashMap convert = new HashMap();
        Iterator it = params.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object value = params.get(key);
            if (value instanceof String[]) {
                String[] values = (String[])value;
                value = null == values ? null : (0 == values.length ? "" : values[0]);
            }
            convert.put(key, value);
        }
        return new IgnoreCaseMap((Map)convert);
    }

    protected String nullToEmpty(Object obj) {
        return CommonUtil.nullToEmpty(obj);
    }

    protected abstract void setDefaultValues();

    protected abstract void setInputValues(Map var1);

    public String toString() {
        return this.toDataString(true);
    }

    public abstract String toDataString(boolean var1);
}

