/*
 * Decompiled with CFR 0.152.
 */
package com.gmo_pg.g_pay.client.common.util;

import com.gmo_pg.g_pay.client.output.ErrHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParamParserUtil {
    private ParamParserUtil() {
    }

    public static Map parse(String params) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (params != null && !params.equals("")) {
            String[] paramArray = params.split("&");
            for (int i = 0; i < paramArray.length; ++i) {
                String[] param = paramArray[i].split("=", 2);
                if (param.length != 2) continue;
                paramMap.put(param[0], param[1]);
            }
        }
        return paramMap;
    }

    public static Map parse(String params, String[] keyList) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (params == null || params.equals("") || keyList == null) {
            return paramMap;
        }
        String lastKeyName = null;
        String[] paramArray = params.split("&");
        for (int i = 0; i < paramArray.length; ++i) {
            String[] param = paramArray[i].split("=", 2);
            if (param.length < 2 && lastKeyName != null) {
                paramMap.put(lastKeyName, paramMap.get(lastKeyName) + "&" + paramArray[i]);
                continue;
            }
            boolean match = false;
            for (int j = 0; j < keyList.length; ++j) {
                if (!param[0].equals(keyList[j])) continue;
                match = true;
                break;
            }
            if (match) {
                paramMap.put(param[0], param[1]);
                lastKeyName = param[0];
                continue;
            }
            if (lastKeyName == null) continue;
            paramMap.put(lastKeyName, paramMap.get(lastKeyName) + "&" + paramArray[i]);
        }
        return paramMap;
    }

    public static List errParse(String errCode, String errInfo) {
        String[] errInfoArray;
        ArrayList<ErrHolder> errList = new ArrayList<ErrHolder>();
        String unKnown = "unknown";
        String[] errCodeArray = errCode.split("\\|");
        int length = errCodeArray.length > (errInfoArray = errInfo.split("\\|")).length ? errCodeArray.length : errInfoArray.length;
        for (int i = 0; i < length; ++i) {
            ErrHolder errHolder = new ErrHolder();
            if (i > errCodeArray.length - 1) {
                errHolder.setErrCode(unKnown);
            } else {
                errHolder.setErrCode(errCodeArray[i]);
            }
            if (i > errInfoArray.length - 1) {
                errHolder.setErrInfo(unKnown);
            } else {
                errHolder.setErrInfo(errInfoArray[i]);
            }
            errList.add(errHolder);
        }
        return errList;
    }

    public static Map parseCsv(String params, String[] keyList) {
        if (params == null || params.equals("") || keyList == null) {
            return new HashMap();
        }
        String[] paramArray = params.split("&");
        if (paramArray.length == 1) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("CsvResponse", params);
            return paramMap;
        }
        return ParamParserUtil.parse(params, keyList);
    }

    public static Map searchTrademultiParse(String params) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (params == null || params.equals("")) {
            return paramMap;
        }
        String[] paramArray = params.split("&");
        for (int i = 0; i < paramArray.length; ++i) {
            String[] param = paramArray[i].split("=", 2);
            paramMap.put(param[0], param[1]);
        }
        return paramMap;
    }
}

