/*
 * Decompiled with CFR 0.152.
 */
package com.gmo_pg.g_pay.client.common.util;

import com.gmo_pg.g_pay.client.common.PaymentException;
import com.gmo_pg.g_pay.client.common.util.IgnoreCaseMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class ConnectUrlMap {
    private static final String PROP_PATH = "conf/connector.properties";
    private Map urlMap;

    public ConnectUrlMap() throws PaymentException {
        this.init();
    }

    private void init() throws PaymentException {
        InputStream in = null;
        try {
            Properties prop = new Properties();
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream(PROP_PATH);
            if (null == in) {
                throw new PaymentException("\u63a5\u7d9a\u5148URL\u60c5\u5831\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093");
            }
            prop.load(in);
            this.urlMap = new IgnoreCaseMap((Map)prop);
        }
        catch (IOException e) {
            throw new PaymentException("\u63a5\u7d9a\u5148URL\u60c5\u5831\u306e\u8aad\u8fbc\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                throw new PaymentException("\u63a5\u7d9a\u5148URL\u60c5\u5831\u306e\u8aad\u8fbc\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
            }
        }
    }

    public String getUrl(String key) {
        return (String)this.urlMap.get(key);
    }
}

