/*
 * Decompiled with CFR 0.152.
 */
package com.gmo_pg.g_pay.client.common.util;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public class CommonUtil {
    private CommonUtil() {
    }

    public static String nullToEmpty(Object obj) {
        return null == obj ? "" : String.valueOf(obj);
    }

    public static String getStringValue(Map params, String name, String defaultValue) {
        if (!params.containsKey(name)) {
            return defaultValue;
        }
        Object objValue = params.get(name);
        String strValue = CommonUtil.nullToEmpty(objValue);
        return strValue;
    }

    public static Integer getIntegerValue(Map params, String name, Integer defaultValue) {
        if (!params.containsKey(name)) {
            return defaultValue;
        }
        Object objValue = params.get(name);
        String strValue = CommonUtil.nullToEmpty(objValue);
        if (null == strValue || 0 == strValue.length()) {
            return null;
        }
        return Integer.valueOf(strValue);
    }

    public static Long getLongValue(Map params, String name, Long defaultValue) {
        if (!params.containsKey(name)) {
            return defaultValue;
        }
        Object objValue = params.get(name);
        String strValue = CommonUtil.nullToEmpty(objValue);
        if (null == strValue || 0 == strValue.length()) {
            return null;
        }
        return Long.valueOf(strValue);
    }

    public static List getListValue(Map params, String name, List defaultValue) {
        if (!params.containsKey(name)) {
            return defaultValue;
        }
        Object objValue = params.get(name);
        if (objValue instanceof List) {
            return (List)objValue;
        }
        return defaultValue;
    }

    public static BigDecimal getBigDecimalValue(Map params, String name, BigDecimal defaultValue) {
        if (!params.containsKey(name)) {
            return defaultValue;
        }
        Object objValue = params.get(name);
        String strValue = CommonUtil.nullToEmpty(objValue);
        if (null == strValue || 0 == strValue.length()) {
            return null;
        }
        return new BigDecimal(strValue);
    }

    public static Object getElementSafe(Object[] objects, int index) {
        if (index < 0 || index >= objects.length) {
            return null;
        }
        return objects[index];
    }

    public static boolean isEmpty(String val) {
        return null == val || val.length() == 0;
    }

    public static boolean isNotEmpty(String val) {
        return !CommonUtil.isEmpty(val);
    }
}

