/*
 * Decompiled with CFR 0.152.
 */
package com.gmo_pg.g_pay.client.common.log;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    private static final String FORMAT = "{0,date} {0,time}";
    private static final String LN = System.getProperty("line.separator", "\n");
    private static final Map levelStrMap = new HashMap(){
        {
            this.put(Level.ALL, "ALL");
            this.put(Level.CONFIG, "CONFIG");
            this.put(Level.FINE, "DEBUG");
            this.put(Level.FINER, "TRACE");
            this.put(Level.FINEST, "VERBOSE");
            this.put(Level.INFO, "INFO");
            this.put(Level.OFF, "OFF");
            this.put(Level.SEVERE, "ERROR");
            this.put(Level.WARNING, "WARN");
        }
    };
    private MessageFormat formatter = new MessageFormat("{0,date} {0,time}");
    private Object[] args = new Object[1];
    private Date date = new Date();

    private String getLoggerSimpleName(String loggerName) {
        if (null == loggerName) {
            return loggerName;
        }
        return loggerName.substring(loggerName.lastIndexOf(46) + 1);
    }

    private String getLevelStr(Level level) {
        String levelStr = (String)levelStrMap.get(level);
        return null == levelStr ? "UNKNOWN" : levelStr;
    }

    public String format(LogRecord record) {
        this.date.setTime(record.getMillis());
        this.args[0] = this.date;
        StringBuffer text = new StringBuffer(20);
        this.formatter.format(this.args, text, (FieldPosition)null);
        String message = this.formatMessage(record);
        String loggerSimpleName = this.getLoggerSimpleName(record.getLoggerName());
        String levelStr = this.getLevelStr(record.getLevel());
        StringBuffer buffer = new StringBuffer(128);
        buffer.append(text);
        buffer.append(' ');
        buffer.append(loggerSimpleName);
        buffer.append(" [");
        buffer.append(levelStr);
        buffer.append("]: ");
        buffer.append(message);
        buffer.append(LN);
        return buffer.toString();
    }
}

