/*
 * Decompiled with CFR 0.152.
 */
package com.gmo_pg.g_pay.client.common.log;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class Log {
    private static final Object[] DUMMY_PARAMS = new Object[0];
    private Logger logger;

    private static void init() throws IOException {
        String defaultPath = "conf/logging.properties";
        String propertiesPath = System.getProperty("java.util.logging.config.file", "conf/logging.properties");
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(propertiesPath);
        if (null == in) {
            return;
        }
        try {
            LogManager.getLogManager().readConfiguration(in);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            in.close();
        }
    }

    public Log(Class clazz) {
        this.logger = Logger.getLogger(clazz.getName());
    }

    private void log(Level level, String message, Object[] params) {
        this.logger.log(level, message, params);
    }

    public void debug(String message) {
        this.debug(message, DUMMY_PARAMS);
    }

    public void debug(String message, Object[] params) {
        if (this.isDebugEnabled()) {
            this.log(Level.FINE, message, params);
        }
    }

    public void warn(String message) {
        this.warn(message, DUMMY_PARAMS);
    }

    public void warn(String message, Object[] params) {
        if (this.isWarnEnabled()) {
            this.log(Level.WARNING, message, params);
        }
    }

    public void info(String message) {
        this.info(message, DUMMY_PARAMS);
    }

    public void info(String message, Object[] params) {
        if (this.isInfoEnabled()) {
            this.log(Level.INFO, message, params);
        }
    }

    public void error(String message) {
        this.error(message, DUMMY_PARAMS);
    }

    public void error(String message, Object[] params) {
        if (this.isErrorEnabled()) {
            this.log(Level.SEVERE, message, params);
        }
    }

    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    static {
        try {
            Log.init();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

