/*
 * Decompiled with CFR 0.152.
 */
package jp.co.smbcfs.station.sdk.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtil {
    private static final char[] WINDOWS31J_CHARS;
    private static String[] zenkaku;
    private static String[] hankaku;
    private static String[] zenkakuKana;
    private static String[] hankakuKana;
    private static String[] zenkakuAlpha;
    private static String[] hankakuAlpha;
    private static HashMap<String, String> hankakuMap;
    private static HashMap<String, String> zenkakuMap;
    private static HashMap<String, String> hankakuKanaMap;
    private static HashMap<String, String> zenkakuKanaMap;
    private static HashMap<String, String> hankakuAlphaMap;
    private static HashMap<String, String> zenkakuAlphaMap;
    private static String[] HYPHENS;

    public static String getByteSubstring(String data, int len) {
        return StringUtil.getByteSubstring(data, 0, len, false);
    }

    public static String getByteSubstring(String data, int beginIndex, int endIndex, boolean trunc) throws IllegalArgumentException, StringIndexOutOfBoundsException {
        int temp_len;
        if (data == null) {
            return null;
        }
        if (data == null || beginIndex > endIndex || beginIndex < 0 || beginIndex > StringUtil.countLetters(data)) {
            return "";
        }
        int begin = 0;
        int total = 0;
        StringBuffer rtn = new StringBuffer();
        int i = 0;
        while (i < beginIndex) {
            temp_len = StringUtil.countLetters(data.substring(begin, begin + 1));
            if ((i += temp_len) > beginIndex) {
                ++total;
                if (!trunc) {
                    rtn.append(data.substring(begin, begin + 1));
                }
            }
            ++begin;
        }
        for (i = begin; i < data.length() && (total += (temp_len = StringUtil.countLetters(data.substring(i, i + 1)))) <= endIndex - beginIndex; ++i) {
            rtn.append(data.substring(i, i + 1));
        }
        return rtn.toString();
    }

    public static String addFormatSymbols(String s) {
        return StringUtil.addFormatSymbols(s, null);
    }

    public static String addFormatSymbols(String s, String s2) {
        String result = StringUtil.toDecimalFormat(s, "###,###,###,###,###.##########");
        if (s2 == null) {
            return result;
        }
        if (result == null || result.equals("")) {
            return "";
        }
        return s2 + result;
    }

    public static String removeFormatSymbols(String s) {
        int iindex;
        if (s == null || s.equals("")) {
            return "";
        }
        while ((iindex = s.indexOf(",")) != -1) {
            String strbefore = s.substring(0, iindex);
            String strafter = s.substring(iindex + 1);
            s = strbefore + strafter;
        }
        return s;
    }

    public static String toDecimalFormat(String s, String pattern) {
        if (s == null || s.equals("")) {
            return "";
        }
        DecimalFormat format = new DecimalFormat(pattern);
        format.setMaximumFractionDigits(10);
        return format.format(Double.parseDouble(s));
    }

    public static String replaceString(String s, String fromString, String toString) {
        return StringUtil.replaceString(s, fromString, toString, true);
    }

    public static String replaceString(String s, String fromString, String toString, boolean isAll) {
        int index;
        if (s == null) {
            return null;
        }
        int posFrom = 0;
        while ((index = s.indexOf(fromString, posFrom)) != -1) {
            String strbefore = s.substring(0, index);
            String strafter = s.substring(index + fromString.length());
            s = strbefore + toString + strafter;
            posFrom = index + toString.length();
            if (isAll) continue;
            break;
        }
        return s;
    }

    public static String trimNumberString(String s, int len) {
        return StringUtil.trimNumberString(s, len, '0');
    }

    public static String trimNumberString(String s, int keta, char c) {
        try {
            String result = s;
            int len = s.length();
            if (keta == 0) {
                for (int i = 0; i < len - 1 && result.charAt(0) == '0'; ++i) {
                    result = result.substring(1);
                }
            } else if (keta > len) {
                for (int i = 0; i < keta - len; ++i) {
                    result = c + result;
                }
            } else if (keta < len) {
                result = result.substring(len - keta);
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String trimString(String s, int keta, char c) {
        String result = s;
        int len = result.length();
        if (len >= keta) {
            return result.substring(0, keta);
        }
        for (int i = 0; i < keta - len; ++i) {
            result = result + c;
        }
        return result;
    }

    public static String[] getNullTokenData(String s) {
        return StringUtil.getNullTokenData(s, ",");
    }

    public static String[] getNullTokenData(String s, boolean isTrim) {
        return StringUtil.getNullTokenData(s, ",", isTrim);
    }

    public static String[] getNullTokenData(String s, String delimiter) {
        return StringUtil.getNullTokenData(s, delimiter, false);
    }

    public static String[] getNullTokenData(String s, String delimiter, boolean isTrim) {
        Vector<String> items = new Vector<String>();
        int posFrom = 0;
        int posTo = 0;
        while (true) {
            int posFrom2 = posFrom;
            while ((posTo = s.indexOf(delimiter, posFrom2)) != -1) {
                int posQuote = s.indexOf("\"", posFrom);
                if (posQuote > posTo) {
                    posQuote = -1;
                }
                if (posQuote == -1 || !s.substring(posFrom, posFrom + 1).equals("\"")) break;
                if (s.substring(posFrom, posFrom + 1).equals("\"") && s.substring(posTo - 1, posTo).equals("\"") && posTo - posFrom > 1) {
                    boolean flg = true;
                    int i = 0;
                    while (posTo - i - 2 > posFrom) {
                        if (s.substring(posTo - i - 1, posTo - i).equals("\"")) {
                            if (!s.substring(posTo - i - 2, posTo - i - 1).equals("\"")) {
                                break;
                            }
                        } else {
                            flg = false;
                            break;
                        }
                        i += 2;
                    }
                    if (flg) break;
                }
                posFrom2 = posTo + 1;
            }
            if (posTo == -1) break;
            if (posFrom == posTo) {
                items.addElement("");
            } else {
                String item = s.substring(posFrom, posTo);
                if (item.startsWith("\"") && item.endsWith("\"")) {
                    item = item.substring(1, item.length() - 1);
                }
                if (isTrim) {
                    items.addElement(item.trim());
                } else {
                    items.addElement(item);
                }
            }
            posFrom = posTo + delimiter.length();
        }
        if (s.length() > posFrom) {
            String item = s.substring(posFrom);
            if (item.startsWith("\"") && item.endsWith("\"") && item.length() > 1) {
                item = item.substring(1, item.length() - 1);
            }
            if (isTrim) {
                items.addElement(item.trim());
            } else {
                items.addElement(item);
            }
        } else {
            items.addElement("");
        }
        return items.toArray(new String[0]);
    }

    public static String removeReturnCode(String s) {
        String rtn = StringUtil.replaceString(s, "\r\n", "");
        return StringUtil.replaceString(rtn, "\n", "");
    }

    public static String toLf(String s) {
        String rtn = StringUtil.replaceString(s, "\r\n", "\n");
        rtn = StringUtil.replaceString(rtn, "\r", "\n");
        return rtn;
    }

    public static String toCrLf(String s) {
        String rtn = StringUtil.toLf(s);
        rtn = StringUtil.replaceString(rtn, "\n", "\r\n");
        return rtn;
    }

    public static String cookieListGetAt(String list, int pos) {
        return StringUtil.listGetAt(list, pos, "&");
    }

    public static String listGetAt(String list, int pos) {
        return StringUtil.listGetAt(list, pos, ",");
    }

    public static String listGetAt(String list, int pos, String delimiter) {
        if (list == null) {
            return null;
        }
        StringTokenizer token = new StringTokenizer(list, delimiter, true);
        int now = 0;
        boolean existDelimiter = false;
        while (token.hasMoreTokens()) {
            String item = token.nextToken();
            if (item.equals(delimiter)) {
                if (now == pos) {
                    return null;
                }
                existDelimiter = !existDelimiter;
                ++now;
                continue;
            }
            if (now != pos) continue;
            return item;
        }
        return null;
    }

    public static String getMd5String(String st) {
        StringBuffer mdst = new StringBuffer();
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] btst = st.getBytes();
            md.update(btst);
            byte[] mdbt = md.digest();
            for (int i = 0; i < mdbt.length; ++i) {
                int r;
                int n = r = mdbt[i] >= 0 ? mdbt[i] : 256 + mdbt[i];
                if (r < 16) {
                    mdst.append("0");
                }
                mdst.append(Integer.toString(r, 16));
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return mdst.toString();
    }

    public static int stringArrayIndexOf(String[] keyList, String key) {
        return StringUtil.stringArrayIndexOf(keyList, key, true);
    }

    public static int stringArrayIndexOf(String[] keyList, String key, boolean isStrict) {
        if (keyList == null || key == null) {
            return -1;
        }
        for (int i = 0; i < keyList.length; ++i) {
            int pos;
            if (!(isStrict ? keyList[i].equals(key) : (pos = keyList[i].indexOf(key)) >= 0)) continue;
            return i;
        }
        return -1;
    }

    public static String[] concatStringArray(String[] array1, String[] array2) {
        if (array1 == null) {
            array1 = new String[]{};
        }
        if (array2 == null) {
            array2 = new String[]{};
        }
        String[] rtnArray = new String[array1.length + array2.length];
        System.arraycopy(array1, 0, rtnArray, 0, array1.length);
        System.arraycopy(array2, 0, rtnArray, array1.length, array2.length);
        return rtnArray;
    }

    public static String getBlank(int len) {
        String data = "";
        for (int i = 0; i < len; ++i) {
            data = data + " ";
        }
        return data;
    }

    public static String stringDeepCopy(String target) {
        if (target == null) {
            return null;
        }
        return new String(target);
    }

    public static String[] stringArrayDeepCopy(String[] target) {
        if (target == null) {
            return null;
        }
        String[] ret = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            ret[i] = new String(target[i]);
        }
        return ret;
    }

    public static String[][] stringArrayDeepCopy(String[][] target) {
        if (target == null || target.length == 0) {
            return null;
        }
        String[][] ret = new String[target.length][target[0].length];
        for (int i = 0; i < target.length; ++i) {
            for (int i2 = 0; i2 < target[0].length; ++i2) {
                ret[i][i2] = target[i][i2] == null ? null : new String(target[i][i2]);
            }
        }
        return ret;
    }

    public static boolean isPatternMatch(String regularExpression, String target) {
        if (regularExpression != null && target != null) {
            Pattern pattern = Pattern.compile(regularExpression);
            Matcher matcher = pattern.matcher(target);
            return matcher.matches();
        }
        return false;
    }

    public static String toJis(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer ret = new StringBuffer();
        int len = s.length();
        block10: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\u00ad': {
                    ret.append('-');
                    continue block10;
                }
                case '\u2015': {
                    ret.append('\u2014');
                    continue block10;
                }
                case '\uff5e': {
                    ret.append('\u301c');
                    continue block10;
                }
                case '\u2225': {
                    ret.append('\u2016');
                    continue block10;
                }
                case '\uff0d': {
                    ret.append('\u2212');
                    continue block10;
                }
                case '\uffe0': {
                    ret.append('\u00a2');
                    continue block10;
                }
                case '\uffe1': {
                    ret.append('\u00a3');
                    continue block10;
                }
                case '\uffe2': {
                    ret.append('\u00ac');
                    continue block10;
                }
                default: {
                    ret.append(ch);
                }
            }
        }
        return new String(ret);
    }

    public static String toMs932(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer ret = new StringBuffer();
        int len = s.length();
        block10: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\u00ad': {
                    ret.append('-');
                    continue block10;
                }
                case '\u2014': {
                    ret.append('\u2015');
                    continue block10;
                }
                case '\u301c': {
                    ret.append('\uff5e');
                    continue block10;
                }
                case '\u2016': {
                    ret.append('\u2225');
                    continue block10;
                }
                case '\u2212': {
                    ret.append('\uff0d');
                    continue block10;
                }
                case '\u00a2': {
                    ret.append('\uffe0');
                    continue block10;
                }
                case '\u00a3': {
                    ret.append('\uffe1');
                    continue block10;
                }
                case '\u00ac': {
                    ret.append('\uffe2');
                    continue block10;
                }
                default: {
                    ret.append(ch);
                }
            }
        }
        return new String(ret);
    }

    public static boolean containsKishuIzon(String s) {
        if (s == null) {
            return true;
        }
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char target = chars[i];
            if (Arrays.binarySearch(WINDOWS31J_CHARS, target) < 0) continue;
            return true;
        }
        return false;
    }

    public static String toHankaku(String value) {
        return StringUtil.convertStringFormat(hankakuMap, value);
    }

    public static String toZenkaku(String value) {
        return StringUtil.convertStringFormat(zenkakuMap, value);
    }

    public static String toZenkakuKanaAndHankakuAlpha(String value) {
        String ret = StringUtil.convertStringFormat(zenkakuKanaMap, value);
        return StringUtil.convertStringFormat(hankakuAlphaMap, ret);
    }

    private static String convertStringFormat(Map<String, String> map, String value) {
        if (value == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < value.length(); ++i) {
            String s2;
            String s = value.substring(i, i + 1);
            if (i < value.length() - 1 && map.containsKey(s2 = value.substring(i, i + 2))) {
                buf.append(map.get(s2));
                ++i;
                continue;
            }
            if (map.containsKey(s)) {
                buf.append(map.get(s));
                continue;
            }
            buf.append(s);
        }
        return buf.toString();
    }

    public static String replaceTokusyu(String str) {
        if (str == null) {
            return str;
        }
        str = StringUtil.replaceString(str, ",", "\u3001");
        str = StringUtil.replaceString(str, "'", "\u2019");
        return str;
    }

    public static int countString(String str, int countChar) {
        int count = 0;
        int pos = 0;
        while ((pos = str.indexOf(countChar, pos)) != -1) {
            ++count;
            ++pos;
        }
        return count;
    }

    public static int countString(String str, String countStr) {
        int count = 0;
        int pos = 0;
        while ((pos = str.indexOf(countStr, pos)) != -1) {
            ++count;
            pos += countStr.length();
        }
        return count;
    }

    public static String toList(String[] target) {
        return StringUtil.toList(target, ",", true, true);
    }

    public static String toList(String[] target, String delimiter, boolean quoteString, boolean escapeQuote) {
        if (target == null) {
            return null;
        }
        if (target.length == 0) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < target.length; ++i) {
            String value;
            if (i > 0) {
                buff.append(delimiter);
            }
            if ((value = target[i]) == null) {
                value = "";
            }
            if (escapeQuote) {
                value = StringUtil.replaceString(value, "\"", "\"\"");
            }
            if (quoteString) {
                value = "\"" + value + "\"";
            }
            buff.append(value);
        }
        return buff.toString();
    }

    public static String replaceHyphen(String s, String replaceTo) {
        for (String h : HYPHENS) {
            s = s.replace(h, replaceTo);
        }
        return s;
    }

    public static String filterString(String s, String filterChars) {
        if (s == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (filterChars.indexOf(c) == -1) continue;
            result.append(c);
        }
        return result.toString();
    }

    public static String filterAlphabetNumericString(String s) {
        return StringUtil.filterString(s, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz");
    }

    public static String filterAlphabetString(String s) {
        return StringUtil.filterString(s, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz");
    }

    public static int countLetters(String s) {
        int num = 0;
        for (int i = 0; i < s.length(); ++i) {
            char nowChar = s.charAt(i);
            if (s.charAt(i) <= '\u00ff') {
                if (nowChar == '\u0085' || nowChar == '\u0086' || nowChar == '\u0087' || nowChar == '\u0089' || nowChar == '\u0091' || nowChar == '\u0092' || nowChar == '\u0093' || nowChar == '\u0094' || nowChar == '\u00a7' || nowChar == '\u00a8' || nowChar == '\u00b0' || nowChar == '\u00b1' || nowChar == '\u00b4' || nowChar == '\u00b6' || nowChar == '\u00d7' || nowChar == '\u00f7') {
                    num += 2;
                    continue;
                }
                ++num;
                continue;
            }
            if (nowChar >= '\uff61' && nowChar <= '\uff9f') {
                ++num;
                continue;
            }
            num += 2;
        }
        return num;
    }

    public static String getNull(String data) {
        return StringUtil.getNull(data, "");
    }

    public static String getNull(String data, String null_data) {
        if (data == null || data.equals("")) {
            return null_data;
        }
        return data;
    }

    static {
        int i;
        WINDOWS31J_CHARS = new char[]{'\u2116', '\u2121', '\u2160', '\u2161', '\u2162', '\u2163', '\u2164', '\u2165', '\u2166', '\u2167', '\u2168', '\u2169', '\u2170', '\u2171', '\u2172', '\u2173', '\u2174', '\u2175', '\u2176', '\u2177', '\u2178', '\u2179', '\u2211', '\u221a', '\u221f', '\u2220', '\u2229', '\u222a', '\u222b', '\u222e', '\u2235', '\u2252', '\u2261', '\u22a5', '\u22bf', '\u2460', '\u2461', '\u2462', '\u2463', '\u2464', '\u2465', '\u2466', '\u2467', '\u2468', '\u2469', '\u246a', '\u246b', '\u246c', '\u246d', '\u246e', '\u246f', '\u2470', '\u2471', '\u2472', '\u2473', '\u301d', '\u301f', '\u3231', '\u3232', '\u3239', '\u32a4', '\u32a5', '\u32a6', '\u32a7', '\u32a8', '\u3303', '\u330d', '\u3314', '\u3318', '\u3322', '\u3323', '\u3326', '\u3327', '\u332b', '\u3336', '\u333b', '\u3349', '\u334a', '\u334d', '\u3351', '\u3357', '\u337b', '\u337c', '\u337d', '\u337e', '\u338e', '\u338f', '\u339c', '\u339d', '\u339e', '\u33a1', '\u33c4', '\u33cd', '\u4e28', '\u4ee1', '\u4efc', '\u4f00', '\u4f03', '\u4f39', '\u4f56', '\u4f8a', '\u4f92', '\u4f94', '\u4f9a', '\u4fc9', '\u4fcd', '\u4fff', '\u501e', '\u5022', '\u5040', '\u5042', '\u5046', '\u5070', '\u5094', '\u50d8', '\u50f4', '\u514a', '\u5164', '\u519d', '\u51be', '\u51ec', '\u5215', '\u529c', '\u52a6', '\u52af', '\u52c0', '\u52db', '\u5300', '\u5307', '\u5324', '\u5372', '\u5393', '\u53b2', '\u53dd', '\u548a', '\u549c', '\u54a9', '\u54ff', '\u5586', '\u5759', '\u5765', '\u57ac', '\u57c7', '\u57c8', '\u589e', '\u58b2', '\u590b', '\u5953', '\u595b', '\u595d', '\u5963', '\u59a4', '\u59ba', '\u5b56', '\u5bc0', '\u5bd8', '\u5bec', '\u5c1e', '\u5ca6', '\u5cba', '\u5cf5', '\u5d27', '\u5d42', '\u5d53', '\u5d6d', '\u5db8', '\u5db9', '\u5dd0', '\u5f21', '\u5f34', '\u5f45', '\u5f67', '\u5fb7', '\u5fde', '\u605d', '\u6085', '\u608a', '\u60d5', '\u60de', '\u60f2', '\u6111', '\u6120', '\u6130', '\u6137', '\u6198', '\u6213', '\u62a6', '\u63f5', '\u6460', '\u649d', '\u64ce', '\u654e', '\u6600', '\u6609', '\u6615', '\u661e', '\u6624', '\u662e', '\u6631', '\u663b', '\u6657', '\u6659', '\u6665', '\u6673', '\u6699', '\u66a0', '\u66b2', '\u66bf', '\u66fa', '\u66fb', '\u670e', '\u6766', '\u67bb', '\u67c0', '\u6801', '\u6844', '\u6852', '\u68c8', '\u68cf', '\u6968', '\u6998', '\u69e2', '\u6a30', '\u6a46', '\u6a6b', '\u6a73', '\u6a7e', '\u6ae2', '\u6ae4', '\u6bd6', '\u6c3f', '\u6c5c', '\u6c6f', '\u6c86', '\u6cda', '\u6d04', '\u6d6f', '\u6d87', '\u6d96', '\u6dac', '\u6dcf', '\u6df2', '\u6df8', '\u6dfc', '\u6e27', '\u6e39', '\u6e3c', '\u6e5c', '\u6ebf', '\u6f88', '\u6fb5', '\u6ff5', '\u7005', '\u7007', '\u7028', '\u7085', '\u70ab', '\u70bb', '\u7104', '\u710f', '\u7146', '\u7147', '\u715c', '\u71c1', '\u71fe', '\u72b1', '\u72be', '\u7324', '\u7377', '\u73bd', '\u73c9', '\u73d2', '\u73d6', '\u73e3', '\u73f5', '\u7407', '\u7426', '\u7429', '\u742a', '\u742e', '\u7462', '\u7489', '\u749f', '\u7501', '\u752f', '\u756f', '\u7682', '\u769b', '\u769c', '\u769e', '\u76a6', '\u7746', '\u7821', '\u784e', '\u7864', '\u787a', '\u7930', '\u7994', '\u799b', '\u7ad1', '\u7ae7', '\u7aeb', '\u7b9e', '\u7d48', '\u7d5c', '\u7da0', '\u7db7', '\u7dd6', '\u7e52', '\u7e8a', '\u7f47', '\u7fa1', '\u8301', '\u8362', '\u837f', '\u83c7', '\u83f6', '\u8448', '\u84b4', '\u84dc', '\u8553', '\u8559', '\u856b', '\u85b0', '\u8807', '\u88f5', '\u891c', '\u8a12', '\u8a37', '\u8a79', '\u8aa7', '\u8abe', '\u8adf', '\u8af6', '\u8b53', '\u8b7f', '\u8cf0', '\u8cf4', '\u8d12', '\u8d76', '\u8ecf', '\u9067', '\u90de', '\u9115', '\u9127', '\u91d7', '\u91da', '\u91de', '\u91e4', '\u91e5', '\u91ed', '\u91ee', '\u9206', '\u920a', '\u9210', '\u9239', '\u923a', '\u923c', '\u9240', '\u924e', '\u9251', '\u9259', '\u9267', '\u9277', '\u9278', '\u9288', '\u92a7', '\u92d0', '\u92d3', '\u92d5', '\u92d7', '\u92d9', '\u92e0', '\u92e7', '\u92f9', '\u92fb', '\u92ff', '\u9302', '\u931d', '\u931e', '\u9321', '\u9325', '\u9348', '\u9357', '\u9370', '\u93a4', '\u93c6', '\u93de', '\u93f8', '\u9431', '\u9445', '\u9448', '\u9592', '\u969d', '\u96af', '\u9733', '\u973b', '\u9743', '\u974d', '\u974f', '\u9751', '\u9755', '\u9857', '\u9865', '\u9927', '\u999e', '\u9a4e', '\u9ad9', '\u9adc', '\u9b72', '\u9b75', '\u9b8f', '\u9bb1', '\u9bbb', '\u9c00', '\u9d6b', '\u9d70', '\u9e19', '\u9ed1', '\uf929', '\uf9dc', '\ufa0e', '\ufa0f', '\ufa10', '\ufa11', '\ufa12', '\ufa13', '\ufa14', '\ufa15', '\ufa16', '\ufa17', '\ufa18', '\ufa19', '\ufa1a', '\ufa1b', '\ufa1c', '\ufa1d', '\ufa1e', '\ufa1f', '\ufa20', '\ufa21', '\ufa22', '\ufa23', '\ufa24', '\ufa25', '\ufa26', '\ufa27', '\ufa28', '\ufa29', '\ufa2a', '\ufa2b', '\ufa2c', '\ufa2d', '\uff02', '\uff07', '\uffe2', '\uffe4', '\ufffd'};
        zenkaku = new String[]{"\u3000", "\u309b", "\u309c", "\u30a1", "\u30a2", "\u30a3", "\u30a4", "\u30a5", "\u30a6", "\u30a7", "\u30a8", "\u30a9", "\u30aa", "\u30ab", "\u30ac", "\u30ad", "\u30ae", "\u30af", "\u30b0", "\u30b1", "\u30b2", "\u30b3", "\u30b4", "\u30b5", "\u30b6", "\u30b7", "\u30b8", "\u30b9", "\u30ba", "\u30bb", "\u30bc", "\u30bd", "\u30be", "\u30bf", "\u30c0", "\u30c1", "\u30c2", "\u30c3", "\u30c4", "\u30c5", "\u30c6", "\u30c7", "\u30c8", "\u30c9", "\u30ca", "\u30cb", "\u30cc", "\u30cd", "\u30ce", "\u30cf", "\u30d0", "\u30d1", "\u30d2", "\u30d3", "\u30d4", "\u30d5", "\u30d6", "\u30d7", "\u30d8", "\u30d9", "\u30da", "\u30db", "\u30dc", "\u30dd", "\u30de", "\u30df", "\u30e0", "\u30e1", "\u30e2", "\u30e3", "\u30e4", "\u30e5", "\u30e6", "\u30e7", "\u30e8", "\u30e9", "\u30ea", "\u30eb", "\u30ec", "\u30ed", "\u30ef", "\u30f2", "\u30f3", "\u30f4", "\u30fc", "\uff21", "\uff22", "\uff23", "\uff24", "\uff25", "\uff26", "\uff27", "\uff28", "\uff29", "\uff2a", "\uff2b", "\uff2c", "\uff2d", "\uff2e", "\uff2f", "\uff30", "\uff31", "\uff32", "\uff33", "\uff34", "\uff35", "\uff36", "\uff37", "\uff38", "\uff39", "\uff3a", "\uff41", "\uff42", "\uff43", "\uff44", "\uff45", "\uff46", "\uff47", "\uff48", "\uff49", "\uff4a", "\uff4b", "\uff4c", "\uff4d", "\uff4e", "\uff4f", "\uff50", "\uff51", "\uff52", "\uff53", "\uff54", "\uff55", "\uff56", "\uff57", "\uff58", "\uff59", "\uff5a", "\uff10", "\uff11", "\uff12", "\uff13", "\uff14", "\uff15", "\uff16", "\uff17", "\uff18", "\uff19", "\uff01", "\u201d", "\uff03", "\uff04", "\uff05", "\uff06", "\u2019", "\uff08", "\uff09", "\uff0a", "\uff0b", "\uff0c", "\uff0d", "\uff0e", "\uff0f", "\uff1a", "\uff1b", "\uff1c", "\uff1d", "\uff1e", "\uff1f", "\uff20", "\uff3b", "\uffe5", "\uff3d", "\uff3e", "\uff3f", "\uff40", "\uff5b", "\uff5c", "\uff5d", "\uff5e", "\u3002", "\u300c", "\u300d", "\u3001", "\u30fb"};
        hankaku = new String[]{" ", "\uff9e", "\uff9f", "\uff67", "\uff71", "\uff68", "\uff72", "\uff69", "\uff73", "\uff6a", "\uff74", "\uff6b", "\uff75", "\uff76", "\uff76\uff9e", "\uff77", "\uff77\uff9e", "\uff78", "\uff78\uff9e", "\uff79", "\uff79\uff9e", "\uff7a", "\uff7a\uff9e", "\uff7b", "\uff7b\uff9e", "\uff7c", "\uff7c\uff9e", "\uff7d", "\uff7d\uff9e", "\uff7e", "\uff7e\uff9e", "\uff7f", "\uff7f\uff9e", "\uff80", "\uff80\uff9e", "\uff81", "\uff81\uff9e", "\uff6f", "\uff82", "\uff82\uff9e", "\uff83", "\uff83\uff9e", "\uff84", "\uff84\uff9e", "\uff85", "\uff86", "\uff87", "\uff88", "\uff89", "\uff8a", "\uff8a\uff9e", "\uff8a\uff9f", "\uff8b", "\uff8b\uff9e", "\uff8b\uff9f", "\uff8c", "\uff8c\uff9e", "\uff8c\uff9f", "\uff8d", "\uff8d\uff9e", "\uff8d\uff9f", "\uff8e", "\uff8e\uff9e", "\uff8e\uff9f", "\uff8f", "\uff90", "\uff91", "\uff92", "\uff93", "\uff6c", "\uff94", "\uff6d", "\uff95", "\uff6e", "\uff96", "\uff97", "\uff98", "\uff99", "\uff9a", "\uff9b", "\uff9c", "\uff66", "\uff9d", "\uff73\uff9e", "\uff70", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "!", "\"", "#", "$", "%", "&", "'", "(", ")", "*", "+", ",", "-", ".", "/", ":", ";", "<", "=", ">", "?", "@", "[", "\\", "]", "^", "_", "`", "{", "|", "}", "~", "\uff61", "\uff62", "\uff63", "\uff64", "\uff65"};
        zenkakuKana = new String[]{"\u309b", "\u309c", "\u30a1", "\u30a2", "\u30a3", "\u30a4", "\u30a5", "\u30a6", "\u30a7", "\u30a8", "\u30a9", "\u30aa", "\u30ab", "\u30ac", "\u30ad", "\u30ae", "\u30af", "\u30b0", "\u30b1", "\u30b2", "\u30b3", "\u30b4", "\u30b5", "\u30b6", "\u30b7", "\u30b8", "\u30b9", "\u30ba", "\u30bb", "\u30bc", "\u30bd", "\u30be", "\u30bf", "\u30c0", "\u30c1", "\u30c2", "\u30c3", "\u30c4", "\u30c5", "\u30c6", "\u30c7", "\u30c8", "\u30c9", "\u30ca", "\u30cb", "\u30cc", "\u30cd", "\u30ce", "\u30cf", "\u30d0", "\u30d1", "\u30d2", "\u30d3", "\u30d4", "\u30d5", "\u30d6", "\u30d7", "\u30d8", "\u30d9", "\u30da", "\u30db", "\u30dc", "\u30dd", "\u30de", "\u30df", "\u30e0", "\u30e1", "\u30e2", "\u30e3", "\u30e4", "\u30e5", "\u30e6", "\u30e7", "\u30e8", "\u30e9", "\u30ea", "\u30eb", "\u30ec", "\u30ed", "\u30ef", "\u30f2", "\u30f3", "\u30f4", "\u30fc"};
        hankakuKana = new String[]{"\uff9e", "\uff9f", "\uff67", "\uff71", "\uff68", "\uff72", "\uff69", "\uff73", "\uff6a", "\uff74", "\uff6b", "\uff75", "\uff76", "\uff76\uff9e", "\uff77", "\uff77\uff9e", "\uff78", "\uff78\uff9e", "\uff79", "\uff79\uff9e", "\uff7a", "\uff7a\uff9e", "\uff7b", "\uff7b\uff9e", "\uff7c", "\uff7c\uff9e", "\uff7d", "\uff7d\uff9e", "\uff7e", "\uff7e\uff9e", "\uff7f", "\uff7f\uff9e", "\uff80", "\uff80\uff9e", "\uff81", "\uff81\uff9e", "\uff6f", "\uff82", "\uff82\uff9e", "\uff83", "\uff83\uff9e", "\uff84", "\uff84\uff9e", "\uff85", "\uff86", "\uff87", "\uff88", "\uff89", "\uff8a", "\uff8a\uff9e", "\uff8a\uff9f", "\uff8b", "\uff8b\uff9e", "\uff8b\uff9f", "\uff8c", "\uff8c\uff9e", "\uff8c\uff9f", "\uff8d", "\uff8d\uff9e", "\uff8d\uff9f", "\uff8e", "\uff8e\uff9e", "\uff8e\uff9f", "\uff8f", "\uff90", "\uff91", "\uff92", "\uff93", "\uff6c", "\uff94", "\uff6d", "\uff95", "\uff6e", "\uff96", "\uff97", "\uff98", "\uff99", "\uff9a", "\uff9b", "\uff9c", "\uff66", "\uff9d", "\uff73\uff9e", "\uff70"};
        zenkakuAlpha = new String[]{"\uff21", "\uff22", "\uff23", "\uff24", "\uff25", "\uff26", "\uff27", "\uff28", "\uff29", "\uff2a", "\uff2b", "\uff2c", "\uff2d", "\uff2e", "\uff2f", "\uff30", "\uff31", "\uff32", "\uff33", "\uff34", "\uff35", "\uff36", "\uff37", "\uff38", "\uff39", "\uff3a", "\uff41", "\uff42", "\uff43", "\uff44", "\uff45", "\uff46", "\uff47", "\uff48", "\uff49", "\uff4a", "\uff4b", "\uff4c", "\uff4d", "\uff4e", "\uff4f", "\uff50", "\uff51", "\uff52", "\uff53", "\uff54", "\uff55", "\uff56", "\uff57", "\uff58", "\uff59", "\uff5a", "\uff10", "\uff11", "\uff12", "\uff13", "\uff14", "\uff15", "\uff16", "\uff17", "\uff18", "\uff19"};
        hankakuAlpha = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
        hankakuMap = new HashMap(hankaku.length);
        zenkakuMap = new HashMap(zenkaku.length);
        hankakuKanaMap = new HashMap(hankakuKana.length);
        zenkakuKanaMap = new HashMap(zenkakuKana.length);
        hankakuAlphaMap = new HashMap(hankakuAlpha.length);
        zenkakuAlphaMap = new HashMap(zenkakuAlpha.length);
        if (zenkaku.length != hankaku.length) {
            throw new RuntimeException("\u534a\u89d2\u30ab\u30ca\u30fb\u30a2\u30eb\u30d5\u30a1\u30d9\u30c3\u30c8\u4e00\u89a7\u3068\u5168\u89d2\u30ab\u30ca\u30fb\u30a2\u30eb\u30d5\u30a1\u30d9\u30c3\u30c8\u4e00\u89a7\u306e\u9577\u3055\u304c\u9055\u3044\u307e\u3059");
        }
        for (i = 0; i < zenkaku.length; ++i) {
            hankakuMap.put(zenkaku[i], hankaku[i]);
            zenkakuMap.put(hankaku[i], zenkaku[i]);
        }
        if (zenkakuKana.length != hankakuKana.length) {
            throw new RuntimeException("\u534a\u89d2\u30ab\u30ca\u4e00\u89a7\u3068\u5168\u89d2\u30ab\u30ca\u4e00\u89a7\u306e\u9577\u3055\u304c\u9055\u3044\u307e\u3059");
        }
        for (i = 0; i < zenkakuKana.length; ++i) {
            hankakuKanaMap.put(zenkakuKana[i], hankakuKana[i]);
            zenkakuKanaMap.put(hankakuKana[i], zenkakuKana[i]);
        }
        if (zenkakuAlpha.length != hankakuAlpha.length) {
            throw new RuntimeException("\u534a\u89d2\u30a2\u30eb\u30d5\u30a1\u30d9\u30c3\u30c8\u4e00\u89a7\u3068\u5168\u89d2\u30a2\u30eb\u30d5\u30a1\u30d9\u30c3\u30c8\u4e00\u89a7\u306e\u9577\u3055\u304c\u9055\u3044\u307e\u3059");
        }
        for (i = 0; i < zenkakuAlpha.length; ++i) {
            hankakuAlphaMap.put(zenkakuAlpha[i], hankakuAlpha[i]);
            zenkakuAlphaMap.put(hankakuAlpha[i], zenkakuAlpha[i]);
        }
        HYPHENS = new String[]{"-", "\u30fc", "\u2010", "\u2015", "\uff0d"};
    }
}

