/*
 * Decompiled with CFR 0.152.
 */
package jp.co.smbcfs.station.sdk.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import jp.co.smbcfs.station.sdk.commons.codec.DecoderException;
import jp.co.smbcfs.station.sdk.commons.codec.binary.Base64;
import jp.co.smbcfs.station.sdk.commons.codec.net.URLCodec;
import jp.co.smbcfs.station.sdk.util.RelaxedX509TrustManager;
import jp.co.smbcfs.station.sdk.util.StringUtil;

public class HttpTusin {
    TreeMap<String, String> parameters = new TreeMap();
    String result = "";
    public static final String MODE_POST = "POST";
    public static final String MODE_GET = "GET";
    private String authId = null;
    private String authPass = null;
    private String authMode = null;

    public void setBasicAuth(String id, String pass) {
        this.authMode = "BASIC";
        this.authId = id;
        this.authPass = pass;
    }

    public void setParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    public void connect(String url) throws MalformedURLException, IOException, NoSuchAlgorithmException, KeyManagementException {
        this.connect(url, MODE_POST);
    }

    public void connect(String url, String mode) throws MalformedURLException, IOException, NoSuchAlgorithmException, KeyManagementException {
        this.connect(url, mode, true);
    }

    public void connect(String url, String mode, boolean isEncode) throws MalformedURLException, IOException, NoSuchAlgorithmException, KeyManagementException {
        this.connect(url, mode, true, "UTF-16");
    }

    public void connect(String url, String mode, boolean isEncode, String enc) throws MalformedURLException, IOException, NoSuchAlgorithmException, KeyManagementException {
        this.connect(url, mode, isEncode, enc, enc, null);
    }

    public void connect(String url, String mode, boolean isEncode, String enc, String sendCharset, String recieveCharset) throws MalformedURLException, IOException, NoSuchAlgorithmException, KeyManagementException {
        if (url.startsWith("https")) {
            // empty if block
        }
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setUseCaches(false);
        connection.setRequestMethod(mode);
        if (url.startsWith("https")) {
            SSLSocketFactory sslsf = null;
            KeyManager[] km = null;
            TrustManager[] tm = new TrustManager[]{new RelaxedX509TrustManager()};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(km, tm, new SecureRandom());
            sslsf = sslContext.getSocketFactory();
            ((HttpsURLConnection)connection).setSSLSocketFactory(sslsf);
            HostnameVerifier hv = new HostnameVerifier(){

                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            ((HttpsURLConnection)connection).setHostnameVerifier(hv);
        }
        if ("BASIC".equals(this.authMode)) {
            connection.setRequestProperty("Authorization", "Basic " + new String(Base64.encodeBase64((this.authId + ":" + this.authPass).getBytes())));
        }
        if (mode.equals(MODE_POST)) {
            connection.setDoOutput(true);
            String query = this.getPostQuery(isEncode, sendCharset);
            OutputStream out = connection.getOutputStream();
            OutputStreamWriter swriter = null;
            swriter = sendCharset != null ? new OutputStreamWriter(out, sendCharset) : new OutputStreamWriter(out);
            BufferedWriter writer = new BufferedWriter(swriter);
            writer.write(query);
            writer.flush();
            writer.close();
        }
        InputStream input = null;
        boolean isError = false;
        IOException return_e = null;
        try {
            input = connection.getInputStream();
        }
        catch (IOException e) {
            return_e = e;
            isError = true;
            input = connection.getErrorStream();
        }
        if (input != null) {
            String inputLine;
            String encoding = recieveCharset;
            if (encoding == null) {
                encoding = "JISAutoDetect";
                String contentType = StringUtil.getNull(connection.getHeaderField("Content-Type"));
                contentType.toUpperCase();
                if (contentType.contains("UTF-8") || contentType.contains("UTF8")) {
                    encoding = "UTF-8";
                } else if (contentType.contains("MS932") || contentType.contains("SHIFT_JIS") || contentType.contains("WINDOWS-31J")) {
                    encoding = "MS932";
                } else if (contentType.contains("EUC-JP")) {
                    encoding = "EUC-JP";
                }
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, encoding));
            while ((inputLine = reader.readLine()) != null) {
                this.result = this.result + inputLine + "\n";
            }
            reader.close();
        }
        if (isError) {
            throw return_e;
        }
        if (enc != null) {
            URLCodec codec = new URLCodec();
            try {
                this.result = codec.decode(this.result, enc);
            }
            catch (DecoderException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String getPostQuery(boolean isEncode, String charset) {
        StringBuffer query = new StringBuffer();
        Object[] temp = this.parameters.keySet().toArray();
        for (int i = 0; i < temp.length; ++i) {
            if (i > 0) {
                query.append("&");
            }
            query.append(temp[i].toString() + "=");
            if (isEncode) {
                try {
                    query.append(URLEncoder.encode(this.parameters.get(temp[i]), charset));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                continue;
            }
            query.append(this.parameters.get(temp[i]));
        }
        return query.toString();
    }

    public String getAllResult() {
        return this.result;
    }

    public String getResult(String key) {
        StringTokenizer token = new StringTokenizer(this.result, "&");
        while (token.hasMoreTokens()) {
            String target = token.nextToken();
            int pos = (target = StringUtil.toLf(target)).indexOf(key);
            if (pos < 0) continue;
            int pos2 = target.indexOf("=", pos);
            int pos3 = target.indexOf("\n", pos);
            if (pos2 < 0) continue;
            if (pos3 > 0) {
                return target.substring(pos2 + 1, pos3).trim();
            }
            return target.substring(pos2 + 1).trim();
        }
        return null;
    }
}

