/*
 * Decompiled with CFR 0.152.
 */
package jp.co.smbcfs.station.sdk.service;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ResourceBundle;
import jp.co.smbcfs.station.sdk.dto.RequestDto;
import jp.co.smbcfs.station.sdk.dto.ResultDto;
import jp.co.smbcfs.station.sdk.dto.SmbcfsRelativePath;
import jp.co.smbcfs.station.sdk.service.SmbcfsRuntimeException;
import jp.co.smbcfs.station.sdk.util.HttpTusin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettlementTusin {
    public static <T extends ResultDto> String tusin(RequestDto<T> request, boolean isTest) {
        SmbcfsRelativePath path = request.getClass().getAnnotation(SmbcfsRelativePath.class);
        if (path == null) {
            throw new SmbcfsRuntimeException(request.getClass().getName() + " doesn't with annotated SmbcfsRelativePath. must be annotate it.");
        }
        HttpTusin tusin = new HttpTusin();
        try {
            SettlementTusin.convertDtoToRequest(request, tusin);
            tusin.connect(SettlementTusin.getTargetUrl(path, isTest), "POST", true, null, "MS932", "MS932");
        }
        catch (KeyManagementException e) {
            new SmbcfsRuntimeException(e);
        }
        catch (MalformedURLException e) {
            new SmbcfsRuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            new SmbcfsRuntimeException(e);
        }
        catch (IOException e) {
            new SmbcfsRuntimeException(e);
        }
        return tusin.getAllResult();
    }

    private static <T extends ResultDto> void convertDtoToRequest(RequestDto<T> request, HttpTusin tusin) {
        Field[] ff;
        for (Field f : ff = request.getClass().getDeclaredFields()) {
            f.setAccessible(true);
            try {
                String fv = (String)f.get(request);
                if (fv == null) continue;
                tusin.setParameter(f.getName(), fv);
            }
            catch (IllegalArgumentException e) {
                new SmbcfsRuntimeException(e);
            }
            catch (IllegalAccessException e) {
                new SmbcfsRuntimeException(e);
            }
        }
    }

    private static String getTargetUrl(SmbcfsRelativePath path, boolean isTest) {
        String relativePath;
        String key = isTest ? "jp.co.smbcfs.station.sdk.server_url.test" : "jp.co.smbcfs.station.sdk.server_url";
        String serverurl = ResourceBundle.getBundle("smbcfs").getString(key);
        if (serverurl.endsWith("/")) {
            serverurl = serverurl.substring(0, serverurl.length() - 1);
        }
        if (!(relativePath = path.relativePath()).startsWith("/")) {
            relativePath = "/" + relativePath;
        }
        return serverurl + relativePath;
    }
}

