/*
 * Decompiled with CFR 0.152.
 */
package jp.co.smbcfs.station.sdk.command;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import jp.co.smbcfs.station.sdk.dto.RequestDto;
import jp.co.smbcfs.station.sdk.service.SettlementTusin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmbcfsCommand {
    private static boolean isTestServer = false;
    private static boolean isTestLog = false;

    public static void main(String[] args) {
        int result = 0;
        try {
            Map<String, String> params = SmbcfsCommand.initializeParameterPair(args);
            if (params.containsKey("istestserver")) {
                if (params.containsValue("true")) {
                    isTestServer = true;
                }
                params.remove("istestserver");
            }
            if (params.containsKey("istestlog")) {
                if (params.containsValue("true")) {
                    isTestLog = true;
                }
                params.remove("istestlog");
            }
            SmbcfsCommand.log(">>>>>>>>>>>>> params are ");
            for (Map.Entry<String, String> e : params.entrySet()) {
                SmbcfsCommand.log(">>>>>>>>>>>>>> key:" + e.getKey() + ", value:" + e.getValue());
            }
            if (!params.containsKey("shori_kbn")) {
                System.exit(1);
                return;
            }
            String cls = ShoriKbnAndDtoPair.getPropreClassNamePrefix(params.get("shori_kbn"));
            SmbcfsCommand.log(">>>>>>>>>>>>>> classname " + cls);
            if (cls == null || cls.equals("")) {
                System.exit(1);
                return;
            }
            result = new SmbcfsCommand().execute(params, SmbcfsCommand.createRequestDto(cls));
            SmbcfsCommand.log(">>>>>>>>>>>>>> result " + result);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(result);
    }

    private static RequestDto<?> createRequestDto(String cls) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return (RequestDto)Class.forName(cls).newInstance();
    }

    private static Map<String, String> initializeParameterPair(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (args.length % 2 != 0) {
            return map;
        }
        for (int index = 0; index < args.length; ++index) {
            if (!args[index].startsWith("-")) {
                ++index;
                continue;
            }
            if (args[index].length() == 1) {
                ++index;
                continue;
            }
            map.put(args[index].substring("-".length()).trim(), args[++index].trim());
        }
        return map;
    }

    public int execute(Map<String, String> params, RequestDto<?> dto) {
        SmbcfsCommand.log(">>>>>>>>>>>>>>> exec http. params " + params);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            try {
                Field f = dto.getClass().getDeclaredField(entry.getKey());
                f.setAccessible(true);
                f.set(dto, entry.getValue());
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        SmbcfsCommand.log(">>>>>>>>>>>>>>> exec http. dto " + dto);
        String result = SettlementTusin.tusin(dto, isTestServer);
        SmbcfsCommand.log(">>>>>>>>>>>>>>> http result " + result);
        System.out.print(result);
        return 0;
    }

    private static void log(String log) {
        if (isTestLog) {
            System.err.println(log);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ShoriKbnAndDtoPair {
        GetAuthoryResultCsvDto("1005", "jp.co.smbcfs.station.sdk.command.dto.GetAuthoryResultCsvDto"),
        GetAvailabilityCsvDto("1105", "jp.co.smbcfs.station.sdk.command.dto.GetAvailabilityCsvDto"),
        GetClientContractInfoCsvDto("0305", "jp.co.smbcfs.station.sdk.command.dto.GetClientContractInfoCsvDto"),
        GetKessaiInfoCsvDto("0500", "jp.co.smbcfs.station.sdk.command.dto.GetKessaiInfoCsvDto"),
        GetKessaiUketsukeCsvDto("0200", "jp.co.smbcfs.station.sdk.command.dto.GetKessaiUketsukeCsvDto"),
        GetNyukinProcessInfoCsvDto("1800", "jp.co.smbcfs.station.sdk.command.dto.GetNyukinProcessInfoCsvDto"),
        GetSeikyuYoteiCsvDto("0405", "jp.co.smbcfs.station.sdk.command.dto.GetSeikyuYoteiCsvDto");

        private String value;
        private String dto;

        private ShoriKbnAndDtoPair(String value, String dto) {
            this.value = value;
            this.dto = dto;
        }

        public String getClassName() {
            return this.dto;
        }

        public boolean equals(String value) {
            return this.value.equals(value);
        }

        public static String getPropreClassNamePrefix(String value) {
            if (GetAuthoryResultCsvDto.equals(value)) {
                return ShoriKbnAndDtoPair.GetAuthoryResultCsvDto.dto;
            }
            if (GetAvailabilityCsvDto.equals(value)) {
                return ShoriKbnAndDtoPair.GetAvailabilityCsvDto.dto;
            }
            if (GetClientContractInfoCsvDto.equals(value)) {
                return ShoriKbnAndDtoPair.GetClientContractInfoCsvDto.dto;
            }
            if (GetKessaiInfoCsvDto.equals(value)) {
                return ShoriKbnAndDtoPair.GetKessaiInfoCsvDto.dto;
            }
            if (GetKessaiUketsukeCsvDto.equals(value)) {
                return ShoriKbnAndDtoPair.GetKessaiUketsukeCsvDto.dto;
            }
            if (GetNyukinProcessInfoCsvDto.equals(value)) {
                return ShoriKbnAndDtoPair.GetNyukinProcessInfoCsvDto.dto;
            }
            if (GetSeikyuYoteiCsvDto.equals(value)) {
                return ShoriKbnAndDtoPair.GetSeikyuYoteiCsvDto.dto;
            }
            return null;
        }
    }
}

