/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.launch.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.batch.api.BatchProperty;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.jsr.configuration.support.BatchPropertyContext;
import org.springframework.batch.core.jsr.configuration.support.JsrExpressionParser;
import org.springframework.batch.core.scope.StepScope;
import org.springframework.batch.core.scope.context.StepContext;
import org.springframework.batch.core.scope.context.StepSynchronizationManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.context.expression.StandardBeanExpressionResolver;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class BatchPropertyBeanPostProcessor
implements BeanPostProcessor,
BeanFactoryAware {
    private static final String SCOPED_TARGET_BEAN_PREFIX = "scopedTarget.";
    private static final Log LOGGER = LogFactory.getLog(BatchPropertyBeanPostProcessor.class);
    private static final Set<Class<? extends Annotation>> REQUIRED_ANNOTATIONS = new HashSet<Class<? extends Annotation>>();
    private JsrExpressionParser jsrExpressionParser;
    private BatchPropertyContext batchPropertyContext;

    public Object postProcessBeforeInitialization(Object artifact, String artifactName) throws BeansException {
        Properties artifactProperties = this.getArtifactProperties(artifactName);
        if (artifactProperties.isEmpty()) {
            return artifact;
        }
        this.injectBatchProperties(artifact, artifactProperties);
        return artifact;
    }

    public Object postProcessAfterInitialization(Object artifact, String artifactName) throws BeansException {
        return artifact;
    }

    private Properties getArtifactProperties(String artifactName) {
        StepContext stepContext;
        String originalArtifactName = artifactName;
        if (originalArtifactName.startsWith(SCOPED_TARGET_BEAN_PREFIX)) {
            originalArtifactName = artifactName.substring(SCOPED_TARGET_BEAN_PREFIX.length());
        }
        if ((stepContext = StepSynchronizationManager.getContext()) != null) {
            return this.batchPropertyContext.getStepArtifactProperties(stepContext.getStepName(), originalArtifactName);
        }
        return this.batchPropertyContext.getArtifactProperties(originalArtifactName);
    }

    private void injectBatchProperties(final Object artifact, final Properties artifactProperties) {
        ReflectionUtils.doWithFields(artifact.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                if (BatchPropertyBeanPostProcessor.this.isValidFieldModifier(field) && BatchPropertyBeanPostProcessor.this.isAnnotated(field)) {
                    boolean isAccessible = field.isAccessible();
                    field.setAccessible(true);
                    String batchProperty = BatchPropertyBeanPostProcessor.this.getBatchPropertyFieldValue(field, artifactProperties);
                    if (StringUtils.hasText((String)batchProperty)) {
                        field.set(artifact, batchProperty);
                    }
                    field.setAccessible(isAccessible);
                }
            }
        });
    }

    private String getBatchPropertyFieldValue(Field field, Properties batchArtifactProperties) {
        BatchProperty batchProperty = field.getAnnotation(BatchProperty.class);
        if (!"".equals(batchProperty.name())) {
            return this.getBatchProperty(batchProperty.name(), batchArtifactProperties);
        }
        return this.getBatchProperty(field.getName(), batchArtifactProperties);
    }

    private String getBatchProperty(String propertyKey, Properties batchArtifactProperties) {
        if (batchArtifactProperties.containsKey(propertyKey)) {
            String propertyValue = (String)batchArtifactProperties.get(propertyKey);
            return this.jsrExpressionParser.parseExpression(propertyValue);
        }
        return null;
    }

    private boolean isAnnotated(Field field) {
        for (Class<? extends Annotation> annotation : REQUIRED_ANNOTATIONS) {
            if (field.isAnnotationPresent(annotation)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidFieldModifier(Field field) {
        return !Modifier.isStatic(field.getModifiers()) && !Modifier.isFinal(field.getModifiers());
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (!(beanFactory instanceof ConfigurableListableBeanFactory)) {
            throw new IllegalArgumentException("BatchPropertyBeanPostProcessor requires a ConfigurableListableBeanFactory");
        }
        ConfigurableListableBeanFactory configurableListableBeanFactory = (ConfigurableListableBeanFactory)beanFactory;
        BeanExpressionContext beanExpressionContext = new BeanExpressionContext((ConfigurableBeanFactory)configurableListableBeanFactory, (Scope)configurableListableBeanFactory.getBean(StepScope.class));
        this.jsrExpressionParser = new JsrExpressionParser((BeanExpressionResolver)new StandardBeanExpressionResolver(), beanExpressionContext);
    }

    @Autowired
    public void setBatchPropertyContext(BatchPropertyContext batchPropertyContext) {
        this.batchPropertyContext = batchPropertyContext;
    }

    static {
        ClassLoader cl = BatchPropertyBeanPostProcessor.class.getClassLoader();
        try {
            REQUIRED_ANNOTATIONS.add(cl.loadClass("javax.inject.Inject"));
        }
        catch (ClassNotFoundException ex) {
            LOGGER.warn((Object)"javax.inject.Inject not found - @BatchProperty marked fields will not be processed.");
        }
        REQUIRED_ANNOTATIONS.add(BatchProperty.class);
    }
}

