/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.configuration.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.batch.core.configuration.xml.AbstractFlowParser;
import org.springframework.batch.core.job.flow.FlowExecutionStatus;
import org.springframework.batch.core.jsr.configuration.xml.JsrDecisionParser;
import org.springframework.batch.core.jsr.configuration.xml.JsrFlowFactoryBean;
import org.springframework.batch.core.jsr.configuration.xml.JsrSplitParser;
import org.springframework.batch.core.jsr.configuration.xml.StepParser;
import org.springframework.batch.core.jsr.job.flow.support.JsrFlow;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FlowParser
extends AbstractFlowParser {
    private static final String NEXT_ATTRIBUTE = "next";
    private static final String EXIT_STATUS_ATTRIBUTE = "exit-status";
    private static final List<String> TRANSITION_TYPES = new ArrayList<String>();
    private String flowName;
    private String jobFactoryRef;
    private StepParser stepParser = new StepParser();

    public FlowParser(String flowName, String jobFactoryRef) {
        super.setJobFactoryRef(jobFactoryRef);
        this.jobFactoryRef = jobFactoryRef;
        this.flowName = flowName;
    }

    @Override
    protected Class<?> getBeanClass(Element element) {
        return JsrFlowFactoryBean.class;
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        builder.getRawBeanDefinition().setAttribute("flowName", (Object)this.flowName);
        builder.addPropertyValue("name", (Object)this.flowName);
        builder.addPropertyValue("flowType", JsrFlow.class);
        ArrayList<BeanDefinition> stateTransitions = new ArrayList<BeanDefinition>();
        HashMap<String, Set<String>> reachableElementMap = new HashMap<String, Set<String>>();
        String startElement = null;
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            String nodeName = node.getLocalName();
            Element child = (Element)node;
            if (nodeName.equals("step")) {
                stateTransitions.addAll(this.stepParser.parse(child, parserContext, builder));
                continue;
            }
            if (nodeName.equals("split")) {
                stateTransitions.addAll(new JsrSplitParser(this.flowName).parse(child, parserContext));
                continue;
            }
            if (nodeName.equals("decision")) {
                stateTransitions.addAll(new JsrDecisionParser().parse(child, parserContext, this.flowName));
                continue;
            }
            if (!nodeName.equals("flow")) continue;
            stateTransitions.addAll(this.parseFlow(child, parserContext, builder));
        }
        HashSet<String> allReachableElements = new HashSet<String>();
        this.findAllReachableElements(startElement, reachableElementMap, allReachableElements);
        for (String elementId : reachableElementMap.keySet()) {
            if (allReachableElements.contains(elementId)) continue;
            parserContext.getReaderContext().error("The element [" + elementId + "] is unreachable", (Object)element);
        }
        ManagedList managedList = new ManagedList();
        managedList.addAll(stateTransitions);
        builder.addPropertyValue("stateTransitions", (Object)managedList);
    }

    private Collection<BeanDefinition> parseFlow(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String idAttribute = element.getAttribute("id");
        BeanDefinitionBuilder stateBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.batch.core.job.flow.support.state.FlowState");
        FlowParser flowParser = new FlowParser(idAttribute, this.jobFactoryRef);
        stateBuilder.addConstructorArgValue((Object)flowParser.parse(element, parserContext));
        stateBuilder.addConstructorArgValue((Object)idAttribute);
        builder.getRawBeanDefinition().setAttribute("flowName", (Object)idAttribute);
        builder.addPropertyValue("name", (Object)idAttribute);
        this.doParse(element, parserContext, builder);
        builder.setRole(2);
        return FlowParser.getNextElements(parserContext, null, (BeanDefinition)stateBuilder.getBeanDefinition(), element);
    }

    public static Collection<BeanDefinition> getNextElements(ParserContext parserContext, BeanDefinition stateDef, Element element) {
        return FlowParser.getNextElements(parserContext, null, stateDef, element);
    }

    public static Collection<BeanDefinition> getNextElements(ParserContext parserContext, String stepId, BeanDefinition stateDef, Element element) {
        ArrayList<BeanDefinition> list = new ArrayList<BeanDefinition>();
        boolean transitionElementExists = false;
        boolean failedTransitionElementExists = false;
        List childElements = DomUtils.getChildElements((Element)element);
        for (Element childElement : childElements) {
            if (!FlowParser.isChildElementTransitionElement(childElement)) continue;
            list.addAll(FlowParser.parseTransitionElement(childElement, stepId, stateDef, parserContext));
            failedTransitionElementExists = failedTransitionElementExists || FlowParser.hasFailedTransitionElement(childElement);
            transitionElementExists = true;
        }
        String shortNextAttribute = element.getAttribute(NEXT_ATTRIBUTE);
        boolean hasNextAttribute = StringUtils.hasText((String)shortNextAttribute);
        if (!transitionElementExists) {
            list.addAll(FlowParser.createTransition(FlowExecutionStatus.FAILED, FlowExecutionStatus.FAILED.getName(), null, null, stateDef, parserContext, false));
            list.addAll(FlowParser.createTransition(FlowExecutionStatus.UNKNOWN, FlowExecutionStatus.UNKNOWN.getName(), null, null, stateDef, parserContext, false));
        }
        if (hasNextAttribute) {
            if (transitionElementExists && !failedTransitionElementExists) {
                list.addAll(FlowParser.createTransition(FlowExecutionStatus.FAILED, FlowExecutionStatus.FAILED.getName(), null, null, stateDef, parserContext, false));
            }
            list.add(FlowParser.getStateTransitionReference(parserContext, stateDef, null, shortNextAttribute));
        } else {
            list.addAll(FlowParser.createTransition(FlowExecutionStatus.COMPLETED, FlowExecutionStatus.COMPLETED.getName(), null, null, stateDef, parserContext, false));
        }
        return list;
    }

    private static boolean isChildElementTransitionElement(Element childElement) {
        return TRANSITION_TYPES.contains(childElement.getLocalName());
    }

    private static boolean hasFailedTransitionElement(Element childName) {
        return "fail".equals(childName.getLocalName());
    }

    protected static Collection<BeanDefinition> parseTransitionElement(Element transitionElement, String stateId, BeanDefinition stateDef, ParserContext parserContext) {
        FlowExecutionStatus status = FlowParser.getBatchStatusFromEndTransitionName(transitionElement.getNodeName());
        String onAttribute = transitionElement.getAttribute("on");
        String restartAttribute = transitionElement.getAttribute("restart");
        String nextAttribute = transitionElement.getAttribute("to");
        if (!StringUtils.hasText((String)nextAttribute)) {
            nextAttribute = restartAttribute;
        }
        String exitCodeAttribute = transitionElement.getAttribute(EXIT_STATUS_ATTRIBUTE);
        return FlowParser.createTransition(status, onAttribute, nextAttribute, restartAttribute, exitCodeAttribute, stateDef, parserContext, false);
    }

    protected static Collection<BeanDefinition> createTransition(FlowExecutionStatus status, String on, String next, String restart, String exitCode, BeanDefinition stateDef, ParserContext parserContext, boolean abandon) {
        BeanDefinition endState = null;
        if (status.isEnd()) {
            BeanDefinitionBuilder endBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.batch.core.jsr.job.flow.support.state.JsrEndState");
            boolean exitCodeExists = StringUtils.hasText((String)exitCode);
            endBuilder.addConstructorArgValue((Object)status);
            endBuilder.addConstructorArgValue((Object)(exitCodeExists ? exitCode : status.getName()));
            String endName = (status == FlowExecutionStatus.STOPPED ? "stop" : (status == FlowExecutionStatus.FAILED ? "fail" : "end")) + endCounter++;
            endBuilder.addConstructorArgValue((Object)endName);
            endBuilder.addConstructorArgValue((Object)restart);
            endBuilder.addConstructorArgValue((Object)abandon);
            endBuilder.addConstructorArgReference("jobRepository");
            String nextOnEnd = exitCodeExists ? null : next;
            endState = FlowParser.getStateTransitionReference(parserContext, (BeanDefinition)endBuilder.getBeanDefinition(), null, nextOnEnd);
            next = endName;
        }
        ArrayList<BeanDefinition> list = new ArrayList<BeanDefinition>();
        list.add(FlowParser.getStateTransitionReference(parserContext, stateDef, on, next));
        if (StringUtils.hasText((String)restart)) {
            list.add(FlowParser.getStateTransitionReference(parserContext, stateDef, on + ".RESTART", restart));
        }
        if (endState != null) {
            list.add(endState);
        }
        return list;
    }

    static {
        TRANSITION_TYPES.add(NEXT_ATTRIBUTE);
        TRANSITION_TYPES.add("stop");
        TRANSITION_TYPES.add("end");
        TRANSITION_TYPES.add("fail");
    }
}

