/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.boot.autoconfigure;

import java.util.function.Supplier;
import org.seasar.doma.boot.autoconfigure.DomaConfigBuilder;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.GreedyCacheSqlFileRepository;
import org.seasar.doma.jdbc.Naming;
import org.seasar.doma.jdbc.NoCacheSqlFileRepository;
import org.seasar.doma.jdbc.SqlFileRepository;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.jdbc.dialect.Db2Dialect;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.dialect.H2Dialect;
import org.seasar.doma.jdbc.dialect.HsqldbDialect;
import org.seasar.doma.jdbc.dialect.Mssql2008Dialect;
import org.seasar.doma.jdbc.dialect.MssqlDialect;
import org.seasar.doma.jdbc.dialect.MysqlDialect;
import org.seasar.doma.jdbc.dialect.OracleDialect;
import org.seasar.doma.jdbc.dialect.PostgresDialect;
import org.seasar.doma.jdbc.dialect.SqliteDialect;
import org.seasar.doma.jdbc.dialect.StandardDialect;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="doma")
public class DomaProperties {
    public static final String DOMA_PREFIX = "doma";
    private DialectType dialect = DialectType.STANDARD;
    private SqlFileRepositoryType sqlFileRepository = SqlFileRepositoryType.GREEDY_CACHE;
    private NamingType naming = NamingType.DEFAULT;
    private boolean exceptionTranslationEnabled = true;
    private String dataSourceName = Config.class.getName();
    private SqlLogType exceptionSqlLogType = SqlLogType.NONE;
    private int maxRows = 0;
    private int fetchSize = 0;
    private int queryTimeout = 0;
    private int batchSize = 0;

    public DialectType getDialect() {
        return this.dialect;
    }

    public void setDialect(DialectType dialect) {
        this.dialect = dialect;
    }

    public SqlFileRepositoryType getSqlFileRepository() {
        return this.sqlFileRepository;
    }

    public void setSqlFileRepository(SqlFileRepositoryType sqlFileRepository) {
        this.sqlFileRepository = sqlFileRepository;
    }

    public NamingType getNaming() {
        return this.naming;
    }

    public void setNaming(NamingType naming) {
        this.naming = naming;
    }

    public boolean isExceptionTranslationEnabled() {
        return this.exceptionTranslationEnabled;
    }

    public void setExceptionTranslationEnabled(boolean exceptionTranslationEnabled) {
        this.exceptionTranslationEnabled = exceptionTranslationEnabled;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public SqlLogType getExceptionSqlLogType() {
        return this.exceptionSqlLogType;
    }

    public void setExceptionSqlLogType(SqlLogType exceptionSqlLogType) {
        this.exceptionSqlLogType = exceptionSqlLogType;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public DomaConfigBuilder initializeDomaConfigBuilder() {
        return new DomaConfigBuilder().dialect(this.dialect.create()).sqlFileRepository(this.sqlFileRepository.create()).naming(this.naming.naming());
    }

    public String toString() {
        return "DomaProperties{dialect=" + (Object)((Object)this.dialect) + ", sqlFileRepository=" + (Object)((Object)this.sqlFileRepository) + ", naming=" + (Object)((Object)this.naming) + ", exceptionTranslationEnabled=" + this.exceptionTranslationEnabled + ", dataSourceName='" + this.dataSourceName + '\'' + ", exceptionSqlLogType=" + this.exceptionSqlLogType + ", maxRows=" + this.maxRows + ", fetchSize=" + this.fetchSize + ", queryTimeout=" + this.queryTimeout + ", batchSize=" + this.batchSize + '}';
    }

    public static enum NamingType {
        NONE(Naming.NONE),
        LOWER_CASE(Naming.LOWER_CASE),
        UPPER_CASE(Naming.UPPER_CASE),
        SNAKE_LOWER_CASE(Naming.SNAKE_LOWER_CASE),
        SNAKE_UPPER_CASE(Naming.SNAKE_UPPER_CASE),
        LENIENT_SNAKE_LOWER_CASE(Naming.LENIENT_SNAKE_LOWER_CASE),
        LENIENT_SNAKE_UPPER_CASE(Naming.LENIENT_SNAKE_UPPER_CASE),
        DEFAULT(Naming.DEFAULT);

        private final Naming naming;

        private NamingType(Naming naming) {
            this.naming = naming;
        }

        public Naming naming() {
            return this.naming;
        }
    }

    public static enum SqlFileRepositoryType {
        NO_CACHE(NoCacheSqlFileRepository::new),
        GREEDY_CACHE(GreedyCacheSqlFileRepository::new);

        private final Supplier<SqlFileRepository> constructor;

        private SqlFileRepositoryType(Supplier<SqlFileRepository> constructor) {
            this.constructor = constructor;
        }

        public SqlFileRepository create() {
            return this.constructor.get();
        }
    }

    public static enum DialectType {
        STANDARD(StandardDialect::new),
        SQLITE(SqliteDialect::new),
        DB2(Db2Dialect::new),
        MSSQL(MssqlDialect::new),
        MSSQL2008(Mssql2008Dialect::new),
        MYSQL(MysqlDialect::new),
        POSTGRES(PostgresDialect::new),
        ORACLE(OracleDialect::new),
        H2(H2Dialect::new),
        HSQL(HsqldbDialect::new);

        private final Supplier<Dialect> constructor;

        private DialectType(Supplier<Dialect> constructor) {
            this.constructor = constructor;
        }

        public Dialect create() {
            return this.constructor.get();
        }
    }
}

