/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.boot.autoconfigure;

import java.sql.SQLException;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.NoResultException;
import org.seasar.doma.jdbc.NonSingleColumnException;
import org.seasar.doma.jdbc.NonUniqueResultException;
import org.seasar.doma.jdbc.OptimisticLockException;
import org.seasar.doma.jdbc.ResultMappingException;
import org.seasar.doma.jdbc.SqlExecutionException;
import org.seasar.doma.jdbc.UniqueConstraintException;
import org.seasar.doma.jdbc.UnknownColumnException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.dao.TypeMismatchDataAccessException;
import org.springframework.dao.UncategorizedDataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;

public class DomaPersistenceExceptionTranslator
implements PersistenceExceptionTranslator {
    private final SQLExceptionTranslator translator;

    public DomaPersistenceExceptionTranslator(SQLExceptionTranslator sqlExceptionTranslator) {
        this.translator = sqlExceptionTranslator;
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        if (!(ex instanceof JdbcException)) {
            return null;
        }
        if (ex instanceof OptimisticLockException) {
            return new OptimisticLockingFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof UniqueConstraintException) {
            return new DuplicateKeyException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof NonUniqueResultException || ex instanceof NonSingleColumnException) {
            return new IncorrectResultSizeDataAccessException(ex.getMessage(), 1, (Throwable)ex);
        }
        if (ex instanceof NoResultException) {
            return new EmptyResultDataAccessException(ex.getMessage(), 1, (Throwable)ex);
        }
        if (ex instanceof UnknownColumnException || ex instanceof ResultMappingException) {
            return new TypeMismatchDataAccessException(ex.getMessage(), (Throwable)ex);
        }
        if (ex.getCause() instanceof SQLException) {
            SQLException e = (SQLException)ex.getCause();
            String sql = null;
            if (ex instanceof SqlExecutionException) {
                sql = ((SqlExecutionException)ex).getRawSql();
            }
            return this.translator.translate(ex.getMessage(), sql, e);
        }
        return new UncategorizedDataAccessException(ex.getMessage(), ex){};
    }
}

