/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.boot.autoconfigure;

import javax.sql.DataSource;
import org.seasar.doma.boot.autoconfigure.DomaConfig;
import org.seasar.doma.boot.autoconfigure.DomaProperties;
import org.seasar.doma.jdbc.ClassHelper;
import org.seasar.doma.jdbc.CommandImplementors;
import org.seasar.doma.jdbc.Commenter;
import org.seasar.doma.jdbc.ConfigSupport;
import org.seasar.doma.jdbc.EntityListenerProvider;
import org.seasar.doma.jdbc.JdbcLogger;
import org.seasar.doma.jdbc.MapKeyNaming;
import org.seasar.doma.jdbc.Naming;
import org.seasar.doma.jdbc.QueryImplementors;
import org.seasar.doma.jdbc.RequiresNewController;
import org.seasar.doma.jdbc.SqlFileRepository;
import org.seasar.doma.jdbc.UnknownColumnHandler;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;

public class DomaConfigBuilder {
    private DataSource dataSource;
    private Dialect dialect;
    private JdbcLogger jdbcLogger = ConfigSupport.defaultJdbcLogger;
    private SqlFileRepository sqlFileRepository;
    private RequiresNewController requiresNewController = ConfigSupport.defaultRequiresNewController;
    private ClassHelper classHelper = ConfigSupport.defaultClassHelper;
    private CommandImplementors commandImplementors = ConfigSupport.defaultCommandImplementors;
    private QueryImplementors queryImplementors = ConfigSupport.defaultQueryImplementors;
    private UnknownColumnHandler unknownColumnHandler = ConfigSupport.defaultUnknownColumnHandler;
    private Naming naming;
    private MapKeyNaming mapKeyNaming = ConfigSupport.defaultMapKeyNaming;
    private Commenter commenter = ConfigSupport.defaultCommenter;
    private EntityListenerProvider entityListenerProvider;

    public DataSource dataSource() {
        return this.dataSource;
    }

    public DomaConfigBuilder dataSource(DataSource dataSource) {
        this.dataSource = new TransactionAwareDataSourceProxy(dataSource);
        return this;
    }

    public Dialect dialect() {
        return this.dialect;
    }

    public DomaConfigBuilder dialect(Dialect dialect) {
        this.dialect = dialect;
        return this;
    }

    public JdbcLogger jdbcLogger() {
        return this.jdbcLogger;
    }

    public DomaConfigBuilder jdbcLogger(JdbcLogger jdbcLogger) {
        this.jdbcLogger = jdbcLogger;
        return this;
    }

    public SqlFileRepository sqlFileRepository() {
        return this.sqlFileRepository;
    }

    public DomaConfigBuilder sqlFileRepository(SqlFileRepository sqlFileRepository) {
        this.sqlFileRepository = sqlFileRepository;
        return this;
    }

    public RequiresNewController requiresNewController() {
        return this.requiresNewController;
    }

    public DomaConfigBuilder requiresNewController(RequiresNewController requiresNewController) {
        this.requiresNewController = requiresNewController;
        return this;
    }

    public ClassHelper classHelper() {
        return this.classHelper;
    }

    public DomaConfigBuilder classHelper(ClassHelper classHelper) {
        this.classHelper = classHelper;
        return this;
    }

    public CommandImplementors commandImplementors() {
        return this.commandImplementors;
    }

    public DomaConfigBuilder commandImplementors(CommandImplementors commandImplementors) {
        this.commandImplementors = commandImplementors;
        return this;
    }

    public QueryImplementors queryImplementors() {
        return this.queryImplementors;
    }

    public DomaConfigBuilder queryImplementors(QueryImplementors queryImplementors) {
        this.queryImplementors = queryImplementors;
        return this;
    }

    public UnknownColumnHandler unknownColumnHandler() {
        return this.unknownColumnHandler;
    }

    public DomaConfigBuilder unknownColumnHandler(UnknownColumnHandler unknownColumnHandler) {
        this.unknownColumnHandler = unknownColumnHandler;
        return this;
    }

    public Naming naming() {
        return this.naming;
    }

    public DomaConfigBuilder naming(Naming naming) {
        this.naming = naming;
        return this;
    }

    public MapKeyNaming mapKeyNaming() {
        return this.mapKeyNaming;
    }

    public DomaConfigBuilder mapKeyNaming(MapKeyNaming mapKeyNaming) {
        this.mapKeyNaming = mapKeyNaming;
        return this;
    }

    public Commenter commenter() {
        return this.commenter;
    }

    public DomaConfigBuilder commenter(Commenter commenter) {
        this.commenter = commenter;
        return this;
    }

    public EntityListenerProvider entityListenerProvider() {
        return this.entityListenerProvider;
    }

    public DomaConfigBuilder entityListenerProvider(EntityListenerProvider entityListenerProvider) {
        this.entityListenerProvider = entityListenerProvider;
        return this;
    }

    public DomaConfig build(DomaProperties domaProperties) {
        return new DomaConfig(this, domaProperties);
    }
}

