/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.boot.autoconfigure;

import javax.sql.DataSource;
import org.seasar.doma.boot.autoconfigure.DomaConfigBuilder;
import org.seasar.doma.boot.autoconfigure.DomaProperties;
import org.seasar.doma.jdbc.ClassHelper;
import org.seasar.doma.jdbc.CommandImplementors;
import org.seasar.doma.jdbc.Commenter;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.EntityListenerProvider;
import org.seasar.doma.jdbc.JdbcLogger;
import org.seasar.doma.jdbc.MapKeyNaming;
import org.seasar.doma.jdbc.Naming;
import org.seasar.doma.jdbc.QueryImplementors;
import org.seasar.doma.jdbc.RequiresNewController;
import org.seasar.doma.jdbc.SqlFileRepository;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.jdbc.UnknownColumnHandler;
import org.seasar.doma.jdbc.dialect.Dialect;

public class DomaConfig
implements Config {
    private final DataSource dataSource;
    private final Dialect dialect;
    private final JdbcLogger jdbcLogger;
    private final SqlFileRepository sqlFileRepository;
    private final RequiresNewController requiresNewController;
    private final ClassHelper classHelper;
    private final CommandImplementors commandImplementors;
    private final QueryImplementors queryImplementors;
    private final UnknownColumnHandler unknownColumnHandler;
    private final Naming naming;
    private final MapKeyNaming mapKeyNaming;
    private final Commenter commenter;
    private final EntityListenerProvider entityListenerProvider;
    private final DomaProperties domaProperties;

    public DomaConfig(DomaConfigBuilder builder, DomaProperties domaProperties) {
        this.dataSource = builder.dataSource();
        this.dialect = builder.dialect();
        this.jdbcLogger = builder.jdbcLogger();
        this.sqlFileRepository = builder.sqlFileRepository();
        this.requiresNewController = builder.requiresNewController();
        this.classHelper = builder.classHelper();
        this.commandImplementors = builder.commandImplementors();
        this.queryImplementors = builder.queryImplementors();
        this.unknownColumnHandler = builder.unknownColumnHandler();
        this.naming = builder.naming();
        this.mapKeyNaming = builder.mapKeyNaming();
        this.commenter = builder.commenter();
        this.entityListenerProvider = builder.entityListenerProvider();
        this.domaProperties = domaProperties;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public String getDataSourceName() {
        return this.domaProperties.getDataSourceName();
    }

    public SqlFileRepository getSqlFileRepository() {
        return this.sqlFileRepository;
    }

    public JdbcLogger getJdbcLogger() {
        return this.jdbcLogger;
    }

    public RequiresNewController getRequiresNewController() {
        return this.requiresNewController;
    }

    public ClassHelper getClassHelper() {
        return this.classHelper;
    }

    public CommandImplementors getCommandImplementors() {
        return this.commandImplementors;
    }

    public QueryImplementors getQueryImplementors() {
        return this.queryImplementors;
    }

    public SqlLogType getExceptionSqlLogType() {
        return this.domaProperties.getExceptionSqlLogType();
    }

    public UnknownColumnHandler getUnknownColumnHandler() {
        return this.unknownColumnHandler;
    }

    public Naming getNaming() {
        return this.naming;
    }

    public MapKeyNaming getMapKeyNaming() {
        return this.mapKeyNaming;
    }

    public Commenter getCommenter() {
        return this.commenter;
    }

    public int getMaxRows() {
        return this.domaProperties.getMaxRows();
    }

    public int getFetchSize() {
        return this.domaProperties.getFetchSize();
    }

    public int getQueryTimeout() {
        return this.domaProperties.getQueryTimeout();
    }

    public int getBatchSize() {
        return this.domaProperties.getBatchSize();
    }

    public EntityListenerProvider getEntityListenerProvider() {
        return this.entityListenerProvider;
    }

    public String toString() {
        return "DomaConfig{dataSource=" + this.dataSource + ", dialect=" + this.dialect + ", jdbcLogger=" + this.jdbcLogger + ", sqlFileRepository=" + this.sqlFileRepository + ", requiresNewController=" + this.requiresNewController + ", classHelper=" + this.classHelper + ", commandImplementors=" + this.commandImplementors + ", queryImplementors=" + this.queryImplementors + ", unknownColumnHandler=" + this.unknownColumnHandler + ", naming=" + this.naming + ", mapKeyNaming=" + this.mapKeyNaming + ", commenter=" + this.commenter + ", entityListenerProvider=" + this.entityListenerProvider + ", domaProperties=" + this.domaProperties + '}';
    }
}

