/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.boot.autoconfigure;

import javax.sql.DataSource;
import org.seasar.doma.boot.autoconfigure.DomaConfig;
import org.seasar.doma.boot.autoconfigure.DomaConfigBuilder;
import org.seasar.doma.boot.autoconfigure.DomaPersistenceExceptionTranslator;
import org.seasar.doma.boot.autoconfigure.DomaProperties;
import org.seasar.doma.boot.autoconfigure.TryLookupEntityListenerProvider;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.EntityListenerProvider;
import org.seasar.doma.jdbc.Naming;
import org.seasar.doma.jdbc.SqlFileRepository;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;

@Configuration
@ConditionalOnClass(value={Config.class})
@EnableConfigurationProperties(value={DomaProperties.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class DomaAutoConfiguration {
    @Autowired
    DomaProperties domaProperties;

    @Bean
    @ConditionalOnMissingBean
    public Dialect dialect() {
        return this.domaProperties.getDialect().create();
    }

    @Bean
    @ConditionalOnProperty(prefix="doma", name={"exception-translation-enabled"}, matchIfMissing=true)
    public PersistenceExceptionTranslator exceptionTranslator(Config config) {
        return new DomaPersistenceExceptionTranslator((SQLExceptionTranslator)new SQLErrorCodeSQLExceptionTranslator(config.getDataSource()));
    }

    @Bean
    @ConditionalOnMissingBean
    public SqlFileRepository sqlFileRepository() {
        return this.domaProperties.getSqlFileRepository().create();
    }

    @Bean
    @ConditionalOnMissingBean
    public Naming naming() {
        return this.domaProperties.getNaming().naming();
    }

    @Bean
    @ConditionalOnMissingBean
    public EntityListenerProvider entityListenerProvider() {
        return new TryLookupEntityListenerProvider();
    }

    @Bean
    @ConditionalOnMissingBean
    public DomaConfigBuilder domaConfigBuilder() {
        return new DomaConfigBuilder();
    }

    @Bean
    @ConditionalOnMissingBean(value={Config.class})
    public DomaConfig config(DataSource dataSource, Dialect dialect, SqlFileRepository sqlFileRepository, Naming naming, EntityListenerProvider entityListenerProvider, DomaConfigBuilder domaConfigBuilder, DomaProperties domaProperties) {
        if (domaConfigBuilder.dataSource() == null) {
            domaConfigBuilder.dataSource(dataSource);
        }
        if (domaConfigBuilder.dialect() == null) {
            domaConfigBuilder.dialect(dialect);
        }
        if (domaConfigBuilder.sqlFileRepository() == null) {
            domaConfigBuilder.sqlFileRepository(sqlFileRepository);
        }
        if (domaConfigBuilder.naming() == null) {
            domaConfigBuilder.naming(naming);
        }
        if (domaConfigBuilder.entityListenerProvider() == null) {
            domaConfigBuilder.entityListenerProvider(entityListenerProvider);
        }
        return domaConfigBuilder.build(domaProperties);
    }
}

