/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dojo.components;

import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.components.UIBean;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;
import org.apache.struts2.views.annotations.StrutsTagSkipInheritance;

@StrutsTag(name="datetimepicker", tldTagClass="org.apache.struts2.dojo.views.jsp.ui.DateTimePickerTag", description="Render datetimepicker")
public class DateTimePicker
extends UIBean {
    public static final String TEMPLATE = "datetimepicker";
    private static final String RFC3339_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String RFC3339_PATTERN = "{0,date,yyyy-MM-dd'T'HH:mm:ss}";
    protected static final Logger LOG = LoggerFactory.getLogger(DateTimePicker.class);
    private static final transient Random RANDOM = new Random();
    protected String iconPath;
    protected String formatLength;
    protected String displayFormat;
    protected String toggleType;
    protected String toggleDuration;
    protected String type;
    protected String displayWeeks;
    protected String adjustWeeks;
    protected String startDate;
    protected String endDate;
    protected String weekStartsOn;
    protected String staticDisplay;
    protected String dayWidth;
    protected String language;
    protected String templateCssPath;
    protected String valueNotifyTopics;

    public DateTimePicker(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    protected String getDefaultTemplate() {
        return TEMPLATE;
    }

    public void evaluateParams() {
        super.evaluateParams();
        if (this.displayFormat != null) {
            this.addParameter("displayFormat", this.findString(this.displayFormat));
        }
        if (this.displayWeeks != null) {
            this.addParameter("displayWeeks", this.findString(this.displayWeeks));
        }
        if (this.adjustWeeks != null) {
            this.addParameter("adjustWeeks", this.findValue(this.adjustWeeks, Boolean.class));
        }
        if (this.disabled != null) {
            this.addParameter("disabled", this.findValue(this.disabled, Boolean.class));
        }
        if (this.startDate != null) {
            this.addParameter("startDate", this.format(this.findValue(this.startDate)));
        }
        if (this.endDate != null) {
            this.addParameter("endDate", this.format(this.findValue(this.endDate)));
        }
        if (this.weekStartsOn != null) {
            this.addParameter("weekStartsOn", this.findString(this.weekStartsOn));
        }
        if (this.staticDisplay != null) {
            this.addParameter("staticDisplay", this.findValue(this.staticDisplay, Boolean.class));
        }
        if (this.dayWidth != null) {
            this.addParameter("dayWidth", this.findValue(this.dayWidth, Integer.class));
        }
        if (this.language != null) {
            this.addParameter("language", this.findString(this.language));
        }
        if (this.value != null) {
            this.addParameter("value", this.format(this.findValue(this.value)));
        }
        if (this.iconPath != null) {
            this.addParameter("iconPath", this.findString(this.iconPath));
        }
        if (this.formatLength != null) {
            this.addParameter("formatLength", this.findString(this.formatLength));
        }
        if (this.toggleType != null) {
            this.addParameter("toggleType", this.findString(this.toggleType));
        }
        if (this.toggleDuration != null) {
            this.addParameter("toggleDuration", this.findValue(this.toggleDuration, Integer.class));
        }
        if (this.type != null) {
            this.addParameter("type", this.findString(this.type));
        } else {
            this.addParameter("type", "date");
        }
        if (this.templateCssPath != null) {
            this.addParameter("templateCssPath", this.findString(this.templateCssPath));
        }
        if (this.valueNotifyTopics != null) {
            this.addParameter("valueNotifyTopics", this.findString(this.valueNotifyTopics));
        }
        if (this.parameters.containsKey("value")) {
            this.addParameter("nameValue", this.parameters.get("value"));
        } else if (this.parameters.containsKey("name")) {
            this.addParameter("nameValue", this.format(this.findValue((String)this.parameters.get("name"))));
        }
        Boolean parseContent = (Boolean)this.stack.getContext().get("struts.dojo.head.parseContent");
        boolean generateId = parseContent != null ? !parseContent.booleanValue() : true;
        this.addParameter("pushId", generateId);
        if ((this.id == null || this.id.length() == 0) && generateId) {
            int nextInt = RANDOM.nextInt();
            nextInt = nextInt == Integer.MIN_VALUE ? Integer.MAX_VALUE : Math.abs(nextInt);
            this.id = "widget_" + String.valueOf(nextInt);
            this.addParameter("id", this.id);
        }
    }

    @StrutsTagSkipInheritance
    public void setTheme(String theme) {
        super.setTheme(theme);
    }

    public String getTheme() {
        return "ajax";
    }

    @StrutsTagAttribute(description="If true, weekly size of calendar changes to acomodate the month if false, 42 day format is used", type="Boolean", defaultValue="false")
    public void setAdjustWeeks(String adjustWeeks) {
        this.adjustWeeks = adjustWeeks;
    }

    @StrutsTagAttribute(description="How to render the names of the days in the header(narrow, abbr or wide)", defaultValue="narrow")
    public void setDayWidth(String dayWidth) {
        this.dayWidth = dayWidth;
    }

    @StrutsTagAttribute(description="Total weeks to display", type="Integer", defaultValue="6")
    public void setDisplayWeeks(String displayWeeks) {
        this.displayWeeks = displayWeeks;
    }

    @StrutsTagAttribute(description="Last available date in the calendar set", type="Date", defaultValue="2941-10-12")
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    @StrutsTagAttribute(description="First available date in the calendar set", type="Date", defaultValue="1492-10-12")
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    @StrutsTagAttribute(description="Disable all incremental controls, must pick a date in the current display", type="Boolean", defaultValue="false")
    public void setStaticDisplay(String staticDisplay) {
        this.staticDisplay = staticDisplay;
    }

    @StrutsTagAttribute(description="Adjusts the first day of the week 0==Sunday..6==Saturday", type="Integer", defaultValue="0")
    public void setWeekStartsOn(String weekStartsOn) {
        this.weekStartsOn = weekStartsOn;
    }

    @StrutsTagAttribute(description="Language to display this widget in", defaultValue="brower's specified preferred language")
    public void setLanguage(String language) {
        this.language = language;
    }

    @StrutsTagAttribute(description="A pattern used for the visual display of the formatted date, e.g. dd/MM/yyyy")
    public void setDisplayFormat(String displayFormat) {
        this.displayFormat = displayFormat;
    }

    @StrutsTagAttribute(description="Type of formatting used for visual display. Possible values are long, short, medium or full", defaultValue="short")
    public void setFormatLength(String formatLength) {
        this.formatLength = formatLength;
    }

    @StrutsTagAttribute(description="Path to icon used for the dropdown")
    public void setIconPath(String iconPath) {
        this.iconPath = iconPath;
    }

    @StrutsTagAttribute(description="Duration of toggle in milliseconds", type="Integer", defaultValue="100")
    public void setToggleDuration(String toggleDuration) {
        this.toggleDuration = toggleDuration;
    }

    @StrutsTagAttribute(description="Defines the type of the picker on the dropdown. Possible values are 'date' for a DateTimePicker, and 'time' for a timePicker", defaultValue="date")
    public void setType(String type) {
        this.type = type;
    }

    @StrutsTagAttribute(description="oggle type of the dropdown. Possible values are plain,wipe,explode,fade", defaultValue="plain")
    public void setToggleType(String toggleType) {
        this.toggleType = toggleType;
    }

    @StrutsTagAttribute(description="Template css path")
    public void setTemplateCssPath(String templateCssPath) {
        this.templateCssPath = templateCssPath;
    }

    @StrutsTagAttribute(description="Preset the value of input element")
    public void setValue(String arg0) {
        super.setValue(arg0);
    }

    @StrutsTagAttribute(description="Comma delimmited list of topics that will published when a value is selected")
    public void setValueNotifyTopics(String valueNotifyTopics) {
        this.valueNotifyTopics = valueNotifyTopics;
    }

    private String format(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            return MessageFormat.format(RFC3339_PATTERN, (Date)obj);
        }
        if (obj instanceof Calendar) {
            return MessageFormat.format(RFC3339_PATTERN, ((Calendar)obj).getTime());
        }
        String dateStr = obj.toString();
        if (dateStr.equalsIgnoreCase("today")) {
            return MessageFormat.format(RFC3339_PATTERN, new Date());
        }
        Date date = null;
        ArrayList<DateFormat> formats = new ArrayList<DateFormat>();
        formats.add(new SimpleDateFormat(RFC3339_FORMAT));
        formats.add(SimpleDateFormat.getTimeInstance(3));
        formats.add(SimpleDateFormat.getDateInstance(3));
        formats.add(SimpleDateFormat.getDateInstance(2));
        formats.add(SimpleDateFormat.getDateInstance(0));
        formats.add(SimpleDateFormat.getDateInstance(1));
        if (this.displayFormat != null) {
            try {
                SimpleDateFormat displayFormat = new SimpleDateFormat((String)this.getParameters().get("displayFormat"));
                formats.add(displayFormat);
            }
            catch (Exception e) {
                LOG.error("Cannot use attribute", (Throwable)e, new String[0]);
            }
        }
        for (DateFormat format : formats) {
            try {
                date = format.parse(dateStr);
                if (date == null) continue;
                return MessageFormat.format(RFC3339_PATTERN, date);
            }
            catch (Exception e) {
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Unable to parse date " + dateStr, new String[0]);
        }
        return dateStr;
    }
}

