/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher.mapper;

import com.opensymphony.xwork2.config.ConfigurationManager;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.RequestUtils;
import org.apache.struts2.dispatcher.mapper.ActionMapper;
import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.apache.struts2.dispatcher.mapper.DefaultActionMapper;

public class PrefixBasedActionMapper
extends DefaultActionMapper
implements ActionMapper {
    private static final Logger LOG = LoggerFactory.getLogger(PrefixBasedActionMapper.class);
    protected Container container;
    protected Map<String, ActionMapper> actionMappers = new HashMap<String, ActionMapper>();

    @Override
    @Inject
    public void setContainer(Container container) {
        this.container = container;
    }

    @Inject(value="struts.mapper.prefixMapping")
    public void setPrefixBasedActionMappers(String list) {
        if (list != null) {
            String[] mappers;
            for (String mapper : mappers = list.split(",")) {
                String[] thisMapper = mapper.split(":");
                if (thisMapper == null || thisMapper.length != 2) continue;
                String mapperPrefix = thisMapper[0].trim();
                String mapperName = thisMapper[1].trim();
                Object obj = this.container.getInstance(ActionMapper.class, mapperName);
                if (obj != null) {
                    this.actionMappers.put(mapperPrefix, (ActionMapper)obj);
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("invalid PrefixBasedActionMapper config entry: [#0]", new String[]{mapper});
            }
        }
    }

    @Override
    public ActionMapping getMapping(HttpServletRequest request, ConfigurationManager configManager) {
        String uri = RequestUtils.getUri(request);
        int lastIndex = uri.lastIndexOf(47);
        while (lastIndex > -1) {
            ActionMapper actionMapper = this.actionMappers.get(uri.substring(0, lastIndex));
            if (actionMapper != null) {
                ActionMapping actionMapping = actionMapper.getMapping(request, configManager);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Using ActionMapper [#0]", new String[]{actionMapper.toString()});
                }
                if (actionMapping != null) {
                    if (LOG.isDebugEnabled() && actionMapping.getParams() != null) {
                        LOG.debug("ActionMapper found mapping. Parameters: [#0]", new String[]{actionMapping.getParams().toString()});
                        for (Map.Entry<String, Object> mappingParameterEntry : actionMapping.getParams().entrySet()) {
                            Object paramValue = mappingParameterEntry.getValue();
                            if (paramValue == null) {
                                LOG.debug("[#0] : null!", new String[]{mappingParameterEntry.getKey()});
                                continue;
                            }
                            if (paramValue instanceof String[]) {
                                LOG.debug("[#0] : (String[]) #1", new String[]{mappingParameterEntry.getKey(), Arrays.toString((String[])paramValue)});
                                continue;
                            }
                            if (paramValue instanceof String) {
                                LOG.debug("[#0] : (String) [#1]", new String[]{mappingParameterEntry.getKey(), paramValue.toString()});
                                continue;
                            }
                            LOG.debug("[#0] : (Object) [#1]", new String[]{mappingParameterEntry.getKey(), paramValue.toString()});
                        }
                    }
                    return actionMapping;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("ActionMapper [#0] failed to return an ActionMapping", new String[]{actionMapper.toString()});
                }
            }
            lastIndex = uri.lastIndexOf(47, lastIndex - 1);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("No ActionMapper found", new String[0]);
        }
        return null;
    }

    @Override
    public String getUriFromActionMapping(ActionMapping mapping) {
        String namespace = mapping.getNamespace();
        int lastIndex = namespace.length();
        while (lastIndex > -1) {
            ActionMapper actionMapper = this.actionMappers.get(namespace.substring(0, lastIndex));
            if (actionMapper != null) {
                String uri = actionMapper.getUriFromActionMapping(mapping);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Using ActionMapper [#0]", new String[]{actionMapper.toString()});
                }
                if (uri != null) {
                    return uri;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("ActionMapper [#0] failed to return an ActionMapping (null)", new String[]{actionMapper.toString()});
                }
            }
            lastIndex = namespace.lastIndexOf(47, lastIndex - 1);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("ActionMapper failed to return a uri", new String[0]);
        }
        return null;
    }
}

