/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.config;

import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.PackageProvider;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.PackageConfig;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import com.opensymphony.xwork2.config.entities.ResultTypeConfig;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ClassLoaderUtil;
import com.opensymphony.xwork2.util.ResolverUtil;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.config.Action;
import org.apache.struts2.config.Namespace;
import org.apache.struts2.config.NullResult;
import org.apache.struts2.config.ParentPackage;
import org.apache.struts2.config.Result;
import org.apache.struts2.config.Results;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathPackageProvider
implements PackageProvider {
    protected static final String DEFAULT_PAGE_PREFIX = "struts.configuration.classpath.defaultPagePrefix";
    private String defaultPagePrefix = "";
    protected static final String DEFAULT_PAGE_EXTENSION = "struts.configuration.classpath.defaultPageExtension";
    private String defaultPageExtension = ".jsp";
    protected static final String DEFAULT_PARENT_PACKAGE = "struts.configuration.classpath.defaultParentPackage";
    protected static final String DISABLE_ACTION_SCANNING = "struts.configuration.classpath.disableActionScanning";
    private String defaultParentPackage = "struts-default";
    protected static final String FORCE_LOWER_CASE = "struts.configuration.classpath.forceLowerCase";
    private boolean forceLowerCase = true;
    protected static final String CLASS_SUFFIX = "struts.codebehind.classSuffix";
    protected String classSuffix = "Action";
    protected static final String CHECK_IMPLEMENTS_ACTION = "struts.codebehind.checkImplementsAction";
    protected boolean checkImplementsAction = true;
    protected static final String CHECK_ANNOTATION = "struts.codebehind.checkAnnotation";
    protected boolean checkAnnotation = true;
    private PageLocator pageLocator = new ClasspathPageLocator();
    private boolean initialized = false;
    private boolean disableActionScanning = false;
    private PackageLoader packageLoader;
    private static final Logger LOG = LoggerFactory.getLogger(ClasspathPackageProvider.class);
    private Configuration configuration;
    private String actionPackages;
    private ServletContext servletContext;

    @Inject(value="actionPackages")
    public void setActionPackages(String packages) {
        this.actionPackages = packages;
    }

    public void setServletContext(ServletContext ctx) {
        this.servletContext = ctx;
    }

    @Inject(value="struts.configuration.classpath.disableActionScanning", required=false)
    public void setDisableActionScanning(String disableActionScanning) {
        this.disableActionScanning = "true".equals(disableActionScanning);
    }

    @Inject(value="struts.codebehind.checkImplementsAction", required=false)
    public void setCheckImplementsAction(String checkImplementsAction) {
        this.checkImplementsAction = "true".equals(checkImplementsAction);
    }

    @Inject(value="struts.codebehind.checkAnnotation", required=false)
    public void setCheckAnnotation(String checkAnnotation) {
        this.checkAnnotation = "true".equals(checkAnnotation);
    }

    @Inject(value="struts.configuration.classpath.defaultParentPackage", required=false)
    public void setDefaultParentPackage(String defaultParentPackage) {
        this.defaultParentPackage = defaultParentPackage;
    }

    @Inject(value="struts.configuration.classpath.defaultPageExtension", required=false)
    public void setDefaultPageExtension(String defaultPageExtension) {
        this.defaultPageExtension = defaultPageExtension;
    }

    @Inject(value="struts.configuration.classpath.defaultPagePrefix", required=false)
    public void setDefaultPagePrefix(String defaultPagePrefix) {
        this.defaultPagePrefix = defaultPagePrefix;
    }

    @Inject(value="struts.codebehind.classSuffix", required=false)
    public void setClassSuffix(String classSuffix) {
        this.classSuffix = classSuffix;
    }

    @Inject(value="struts.configuration.classpath.forceLowerCase", required=false)
    public void setForceLowerCase(String force) {
        this.forceLowerCase = "true".equals(force);
    }

    public void setPageLocator(PageLocator locator) {
        this.pageLocator = locator;
    }

    protected void loadPackages(String[] pkgs) {
        this.packageLoader = new PackageLoader();
        ResolverUtil resolver = new ResolverUtil();
        resolver.find((ResolverUtil.Test)this.createActionClassTest(), pkgs);
        Set actionClasses = resolver.getClasses();
        for (Object obj : actionClasses) {
            Class cls = (Class)obj;
            if (Modifier.isAbstract(cls.getModifiers())) continue;
            this.processActionClass(cls, pkgs);
        }
        for (PackageConfig config : this.packageLoader.createPackageConfigs()) {
            this.configuration.addPackageConfig(config.getName(), config);
        }
    }

    protected ResolverUtil.ClassTest createActionClassTest() {
        return new ResolverUtil.ClassTest(){

            public boolean matches(Class type) {
                return ClasspathPackageProvider.this.checkImplementsAction && com.opensymphony.xwork2.Action.class.isAssignableFrom(type) || type.getSimpleName().endsWith(ClasspathPackageProvider.this.getClassSuffix()) || ClasspathPackageProvider.this.checkAnnotation && type.getAnnotation(Action.class) != null;
            }
        };
    }

    protected String getClassSuffix() {
        return this.classSuffix;
    }

    protected void processActionClass(Class<?> cls, String[] pkgs) {
        List<PackageConfig> parents;
        String name = cls.getName();
        String actionPackage = cls.getPackage().getName();
        String actionNamespace = null;
        String actionName = null;
        Action actionAnn = cls.getAnnotation(Action.class);
        if (actionAnn != null) {
            actionName = actionAnn.name();
            actionNamespace = actionAnn.namespace().equals("__default_namespace__") ? "" : actionAnn.namespace();
        } else {
            for (String pkg : pkgs) {
                if (!name.startsWith(pkg)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("ClasspathPackageProvider: Processing class " + name, new String[0]);
                }
                name = name.substring(pkg.length() + 1);
                actionNamespace = "";
                actionName = name;
                int pos = name.lastIndexOf(46);
                if (pos <= -1) break;
                actionNamespace = "/" + name.substring(0, pos).replace('.', '/');
                actionName = name.substring(pos + 1);
                break;
            }
            if (actionName.endsWith(this.getClassSuffix())) {
                actionName = actionName.substring(0, actionName.length() - this.getClassSuffix().length());
            }
            if (this.forceLowerCase && actionName.length() > 1) {
                int lowerPos = actionName.lastIndexOf(47) + 1;
                StringBuilder sb = new StringBuilder();
                sb.append(actionName.substring(0, lowerPos));
                sb.append(Character.toLowerCase(actionName.charAt(lowerPos)));
                sb.append(actionName.substring(lowerPos + 1));
                actionName = sb.toString();
            }
        }
        PackageConfig.Builder pkgConfig = this.loadPackageConfig(actionNamespace, actionPackage, cls);
        if (!actionPackage.equals(pkgConfig.getName())) {
            actionPackage = pkgConfig.getName();
        }
        if ((parents = this.findAllParentPackages(cls)).size() > 0) {
            pkgConfig.addParents(parents);
            PackageConfig firstParent = parents.get(0);
            if (StringUtils.isEmpty((CharSequence)pkgConfig.getNamespace()) && StringUtils.isNotEmpty((CharSequence)firstParent.getNamespace())) {
                pkgConfig.namespace(firstParent.getNamespace());
            }
        }
        ResultTypeConfig defaultResultType = this.packageLoader.getDefaultResultType(pkgConfig);
        ActionConfig actionConfig = new ActionConfig.Builder(actionPackage, actionName, cls.getName()).addResultConfigs(new ResultMap(cls, actionName, defaultResultType)).build();
        pkgConfig.addActionConfig(actionName, actionConfig);
    }

    private List<PackageConfig> findAllParentPackages(Class<?> cls) {
        ArrayList<PackageConfig> parents = new ArrayList<PackageConfig>();
        LinkedHashSet<String> parentNames = new LinkedHashSet<String>();
        ParentPackage annotation = cls.getPackage().getAnnotation(ParentPackage.class);
        if (annotation != null) {
            parentNames.addAll(Arrays.asList(annotation.value()));
        }
        if ((annotation = cls.getAnnotation(ParentPackage.class)) != null) {
            parentNames.addAll(Arrays.asList(annotation.value()));
        }
        if (parentNames.size() > 0) {
            for (String parent : parentNames) {
                PackageConfig parentPkg = this.configuration.getPackageConfig(parent);
                if (parentPkg == null) {
                    throw new ConfigurationException("ClasspathPackageProvider: Unable to locate parent package " + parent, (Object)annotation);
                }
                parents.add(parentPkg);
            }
        }
        return parents;
    }

    protected PackageConfig.Builder loadPackageConfig(String actionNamespace, String actionPackage, Class actionClass) {
        PackageConfig.Builder pkgConfig;
        PackageConfig.Builder parent = null;
        if (actionClass != null) {
            Namespace ns = actionClass.getAnnotation(Namespace.class);
            if (ns != null) {
                parent = this.loadPackageConfig(actionNamespace, actionPackage, null);
                actionNamespace = ns.value();
                actionPackage = actionClass.getName();
            } else {
                Action actionAnn = actionClass.getAnnotation(Action.class);
                if (actionAnn != null) {
                    if (!"__default_namespace__".equals(actionAnn.namespace())) {
                        parent = this.loadPackageConfig(null, actionPackage, null);
                        actionPackage = actionClass.getName();
                    }
                }
            }
        }
        if ((pkgConfig = this.packageLoader.getPackage(actionPackage)) == null) {
            pkgConfig = new PackageConfig.Builder(actionPackage);
            pkgConfig.namespace(actionNamespace);
            if (parent == null) {
                PackageConfig cfg = this.configuration.getPackageConfig(this.defaultParentPackage);
                if (cfg != null) {
                    pkgConfig.addParent(cfg);
                } else {
                    throw new ConfigurationException("ClasspathPackageProvider: Unable to locate default parent package: " + this.defaultParentPackage);
                }
            }
            this.packageLoader.registerPackage(pkgConfig);
        } else if (pkgConfig.getNamespace() == null) {
            pkgConfig.namespace(actionNamespace);
        }
        if (parent != null) {
            this.packageLoader.registerChildToParent(pkgConfig, parent);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("class:" + actionClass + " parent:" + parent + " current:" + (pkgConfig != null ? pkgConfig.getName() : ""), new String[0]);
        }
        return pkgConfig;
    }

    public void destroy() {
    }

    public void init(Configuration config) {
        this.configuration = config;
    }

    public void loadPackages() throws ConfigurationException {
        if (this.actionPackages != null && !this.disableActionScanning) {
            String[] names = this.actionPackages.split("\\s*[,]\\s*");
            if (names.length > 0) {
                this.setPageLocator(new ServletContextPageLocator(this.servletContext));
            }
            this.loadPackages(names);
        }
        this.initialized = true;
    }

    public boolean needsReload() {
        return !this.initialized;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PackageLoader {
        private Map<String, PackageConfig.Builder> packageConfigBuilders = new HashMap<String, PackageConfig.Builder>();
        private Map<PackageConfig.Builder, PackageConfig.Builder> childToParent = new HashMap<PackageConfig.Builder, PackageConfig.Builder>();

        private PackageLoader() {
        }

        public PackageConfig.Builder getPackage(String name) {
            return this.packageConfigBuilders.get(name);
        }

        public void registerChildToParent(PackageConfig.Builder child, PackageConfig.Builder parent) {
            this.childToParent.put(child, parent);
        }

        public void registerPackage(PackageConfig.Builder builder) {
            this.packageConfigBuilders.put(builder.getName(), builder);
        }

        public Collection<PackageConfig> createPackageConfigs() {
            Set<PackageConfig.Builder> builders;
            HashMap<String, PackageConfig> configs = new HashMap<String, PackageConfig>();
            while ((builders = this.findPackagesWithNoParents()).size() > 0) {
                for (PackageConfig.Builder parent : builders) {
                    PackageConfig config = parent.build();
                    configs.put(config.getName(), config);
                    this.packageConfigBuilders.remove(config.getName());
                    Iterator<Map.Entry<PackageConfig.Builder, PackageConfig.Builder>> i = this.childToParent.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry<PackageConfig.Builder, PackageConfig.Builder> entry = i.next();
                        if (entry.getValue() != parent) continue;
                        entry.getKey().addParent(config);
                        i.remove();
                    }
                }
            }
            return configs.values();
        }

        Set<PackageConfig.Builder> findPackagesWithNoParents() {
            HashSet<PackageConfig.Builder> builders = new HashSet<PackageConfig.Builder>();
            for (PackageConfig.Builder child : this.packageConfigBuilders.values()) {
                if (this.childToParent.containsKey(child)) continue;
                builders.add(child);
            }
            return builders;
        }

        public ResultTypeConfig getDefaultResultType(PackageConfig.Builder pkgConfig) {
            PackageConfig.Builder parent;
            PackageConfig.Builder current = pkgConfig;
            while ((parent = this.childToParent.get(current)) != null) {
                current = parent;
            }
            return current.getResultType(current.getFullDefaultResultType());
        }
    }

    private final class ServletContextPageLocator
    implements PageLocator {
        private final ServletContext context;
        private ClasspathPageLocator classpathPageLocator = new ClasspathPageLocator();

        private ServletContextPageLocator(ServletContext context) {
            this.context = context;
        }

        public URL locate(String path) {
            URL url;
            block3: {
                url = null;
                try {
                    url = this.context.getResource(path);
                    if (url == null) {
                        url = this.classpathPageLocator.locate(path);
                    }
                }
                catch (MalformedURLException e) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug("Unable to resolve path " + path + " against the servlet context", new String[0]);
                }
            }
            return url;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ResultMap<K, V>
    extends HashMap<K, V> {
        private Class actionClass;
        private String actionName;
        private ResultTypeConfig defaultResultType;

        public ResultMap(Class actionClass, String actionName, ResultTypeConfig defaultResultType) {
            this.actionClass = actionClass;
            this.actionName = actionName;
            this.defaultResultType = defaultResultType;
            while (!actionClass.getName().equals(Object.class.getName())) {
                ResultConfig config;
                Result result;
                Results results = actionClass.getAnnotation(Results.class);
                if (results != null) {
                    for (int i = 0; i < results.value().length; ++i) {
                        Result result2 = results.value()[i];
                        ResultConfig config2 = this.createResultConfig(result2);
                        if (this.containsKey(config2.getName())) continue;
                        this.put(config2.getName(), config2);
                    }
                }
                if ((result = actionClass.getAnnotation(Result.class)) != null && !this.containsKey((config = this.createResultConfig(result)).getName())) {
                    this.put(config.getName(), config);
                }
                actionClass = actionClass.getSuperclass();
            }
        }

        protected ResultConfig createResultConfig(Result result) {
            Class<? extends com.opensymphony.xwork2.Result> cls = result.type();
            if (cls == NullResult.class) {
                cls = null;
            }
            return this.createResultConfig(result.name(), cls, result.value(), this.createParameterMap(result.params()));
        }

        protected Map<String, String> createParameterMap(String[] parms) {
            HashMap<String, String> map = new HashMap<String, String>();
            int subtract = parms.length % 2;
            if (subtract != 0) {
                LOG.warn("Odd number of result parameters key/values specified.  The final one will be ignored.", new String[0]);
            }
            for (int i = 0; i < parms.length - subtract; ++i) {
                String key = parms[i++];
                String value = parms[i];
                map.put(key, value);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Adding parmeter[" + key + ":" + value + "] to result.", new String[0]);
            }
            return map;
        }

        private ResultConfig createResultConfig(Object key, Class<? extends Object> resultClass, String location, Map<? extends Object, ? extends Object> configParams) {
            String defaultParam;
            if (resultClass == null) {
                configParams = this.defaultResultType.getParams();
                String className = this.defaultResultType.getClassName();
                try {
                    resultClass = ClassLoaderUtil.loadClass((String)className, this.getClass());
                }
                catch (ClassNotFoundException ex) {
                    throw new ConfigurationException("ClasspathPackageProvider: Unable to locate result class " + className, (Object)this.actionClass);
                }
            }
            try {
                defaultParam = (String)resultClass.getField("DEFAULT_PARAM").get(null);
            }
            catch (Exception e) {
                defaultParam = "location";
            }
            HashMap<String, String> params = new HashMap<String, String>();
            if (configParams != null) {
                params.putAll(configParams);
            }
            params.put(defaultParam, location);
            return new ResultConfig.Builder((String)key, resultClass.getName()).addParams(params).build();
        }
    }

    public static class ClasspathPageLocator
    implements PageLocator {
        public URL locate(String path) {
            return ClassLoaderUtil.getResource((String)path, this.getClass());
        }
    }

    public static interface PageLocator {
        public URL locate(String var1);
    }
}

