/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import javax.activation.DataHandler;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.ContentDisposition;
import javax.mail.internet.ContentType;
import javax.mail.internet.HeaderTokenizer;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;
import org.apache.geronimo.mail.util.ASCIIUtil;
import org.apache.geronimo.mail.util.SessionUtil;

public class MimeBodyPart
extends BodyPart
implements MimePart {
    private static final String MIME_DECODEFILENAME = "mail.mime.decodefilename";
    private static final String MIME_SETDEFAULTTEXTCHARSET = "mail.mime.setdefaulttextcharset";
    protected DataHandler dh;
    protected byte[] content;
    protected InputStream contentStream;
    protected InternetHeaders headers;

    public MimeBodyPart() {
        this.headers = new InternetHeaders();
    }

    public MimeBodyPart(InputStream in) throws MessagingException {
        this.headers = new InternetHeaders(in);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int count;
            while ((count = in.read(buffer, 0, 1024)) != -1) {
                baos.write(buffer, 0, count);
            }
        }
        catch (IOException e) {
            throw new MessagingException(e.toString(), e);
        }
        this.content = baos.toByteArray();
    }

    public MimeBodyPart(InternetHeaders headers, byte[] content) throws MessagingException {
        this.headers = headers;
        this.content = content;
    }

    public int getSize() throws MessagingException {
        if (this.content != null) {
            return this.content.length;
        }
        if (this.contentStream != null) {
            try {
                int size = this.contentStream.available();
                if (size > 0) {
                    return size;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return -1;
    }

    public int getLineCount() throws MessagingException {
        return -1;
    }

    public String getContentType() throws MessagingException {
        String value = this.getSingleHeader("Content-Type");
        if (value == null) {
            value = "text/plain";
        }
        return value;
    }

    public boolean isMimeType(String type) throws MessagingException {
        return new ContentType(this.getContentType()).match(type);
    }

    public String getDisposition() throws MessagingException {
        String disp = this.getSingleHeader("Content-Disposition");
        if (disp != null) {
            return new ContentDisposition(disp).getDisposition();
        }
        return null;
    }

    public void setDisposition(String disposition) throws MessagingException {
        if (disposition == null) {
            this.removeHeader("Content-Disposition");
        } else {
            String currentHeader = this.getSingleHeader("Content-Disposition");
            if (currentHeader != null) {
                ContentDisposition content = new ContentDisposition(currentHeader);
                content.setDisposition(disposition);
                this.setHeader("Content-Disposition", content.toString());
            } else {
                this.setHeader("Content-Disposition", disposition);
            }
        }
    }

    public String getEncoding() throws MessagingException {
        String encoding = this.getSingleHeader("Content-Transfer-Encoding");
        if (encoding != null) {
            HeaderTokenizer tokenizer = new HeaderTokenizer(encoding, "()<>@,;:\\\"\t []/?=");
            HeaderTokenizer.Token token = tokenizer.next();
            while (token.getType() != -4) {
                if (token.getType() != -1) continue;
                return token.getValue();
            }
            return encoding;
        }
        return null;
    }

    public String getContentID() throws MessagingException {
        return this.getSingleHeader("Content-ID");
    }

    public void setContentID(String cid) throws MessagingException {
        this.setOrRemoveHeader("Content-ID", cid);
    }

    public String getContentMD5() throws MessagingException {
        return this.getSingleHeader("Content-MD5");
    }

    public void setContentMD5(String md5) throws MessagingException {
        this.setHeader("Content-MD5", md5);
    }

    public String[] getContentLanguage() throws MessagingException {
        return this.getHeader("Content-Language");
    }

    public void setContentLanguage(String[] languages) throws MessagingException {
        if (languages == null) {
            this.removeHeader("Content-Language");
        } else if (languages.length == 1) {
            this.setHeader("Content-Language", languages[0]);
        } else {
            StringBuffer buf = new StringBuffer(languages.length * 20);
            buf.append(languages[0]);
            for (int i = 1; i < languages.length; ++i) {
                buf.append(',').append(languages[i]);
            }
            this.setHeader("Content-Language", buf.toString());
        }
    }

    public String getDescription() throws MessagingException {
        String description = this.getSingleHeader("Content-Description");
        if (description != null) {
            try {
                return MimeUtility.decodeText(ASCIIUtil.unfold(description));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return description;
    }

    public void setDescription(String description) throws MessagingException {
        this.setDescription(description, null);
    }

    public void setDescription(String description, String charset) throws MessagingException {
        if (description == null) {
            this.removeHeader("Content-Description");
        } else {
            try {
                this.setHeader("Content-Description", ASCIIUtil.fold(21, MimeUtility.encodeText(description, charset, null)));
            }
            catch (UnsupportedEncodingException e) {
                throw new MessagingException(e.getMessage(), e);
            }
        }
    }

    public String getFileName() throws MessagingException {
        String type;
        String disposition = this.getDisposition();
        String filename = null;
        if (disposition != null) {
            filename = new ContentDisposition(disposition).getParameter("filename");
        }
        if (filename == null && (type = this.getContentType()) != null) {
            try {
                filename = new ContentType(type).getParameter("name");
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        if (filename != null && SessionUtil.getBooleanProperty(MIME_DECODEFILENAME, false)) {
            try {
                filename = MimeUtility.decodeText(filename);
            }
            catch (UnsupportedEncodingException e) {
                throw new MessagingException("Unable to decode filename", e);
            }
        }
        return filename;
    }

    public void setFileName(String name) throws MessagingException {
        String disposition;
        if (name == null) {
            try {
                name = MimeUtility.encodeText(name);
            }
            catch (UnsupportedEncodingException e) {
                throw new MessagingException("Unable to encode filename", e);
            }
        }
        if ((disposition = this.getDisposition()) == null) {
            disposition = "attachment";
        }
        ContentDisposition contentDisposition = new ContentDisposition(disposition);
        contentDisposition.setParameter("filename", name);
        this.setDisposition(contentDisposition.toString());
    }

    public InputStream getInputStream() throws MessagingException, IOException {
        return this.getDataHandler().getInputStream();
    }

    protected InputStream getContentStream() throws MessagingException {
        if (this.contentStream != null) {
            return this.contentStream;
        }
        if (this.content != null) {
            return new ByteArrayInputStream(this.content);
        }
        throw new MessagingException("No content");
    }

    public InputStream getRawInputStream() throws MessagingException {
        return this.getContentStream();
    }

    public synchronized DataHandler getDataHandler() throws MessagingException {
        if (this.dh == null) {
            this.dh = new DataHandler(new MimePartDataSource(this));
        }
        return this.dh;
    }

    public Object getContent() throws MessagingException, IOException {
        return this.getDataHandler().getContent();
    }

    public void setDataHandler(DataHandler handler) throws MessagingException {
        this.dh = handler;
        this.removeHeader("Content-Type");
        this.removeHeader("Content-Transfer-Encoding");
    }

    public void setContent(Object content, String type) throws MessagingException {
        this.setDataHandler(new DataHandler(content, type));
    }

    public void setText(String text) throws MessagingException {
        this.setText(text, null);
    }

    public void setText(String text, String charset) throws MessagingException {
        if (charset == null) {
            charset = !ASCIIUtil.isAscii(text) ? MimeUtility.getDefaultMIMECharset() : "us-ascii";
        }
        this.setContent(text, "text/plain; charset=" + MimeUtility.quote(charset, "()<>@,;:\\\"\t []/?="));
    }

    public void setContent(Multipart part) throws MessagingException {
        this.setDataHandler(new DataHandler(part, part.getContentType()));
        part.setParent(this);
    }

    public void writeTo(OutputStream out) throws IOException, MessagingException {
        this.headers.writeTo(out, null);
        out.write(13);
        out.write(10);
        OutputStream encodingStream = MimeUtility.encode(out, this.getEncoding());
        this.getDataHandler().writeTo(encodingStream);
        encodingStream.flush();
    }

    public String[] getHeader(String name) throws MessagingException {
        return this.headers.getHeader(name);
    }

    public String getHeader(String name, String delimiter) throws MessagingException {
        return this.headers.getHeader(name, delimiter);
    }

    public void setHeader(String name, String value) throws MessagingException {
        this.headers.setHeader(name, value);
    }

    private void setOrRemoveHeader(String name, String value) throws MessagingException {
        if (value == null) {
            this.headers.removeHeader(name);
        } else {
            this.headers.setHeader(name, value);
        }
    }

    public void addHeader(String name, String value) throws MessagingException {
        this.headers.addHeader(name, value);
    }

    public void removeHeader(String name) throws MessagingException {
        this.headers.removeHeader(name);
    }

    public Enumeration getAllHeaders() throws MessagingException {
        return this.headers.getAllHeaders();
    }

    public Enumeration getMatchingHeaders(String[] name) throws MessagingException {
        return this.headers.getMatchingHeaders(name);
    }

    public Enumeration getNonMatchingHeaders(String[] name) throws MessagingException {
        return this.headers.getNonMatchingHeaders(name);
    }

    public void addHeaderLine(String line) throws MessagingException {
        this.headers.addHeaderLine(line);
    }

    public Enumeration getAllHeaderLines() throws MessagingException {
        return this.headers.getAllHeaderLines();
    }

    public Enumeration getMatchingHeaderLines(String[] names) throws MessagingException {
        return this.headers.getMatchingHeaderLines(names);
    }

    public Enumeration getNonMatchingHeaderLines(String[] names) throws MessagingException {
        return this.headers.getNonMatchingHeaderLines(names);
    }

    protected void updateHeaders() throws MessagingException {
        DataHandler handler = this.getDataHandler();
        try {
            String type = this.dh.getContentType();
            ContentType content = new ContentType(type);
            if (content.match("multipart/*")) {
                try {
                    MimeMultipart part = (MimeMultipart)handler.getContent();
                    part.updateHeaders();
                }
                catch (ClassCastException e) {
                    throw new MessagingException("Message content is not MimeMultipart", e);
                }
            } else if (!content.match("message/rfc822")) {
                if (this.getSingleHeader("Content-Transfer-Encoding") == null) {
                    this.setHeader("Content-Transfer-Encoding", MimeUtility.getEncoding(handler));
                }
                if (this.getHeader("Content-Type") == null && SessionUtil.getBooleanProperty(MIME_SETDEFAULTTEXTCHARSET, true) && content.match("text/*") && content.getParameter("charset") == null) {
                    String encoding = this.getEncoding();
                    if (encoding != null && encoding.equalsIgnoreCase("7bit")) {
                        content.setParameter("charset", "us-ascii");
                    } else {
                        content.setParameter("charset", MimeUtility.getDefaultMIMECharset());
                    }
                }
            }
            if (this.getSingleHeader("Content-Type") == null) {
                ContentDisposition disposition;
                String filename;
                String disp = this.getHeader("Content-Disposition", null);
                if (disp != null && (filename = (disposition = new ContentDisposition(disp)).getParameter("filename")) != null) {
                    content.setParameter("name", filename);
                }
                this.setHeader("Content-Type", content.toString());
            }
        }
        catch (IOException e) {
            throw new MessagingException("Error updating message headers", e);
        }
    }

    private String getSingleHeader(String name) throws MessagingException {
        String[] values = this.getHeader(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }
}

