/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.mail.Address;
import javax.mail.Header;
import javax.mail.MessagingException;

public class InternetHeaders {
    private final LinkedHashMap headers = new LinkedHashMap();
    private transient String lastHeaderName;

    public InternetHeaders() {
        this.setHeaderList("Date", null);
        this.setHeaderList("Resent-Date", null);
        this.setHeaderList("Return-path", null);
        this.setHeaderList("Received", null);
        this.setHeaderList("Sender", null);
        this.setHeaderList("From", null);
        this.setHeaderList("Reply-To", null);
        this.setHeaderList("Resent-Sender", null);
        this.setHeaderList("Resent-From", null);
        this.setHeaderList("Resent-Reply-To", null);
        this.setHeaderList("To", null);
        this.setHeaderList("Resent-To", null);
        this.setHeaderList("cc", null);
        this.setHeaderList("Resent-cc", null);
        this.setHeaderList("bcc", null);
        this.setHeaderList("Resent-bcc", null);
        this.setHeaderList("Message-ID", null);
        this.setHeaderList("Resent-Message-ID", null);
        this.setHeaderList("In-Reply-To", null);
        this.setHeaderList("References", null);
        this.setHeaderList("Keywords", null);
        this.setHeaderList("Subject", null);
        this.setHeaderList("Comments", null);
        this.setHeaderList("Encrypted", null);
    }

    public InternetHeaders(InputStream in) throws MessagingException {
        this.load(in);
    }

    public void load(InputStream in) throws MessagingException {
        try {
            int c;
            StringBuffer name = new StringBuffer(32);
            StringBuffer value = new StringBuffer(128);
            block2: do {
                char ch;
                block10: {
                    c = in.read();
                    ch = (char)c;
                    if (c == -1) break;
                    if (c == 13) {
                        in.read();
                        break;
                    }
                    if (Character.isWhitespace(ch)) {
                        while ((c = in.read()) != -1) {
                            ch = (char)c;
                            if (Character.isWhitespace(ch)) continue;
                            break block10;
                        }
                        break;
                    }
                    if (name.length() > 0) {
                        this.addHeader(name.toString().trim(), value.toString().trim());
                    }
                    name.setLength(0);
                    value.setLength(0);
                    do {
                        name.append((char)c);
                        c = in.read();
                        if (c == -1) break block2;
                    } while (c != 58);
                    c = in.read();
                    if (c == -1) break;
                }
                while (c != 13) {
                    ch = (char)c;
                    value.append(ch);
                    c = in.read();
                    if (c != -1) continue;
                    break block2;
                }
            } while ((c = in.read()) != -1);
            if (name.length() > 0) {
                this.addHeader(name.toString().trim(), value.toString().trim());
            }
        }
        catch (IOException e) {
            throw new MessagingException("Error loading headers", e);
        }
    }

    public String[] getHeader(String name) {
        List headers = this.getHeaderList(name);
        if (headers == null) {
            return null;
        }
        String[] result = new String[headers.size()];
        for (int i = 0; i < headers.size(); ++i) {
            InternetHeader header = (InternetHeader)headers.get(i);
            result[i] = header.getValue();
        }
        return result;
    }

    public String getHeader(String name, String delimiter) {
        List list = this.getHeaderList(name);
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return "";
        }
        if (list.size() == 1 || delimiter == null) {
            return ((InternetHeader)list.get(0)).getValue();
        }
        StringBuffer buf = new StringBuffer(20 * list.size());
        buf.append(((InternetHeader)list.get(0)).getValue());
        for (int i = 1; i < list.size(); ++i) {
            buf.append(delimiter);
            buf.append(((InternetHeader)list.get(i)).getValue());
        }
        return buf.toString();
    }

    public void setHeader(String name, String value) {
        ArrayList<InternetHeader> list = new ArrayList<InternetHeader>();
        list.add(new InternetHeader(name, value));
        this.setHeaderList(name, list);
    }

    public void addHeader(String name, String value) {
        ArrayList<InternetHeader> list = this.getHeaderList(name);
        if (list == null) {
            list = new ArrayList<InternetHeader>();
            this.headers.put(name.toLowerCase(), list);
        }
        list.add(new InternetHeader(name, value));
    }

    public void removeHeader(String name) {
        List list = this.getHeaderList(name);
        if (list != null) {
            list.clear();
        }
    }

    public Enumeration getAllHeaders() {
        ArrayList result = new ArrayList(this.headers.size() * 2);
        Iterator it = this.headers.values().iterator();
        while (it.hasNext()) {
            List list = (List)it.next();
            if (list == null) continue;
            result.addAll(list);
        }
        return Collections.enumeration(result);
    }

    public Enumeration getMatchingHeaders(String[] names) {
        HashSet<String> include = new HashSet<String>(names.length);
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            include.add(name.toLowerCase());
        }
        ArrayList result = new ArrayList(this.headers.size());
        Iterator i = this.headers.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (entry.getValue() == null || !include.contains(((String)entry.getKey()).toLowerCase())) continue;
            result.addAll((List)entry.getValue());
        }
        return Collections.enumeration(result);
    }

    public Enumeration getNonMatchingHeaders(String[] names) {
        HashSet<String> exclude = new HashSet<String>(names.length);
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            exclude.add(name.toLowerCase());
        }
        ArrayList result = new ArrayList(this.headers.size());
        Iterator i = this.headers.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (entry.getValue() == null || exclude.contains(((String)entry.getKey()).toLowerCase())) continue;
            result.addAll((List)entry.getValue());
        }
        return Collections.enumeration(result);
    }

    public void addHeaderLine(String line) {
        StringBuffer name = new StringBuffer(32);
        StringBuffer value = new StringBuffer(128);
        boolean inName = true;
        boolean continuation = false;
        if (Character.isWhitespace(line.charAt(0))) {
            continuation = true;
            inName = false;
        }
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (inName && c == ':') {
                inName = false;
                continue;
            }
            if (inName) {
                name.append(c);
                continue;
            }
            value.append(c);
        }
        if (continuation) {
            List list = this.getHeaderList(this.lastHeaderName);
            Header h = (Header)list.remove(list.size() - 1);
            list.add(new InternetHeader(this.lastHeaderName, (h.getValue() + value.toString()).trim()));
        } else {
            this.lastHeaderName = name.toString().trim();
            this.addHeader(this.lastHeaderName, value.toString().trim());
        }
    }

    public Enumeration getAllHeaderLines() {
        return new HeaderLineEnumeration(this.getAllHeaders());
    }

    public Enumeration getMatchingHeaderLines(String[] names) {
        return new HeaderLineEnumeration(this.getMatchingHeaders(names));
    }

    public Enumeration getNonMatchingHeaderLines(String[] names) {
        return new HeaderLineEnumeration(this.getNonMatchingHeaders(names));
    }

    void setHeader(String name, Address[] addresses) {
        ArrayList<InternetHeader> list = new ArrayList<InternetHeader>(addresses.length);
        for (int i = 0; i < addresses.length; ++i) {
            Address address = addresses[i];
            list.add(new InternetHeader(name, address.toString()));
        }
        this.headers.put(name.toLowerCase(), list);
    }

    private List getHeaderList(String name) {
        return (List)this.headers.get(name.toLowerCase());
    }

    private void setHeaderList(String name, List list) {
        this.headers.put(name.toLowerCase(), list);
    }

    void writeTo(OutputStream out, String[] ignore) throws IOException {
        LinkedHashMap map = new LinkedHashMap(this.headers);
        if (ignore != null) {
            for (int i = 0; i < ignore.length; ++i) {
                String key = ignore[i].toLowerCase();
                map.remove(key);
            }
        }
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String name = (String)entry.getKey();
            List headers = (List)entry.getValue();
            if (headers == null) continue;
            for (int j = 0; j < headers.size(); ++j) {
                InternetHeader header = (InternetHeader)headers.get(j);
                out.write(header.getName().getBytes());
                out.write(58);
                out.write(32);
                out.write(header.getValue().getBytes());
                out.write(13);
                out.write(10);
            }
        }
    }

    private static class HeaderLineEnumeration
    implements Enumeration {
        private Enumeration headers;

        public HeaderLineEnumeration(Enumeration headers) {
            this.headers = headers;
        }

        public boolean hasMoreElements() {
            return this.headers.hasMoreElements();
        }

        public Object nextElement() {
            Header h = (Header)this.headers.nextElement();
            return h.getName() + ": " + h.getValue();
        }
    }

    private static class InternetHeader
    extends Header {
        public InternetHeader(String name, String value) {
            super(name, value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof InternetHeader)) {
                return false;
            }
            InternetHeader other = (InternetHeader)obj;
            return this.getName().equalsIgnoreCase(other.getName());
        }

        public int hashCode() {
            return this.getName().toLowerCase().hashCode();
        }
    }
}

