/*
 * Decompiled with CFR 0.152.
 */
package jp.veritrans.tercerog.mdk.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import jp.veritrans.tercerog.mdk.MerchantConfig;
import jp.veritrans.tercerog.mdk.exception.MdkLocalException;
import jp.veritrans.tercerog.mdk.gw.utils.EncryptionUtils;
import jp.veritrans.tercerog.mdk.gw.utils.HashUtils;
import jp.veritrans.tercerog.mdk.util.Hmac;
import jp.veritrans.tercerog.mdk.util.MdkUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public class MdkMerchantUtility {
    private static String HMAC_ALGORITHM = "HmacSHA256";
    private static String DIGEST_ALGORITHN = "SHA-1";
    private static String DECODE_CHARSET = "utf-8";
    private static String COLON = ":";
    private static Logger logger = Logger.getLogger(MdkMerchantUtility.class);
    public static final String MD_ENCODE_CHARSET = "UTF-8";
    public static final String MD_SEPARATOR = "&";
    public static final String MD_PAIR_SEPARATOR = "=";

    private static String calcHmac(String string) throws MdkLocalException {
        if (string == null) {
            throw new MdkLocalException("message for hmac is null", "MB99");
        }
        MerchantConfig merchantConfig = new MerchantConfig();
        String string2 = merchantConfig.getProperty("MERCHANT_SECRET_KEY");
        try {
            Hmac hmac = Hmac.getInstance(HMAC_ALGORITHM);
            hmac.init(string2);
            return hmac.doFinal(string.getBytes(DECODE_CHARSET));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MdkLocalException("failed to create Mac instance, because of wrong algorithm", "MB98");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new MdkLocalException("key is inappropriate for initializing this MAC", "MB99");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MdkLocalException("failed to encode Mac, because of wrong charset", "MB99");
        }
    }

    private static String calcHmac(String string, String string2) throws MdkLocalException {
        if (string == null) {
            throw new MdkLocalException("merchant secret key is null", "MB99");
        }
        if (string2 == null) {
            throw new MdkLocalException("message for hmac is null", "MB99");
        }
        String string3 = string;
        try {
            Hmac hmac = Hmac.getInstance(HMAC_ALGORITHM);
            hmac.init(string3);
            return hmac.doFinal(string2.getBytes(DECODE_CHARSET));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MdkLocalException("failed to create Mac instance, because of wrong algorithm", "MB98");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new MdkLocalException("key is inappropriate for initializing this MAC", "MB99");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MdkLocalException("failed to encode Mac, because of wrong charset", "MB99");
        }
    }

    public static boolean checkMessage(String string, String string2) throws MdkLocalException {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        int n = string2.indexOf(";v=");
        if (n == -1) {
            return false;
        }
        String string3 = string2.substring(n + ";v=".length(), string2.length());
        String string4 = MdkMerchantUtility.calcHmac(string);
        if (string4 == null || string4.length() == 0) {
            return false;
        }
        return string3.equals(string4);
    }

    public static boolean checkMessage(String string, String string2, String string3) throws MdkLocalException {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        if (string3 == null || string3.length() == 0) {
            return false;
        }
        int n = string3.indexOf(";v=");
        if (n == -1) {
            return false;
        }
        String string4 = string3.substring(n + ";v=".length(), string3.length());
        String string5 = MdkMerchantUtility.calcHmac(string, string2);
        if (string5 == null || string5.length() == 0) {
            return false;
        }
        return string4.equals(string5);
    }

    public static String getSecret(String string) throws MdkLocalException {
        if (string == null || string.length() == 0) {
            return "";
        }
        int n = string.indexOf(";s=");
        int n2 = string.indexOf(";v=");
        if (n == -1 || n2 == -1) {
            return "";
        }
        String string2 = string.substring(n + ";s=".length(), n2);
        return string2;
    }

    public static String sign(String string, String string2) throws MdkLocalException {
        if (string == null || string2 == null || string2.length() == 0) {
            throw new MdkLocalException("null pointer exception", "MA99");
        }
        MerchantConfig merchantConfig = new MerchantConfig();
        String string3 = merchantConfig.getProperty("MERCHANT_CCID");
        byte[] byArray = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(DIGEST_ALGORITHN);
            messageDigest.update(string3.getBytes());
            messageDigest.update(COLON.getBytes());
            messageDigest.update(string2.getBytes());
            messageDigest.update(COLON.getBytes());
            messageDigest.update(string.getBytes());
            byArray = messageDigest.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MdkLocalException("no Provider supports a MessageDigestSpi implementation for the specified algorithm", "MA99");
        }
        return MdkUtil.bytes2Hex(byArray);
    }

    public static boolean verifySign(String string, String string2, String string3) throws MdkLocalException {
        String string4 = MdkMerchantUtility.sign(string, string2);
        if (string3 == null || string3.length() == 0) {
            return false;
        }
        return string3.toLowerCase().equals(string4);
    }

    public static String getTripartiteAuthHash() {
        String string = null;
        StringBuffer stringBuffer = null;
        try {
            MerchantConfig merchantConfig = new MerchantConfig();
            String string2 = merchantConfig.getProperty("MERCHANT_CCID");
            if (string2 == null) {
                throw new MdkLocalException("Merchant CCID is not set in MerchantConfig file.", "MA01");
            }
            String string3 = merchantConfig.getProperty("MERCHANT_SECRET_KEY");
            if (string3 == null) {
                throw new MdkLocalException("Merchant CCID is not set in MerchantConfig file.", "MA01");
            }
            String string4 = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
            string = HashUtils.getInstance().getDigest(new String[]{merchantConfig.getProperty("MERCHANT_CCID"), string4, merchantConfig.getProperty("MERCHANT_SECRET_KEY")});
            EncryptionUtils encryptionUtils = new EncryptionUtils();
            stringBuffer = new StringBuffer();
            stringBuffer.append(encryptionUtils.base64Enc(string2.getBytes())).append("-");
            stringBuffer.append(encryptionUtils.base64Enc(string4.getBytes())).append("-");
            stringBuffer.append(encryptionUtils.base64Enc(string.getBytes()));
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            logger.error((Object)("!!!!!!!!!! Error has occurred in getTripartiteAuthHash() MerchantConfig is not correct. " + exception.getMessage()), (Throwable)exception);
        }
        return stringBuffer.toString();
    }

    public static String createMerchantData(Map map) {
        try {
            String string;
            String string2;
            StringBuffer stringBuffer = new StringBuffer();
            String string3 = "";
            for (Map.Entry object2 : map.entrySet()) {
                stringBuffer.append(string3);
                string2 = (String)object2.getKey();
                if (string2 == null || string2.trim().length() == 0) continue;
                string = (String)object2.getValue();
                if (string == null) {
                    string = "";
                }
                stringBuffer.append(URLEncoder.encode(string2.toString(), MD_ENCODE_CHARSET));
                stringBuffer.append(MD_PAIR_SEPARATOR);
                stringBuffer.append(URLEncoder.encode(string.toString(), MD_ENCODE_CHARSET));
                string3 = MD_SEPARATOR;
            }
            Object object3 = stringBuffer.toString();
            MerchantConfig merchantConfig = new MerchantConfig();
            string2 = merchantConfig.getProperty("MERCHANT_SECRET_KEY");
            string = MdkMerchantUtility.sign((String)object3, string2);
            object3 = object3 == null ? string : string + MD_SEPARATOR + (String)object3;
            return new String(Base64.encodeBase64((byte[])((String)object3).getBytes()));
        }
        catch (Exception exception) {
            logger.error((Object)"!!!!!!!!!! Error has occurred in createMerchantData() Can not create MerchantData.", (Throwable)exception);
            return null;
        }
    }

    public static Map analyzeMerchantData(String string) {
        try {
            byte[] byArray = Base64.decodeBase64((byte[])string.getBytes());
            String string2 = new String(byArray);
            int n = string2.indexOf(MD_SEPARATOR);
            String string3 = null;
            string3 = 0 <= n ? string2.substring(0, n) : string2;
            String string4 = null;
            string4 = 0 < n && n + 1 < string2.length() ? string2.substring(n + 1) : "";
            MerchantConfig merchantConfig = new MerchantConfig();
            String string5 = merchantConfig.getProperty("MERCHANT_SECRET_KEY");
            if (!MdkMerchantUtility.verifySign(string4, string5, string3)) {
                logger.error((Object)"!!!!!!!!!! MerchantData is falsified.");
                return null;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string4, MD_SEPARATOR);
            while (stringTokenizer.hasMoreTokens()) {
                String string6 = stringTokenizer.nextToken();
                int n2 = string6.indexOf(MD_PAIR_SEPARATOR);
                int n3 = string6.length();
                if (n2 <= 0) continue;
                String string7 = string6.substring(0, n2);
                if ((string7 = URLDecoder.decode(string7, MD_ENCODE_CHARSET)) == null || string7.trim().length() == 0) continue;
                String string8 = null;
                if (n2 + 1 < n3) {
                    string8 = string6.substring(n2 + 1);
                    string8 = URLDecoder.decode(string8, MD_ENCODE_CHARSET);
                } else {
                    string8 = "";
                }
                hashMap.put(string7, string8);
            }
            return hashMap;
        }
        catch (Exception exception) {
            logger.error((Object)"!!!!!!!!!! Error has occurred in analyzeMerchantData() Can not analyze MerchantData.", (Throwable)exception);
            return null;
        }
    }
}

