/*
 * Decompiled with CFR 0.152.
 */
package jp.veritrans.tercerog.mdk.connection.ssl;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import jp.veritrans.tercerog.mdk.connection.proxy.ProxySocket;
import jp.veritrans.tercerog.mdk.connection.ssl.SSLConfigurator;

public class SSLSocketUtils {
    public SSLSocket createSSLSocket(String string, int n, SSLConfigurator sSLConfigurator) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, UnrecoverableKeyException, KeyManagementException, UnknownHostException, Exception {
        SSLSocketFactory sSLSocketFactory = this.getSSLSocketFactory(sSLConfigurator);
        ProxySocket proxySocket = new ProxySocket(2);
        Socket socket = proxySocket.getProxySocket();
        SSLSocket sSLSocket = null;
        if (socket != null) {
            sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(socket, string, n, true);
        } else {
            sSLSocket = (SSLSocket)sSLSocketFactory.createSocket();
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
            sSLSocket.connect(inetSocketAddress, sSLConfigurator.getConnectionTimeoutSec());
            sSLSocket.setSoTimeout(sSLConfigurator.getReadTimeoutSec());
        }
        if (sSLSocket.isClosed()) {
            sSLSocket.startHandshake();
        }
        return sSLSocket;
    }

    public SSLSocketFactory getSSLSocketFactory(SSLConfigurator sSLConfigurator) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, CertificateException, FileNotFoundException, UnrecoverableKeyException, IOException {
        String string = sSLConfigurator.getKeystorePath();
        String string2 = sSLConfigurator.getKeystorePass();
        String string3 = sSLConfigurator.getKeystoreType();
        String string4 = sSLConfigurator.getKeystoreAlgorithm();
        KeyManager[] keyManagerArray = null;
        if (string != null && string2 != null && string3 != null && string4 != null) {
            keyManagerArray = this.getKeyManager(string, string2, string3, string4);
        }
        String string5 = sSLConfigurator.getTruststorePath();
        String string6 = sSLConfigurator.getTruststorePass();
        String string7 = sSLConfigurator.getTruststoreType();
        String string8 = sSLConfigurator.getTruststoreAlgorithm();
        TrustManager[] trustManagerArray = this.getTrustManager(string5, string6, string7, string8);
        String string9 = sSLConfigurator.getProtocol();
        SSLContext sSLContext = SSLContext.getInstance(string9);
        SecureRandom secureRandom = new SecureRandom();
        sSLContext.init(keyManagerArray, trustManagerArray, secureRandom);
        SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
        return sSLSocketFactory;
    }

    public KeyManager[] getKeyManager(String string, String string2, String string3, String string4) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, UnrecoverableKeyException, KeyManagementException {
        FileInputStream fileInputStream = null;
        try {
            KeyManager[] keyManagerArray;
            fileInputStream = new FileInputStream(string);
            KeyStore keyStore = KeyStore.getInstance(string3);
            char[] cArray = string2.toCharArray();
            keyStore.load(fileInputStream, cArray);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(string4);
            keyManagerFactory.init(keyStore, cArray);
            KeyManager[] keyManagerArray2 = keyManagerArray = keyManagerFactory.getKeyManagers();
            return keyManagerArray2;
        }
        catch (KeyStoreException keyStoreException) {
            throw keyStoreException;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw noSuchAlgorithmException;
        }
        catch (CertificateException certificateException) {
            throw certificateException;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            throw unrecoverableKeyException;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public TrustManager[] getTrustManager(String string, String string2, String string3, String string4) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException {
        FileInputStream fileInputStream = null;
        try {
            TrustManager[] trustManagerArray;
            fileInputStream = new FileInputStream(string);
            KeyStore keyStore = KeyStore.getInstance(string3);
            char[] cArray = string2.toCharArray();
            keyStore.load(fileInputStream, cArray);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(string4);
            trustManagerFactory.init(keyStore);
            TrustManager[] trustManagerArray2 = trustManagerArray = trustManagerFactory.getTrustManagers();
            return trustManagerArray2;
        }
        catch (KeyStoreException keyStoreException) {
            throw keyStoreException;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw noSuchAlgorithmException;
        }
        catch (CertificateException certificateException) {
            throw certificateException;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

