/*
 * Decompiled with CFR 0.152.
 */
package jp.veritrans.tercerog.mdk.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthHashUtil {
    private static String DEFAULT_CHARSET = "UTF-8";
    private static final String DEFAULT_ALGORITHM_NAME = "SHA-256";

    public static boolean checkAuthHash(Map map, String string, String string2, String string3) throws UnsupportedEncodingException {
        Logger logger = AuthHashUtil.getLogger();
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String[] stringArray = (String[])map.get("authParams");
        if (stringArray != null && stringArray.length == 1) {
            string4 = stringArray[0];
        }
        if (string4 == null) {
            return false;
        }
        stringArray = (String[])map.get("vAuthInfo");
        if (stringArray != null && stringArray.length == 1) {
            string5 = stringArray[0];
        }
        if (string5 == null) {
            return false;
        }
        try {
            string6 = AuthHashUtil.createAuthHashInfo(map, string4, string, string2, string3);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.error("!!!!!!!!!! Error has occurred in checkAuthHash() because of wrong algorithm.", (Throwable)noSuchAlgorithmException);
            return false;
        }
        return string6 != null && string6.equals(string5);
    }

    private static String createAuthHashInfo(Map map, String string, String string2, String string3, String string4) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        Object[] objectArray;
        if (string == null) {
            return null;
        }
        byte[] byArray = Base64.decodeBase64((byte[])string.getBytes(DEFAULT_CHARSET));
        String[] stringArray = new String(byArray, DEFAULT_CHARSET).split(",", 0);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray = (String[])map.get(stringArray[i]);
            if (objectArray == null || objectArray.length != 1) {
                return null;
            }
            stringBuffer.append(objectArray[0]);
        }
        stringBuffer.append(string3);
        MessageDigest messageDigest = MessageDigest.getInstance(DEFAULT_ALGORITHM_NAME);
        messageDigest.update(stringBuffer.toString().getBytes(string4));
        objectArray = messageDigest.digest();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            String string5 = objectArray[i];
            AuthHashUtil.appendHalfByte(stringBuffer2, (string5 & 0xF0) >> 4);
            AuthHashUtil.appendHalfByte(stringBuffer2, string5 & 0xF);
        }
        return stringBuffer2.toString();
    }

    private static void appendHalfByte(StringBuffer stringBuffer, int n) {
        if (n < 10) {
            stringBuffer.append((char)(48 + n));
        } else {
            stringBuffer.append((char)(97 + (n - 10)));
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(AuthHashUtil.class);
    }
}

