/*
 * Decompiled with CFR 0.152.
 */
package jp.veritrans.tercerog.mdk.gw.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.Certificate;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.apache.tools.tar.TarOutputStream;

public class EncryptionUtils {
    private static final String SYMMETRIC_ALGORITHM = "AES";
    private static final String CIPHER_ALGORITHM_FOR_ENCRYPT = "AES/CBC/PKCS5PADDING";
    private static final int AES_KEY_LENGTH = 32;
    private static final String RANDOM_ALGORITHM = "SHA1PRNG";
    private static final String DIGEST_ALGORITHM = "SHA-256";
    private static final String ELLIPTICAL_CURVES_ALGORITHM = "RSA";
    private static final String ELLIPTICAL_CURVES_ALGORITHM_4_SIGNATURE = "SHA512withRSA";
    public static final String KEYSTORE_TYPE_JKS = "JKS";
    public static final String KEYSTORE_TYPE_PKCS12 = "PKCS12";
    private static final String DECODE_CHARSET = "utf-8";

    private byte[] tarStream(byte[] byArray, byte[] byArray2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        TarOutputStream tarOutputStream = new TarOutputStream((OutputStream)gZIPOutputStream);
        TarEntry tarEntry = new TarEntry("1");
        tarEntry.setGroupId(0);
        tarEntry.setIds(0, 0);
        tarEntry.setModTime(0L);
        tarEntry.setMode(0);
        tarEntry.setUserId(0);
        tarEntry.setUserName("");
        tarEntry.setNames("", "");
        tarEntry.setSize((long)byArray.length);
        tarOutputStream.putNextEntry(tarEntry);
        tarOutputStream.write(byArray);
        tarOutputStream.closeEntry();
        TarEntry tarEntry2 = new TarEntry("2");
        tarEntry2.setGroupId(0);
        tarEntry2.setIds(0, 0);
        tarEntry2.setModTime(0L);
        tarEntry2.setMode(0);
        tarEntry2.setUserId(0);
        tarEntry.setNames("", "");
        tarEntry2.setSize((long)byArray2.length);
        tarOutputStream.putNextEntry(tarEntry2);
        tarOutputStream.write(byArray2);
        tarOutputStream.closeEntry();
        tarOutputStream.close();
        gZIPOutputStream.close();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] tar(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TarOutputStream tarOutputStream = new TarOutputStream((OutputStream)new GZIPOutputStream(byteArrayOutputStream));
        TarEntry tarEntry = new TarEntry("1");
        tarEntry.setGroupId(0);
        tarEntry.setIds(0, 0);
        tarEntry.setModTime(0L);
        tarEntry.setMode(0);
        tarEntry.setUserId(0);
        tarEntry.setUserName("");
        tarEntry.setNames("", "");
        tarEntry.setSize((long)byArray.length);
        tarOutputStream.putNextEntry(tarEntry);
        tarOutputStream.write(byArray);
        tarOutputStream.closeEntry();
        tarOutputStream.close();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private void untar2(byte[] byArray, byte[][] byArray2) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
        TarInputStream tarInputStream = new TarInputStream((InputStream)gZIPInputStream);
        TarEntry tarEntry = tarInputStream.getNextEntry();
        int n = (int)tarEntry.getSize();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        tarInputStream.copyEntryContents((OutputStream)byteArrayOutputStream);
        byArray2[0] = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        TarEntry tarEntry2 = tarInputStream.getNextEntry();
        int n2 = (int)tarEntry2.getSize();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(n2);
        tarInputStream.copyEntryContents((OutputStream)byteArrayOutputStream2);
        byArray2[1] = byteArrayOutputStream2.toByteArray();
        byteArrayOutputStream2.close();
        tarInputStream.close();
    }

    private byte[] untar(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
        TarInputStream tarInputStream = new TarInputStream((InputStream)gZIPInputStream);
        TarEntry tarEntry = tarInputStream.getNextEntry();
        int n = (int)tarEntry.getSize();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        tarInputStream.copyEntryContents((OutputStream)byteArrayOutputStream);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        return byArray2;
    }

    private byte[] getRandom() {
        byte[] byArray = new byte[32];
        try {
            SecureRandom secureRandom = SecureRandom.getInstance(RANDOM_ALGORITHM);
            byte[] byArray2 = secureRandom.generateSeed(32);
            secureRandom.setSeed(byArray2);
            secureRandom.nextBytes(byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    private Key makeKeyOfAES() {
        byte[] byArray = this.getRandom();
        return new SecretKeySpec(byArray, SYMMETRIC_ALGORITHM);
    }

    private byte[] encrypt(byte[] byArray, Key key) {
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM_FOR_ENCRYPT);
            cipher.init(1, key);
            byte[] byArray2 = cipher.getIV();
            byte[] byArray3 = cipher.doFinal(byArray);
            byte[] byArray4 = new byte[byArray2.length + byArray3.length];
            System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
            System.arraycopy(byArray3, 0, byArray4, byArray2.length, byArray3.length);
            return byArray4;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
    }

    protected byte[] decrypt(byte[] byArray, Key key) {
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM_FOR_ENCRYPT);
            int n = cipher.getBlockSize();
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(SYMMETRIC_ALGORITHM);
            byte[] byArray2 = new byte[2 + n];
            byArray2[0] = 4;
            byArray2[1] = (byte)n;
            System.arraycopy(byArray, 0, byArray2, 2, n);
            algorithmParameters.init(byArray2);
            cipher.init(2, key, algorithmParameters);
            return cipher.doFinal(byArray, n, byArray.length - n);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private byte[] keyWrap4EC(Key key, Cipher cipher, Key key2) throws InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException {
        cipher.init(3, key);
        byte[] byArray = cipher.wrap(key2);
        return byArray;
    }

    protected Key keyUnWrap4EC(Key key, String string, Cipher cipher, byte[] byArray) throws InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
        cipher.init(4, key);
        Key key2 = cipher.unwrap(byArray, string, 3);
        byte[] byArray2 = key2.getEncoded();
        while (byArray2.length < 32) {
            byte[] byArray3 = new byte[byArray2.length + 1];
            byArray3[0] = 0;
            System.arraycopy(byArray2, 0, byArray3, 1, byArray2.length);
            byArray2 = byArray3;
        }
        key2 = new SecretKeySpec(byArray2, SYMMETRIC_ALGORITHM);
        return key2;
    }

    private byte[] getSign(byte[] byArray, String string, PrivateKey privateKey) {
        try {
            Signature signature = Signature.getInstance(string);
            signature.initSign(privateKey);
            signature.update(byArray);
            byte[] byArray2 = signature.sign();
            return byArray2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            byte[] byArray3 = null;
            return byArray3;
        }
    }

    protected void verifySign(byte[] byArray, String string, byte[] byArray2, PublicKey publicKey) throws Exception {
        Signature signature = Signature.getInstance(string);
        signature.initVerify(publicKey);
        signature.update(byArray);
        if (!signature.verify(byArray2)) {
            throw new Exception("\u30c7\u30fc\u30bf\u304c\u6539\u7ac4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
    }

    public String base64Enc(byte[] byArray) throws Exception {
        String string = new String(Base64.encodeBase64((byte[])byArray), DECODE_CHARSET);
        string = string.replaceAll("\\/", "\\-");
        string = string.replaceAll("\\+", "_");
        string = string.replaceAll("=", "\\*");
        return string;
    }

    public byte[] base64Dec(String string) throws Exception {
        string = string.replaceAll("\\*", "=");
        string = string.replaceAll("_", "\\+");
        string = string.replaceAll("\\-", "\\/");
        byte[] byArray = Base64.decodeBase64((byte[])string.getBytes(DECODE_CHARSET));
        return byArray;
    }

    private KeyStore getKeyStore(String string, String string2, char[] cArray) throws Exception {
        FileInputStream fileInputStream = null;
        KeyStore keyStore = null;
        try {
            fileInputStream = new FileInputStream(string);
            keyStore = KeyStore.getInstance(string2);
            keyStore.load(fileInputStream, cArray);
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return keyStore;
    }

    private PublicKey getPublicKey(String string, KeyStore keyStore) throws Exception {
        Certificate certificate = keyStore.getCertificate(string);
        if (certificate != null) {
            PublicKey publicKey = certificate.getPublicKey();
            return publicKey;
        }
        return null;
    }

    private PrivateKey getPrivateKey(String string, char[] cArray, KeyStore keyStore) throws Exception {
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(string, cArray);
        return privateKey;
    }

    public String encryption(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) throws Exception {
        if (string10 == null || string10.length() == 0) {
            return "";
        }
        KeyStore keyStore = this.getKeyStore(string, string2, string3.toCharArray());
        PrivateKey privateKey = this.getPrivateKey(string4, string5.toCharArray(), keyStore);
        KeyStore keyStore2 = this.getKeyStore(string6, string7, string8.toCharArray());
        PublicKey publicKey = this.getPublicKey(string9, keyStore2);
        MessageDigest messageDigest = MessageDigest.getInstance(DIGEST_ALGORITHM);
        messageDigest.reset();
        byte[] byArray = messageDigest.digest(string10.getBytes(DECODE_CHARSET));
        byte[] byArray2 = this.getSign(byArray, ELLIPTICAL_CURVES_ALGORITHM_4_SIGNATURE, privateKey);
        String string11 = this.base64Enc(byArray2);
        string10 = string10 + "&signedDigest=" + string11;
        byte[] byArray3 = this.tar(string10.getBytes(DECODE_CHARSET));
        Key key = this.makeKeyOfAES();
        byte[] byArray4 = this.encrypt(byArray3, key);
        Cipher cipher = Cipher.getInstance(ELLIPTICAL_CURVES_ALGORITHM);
        byte[] byArray5 = this.keyWrap4EC(publicKey, cipher, key);
        byte[] byArray6 = this.tarStream(byArray4, byArray5);
        String string12 = this.base64Enc(byArray6);
        return string12;
    }

    public String decryption(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) throws Exception {
        if (string10 == null || string10.length() == 0) {
            return "";
        }
        KeyStore keyStore = this.getKeyStore(string, string2, string3.toCharArray());
        PrivateKey privateKey = this.getPrivateKey(string4, string5.toCharArray(), keyStore);
        KeyStore keyStore2 = this.getKeyStore(string6, string7, string8.toCharArray());
        PublicKey publicKey = this.getPublicKey(string9, keyStore2);
        byte[] byArray = this.base64Dec(string10);
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[][] byArrayArray = new byte[2][];
        this.untar2(byArray, byArrayArray);
        byArray2 = byArrayArray[0];
        byArray3 = byArrayArray[1];
        Cipher cipher = Cipher.getInstance(ELLIPTICAL_CURVES_ALGORITHM);
        Key key = this.keyUnWrap4EC(privateKey, SYMMETRIC_ALGORITHM, cipher, byArray3);
        byte[] byArray4 = this.decrypt(byArray2, key);
        byte[] byArray5 = this.untar(byArray4);
        String string11 = new String(byArray5, DECODE_CHARSET);
        int n = string11.indexOf("&signedDigest=");
        String string12 = string11.substring(0, n);
        MessageDigest messageDigest = MessageDigest.getInstance(DIGEST_ALGORITHM);
        messageDigest.reset();
        byte[] byArray6 = messageDigest.digest(string12.getBytes(DECODE_CHARSET));
        String string13 = string11.substring(n + "&signedDigest=".length(), string11.length());
        this.verifySign(byArray6, ELLIPTICAL_CURVES_ALGORITHM_4_SIGNATURE, this.base64Dec(string13), publicKey);
        return string12;
    }
}

