/*
 * Decompiled with CFR 0.152.
 */
package jp.veritrans.tercerog.mdk;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.KeyManagerFactory;
import jp.veritrans.tercerog.mdk.ITransaction;
import jp.veritrans.tercerog.mdk.MerchantConfig;
import jp.veritrans.tercerog.mdk.connection.SettlementDemandServlet;
import jp.veritrans.tercerog.mdk.connection.ssl.SSLConfigurator;
import jp.veritrans.tercerog.mdk.context.MerchantContext;
import jp.veritrans.tercerog.mdk.dto.IBaseDto;
import jp.veritrans.tercerog.mdk.exception.MdkLocalException;
import jp.veritrans.tercerog.mdk.gw.utils.HashUtils;
import jp.veritrans.tercerog.mdk.util.MdkUtil;
import jp.veritrans.tercerog.mdk.util.ReflectUtil;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transaction
implements ITransaction {
    public static final Pattern OPTION_PATTERN = Pattern.compile("[\\s|\\t|\\r|\\n]*<optionResults>.*</optionResults>[\\s|\\t|\\r|\\n]*", 32);
    public static final Pattern PATTERN_HTTP_RETURN = Pattern.compile("^[^\\s]*\\s(\\d{3})\\s");
    public static final int HTTP_RETURN_NORMAL = 200;
    public static final int AUTHENTICATION_REQUIRED = 407;
    public static final int INTERNAL_SERVER_ERROR = 500;
    public static final int BAD_GATEWAY = 502;
    public static final int SERVICE_UNAVAILABLE = 503;
    public static final String VRESULT_RIGHT0 = "000000000000";
    public static final String GMT = "GMT";
    public static final String SET_MASKED_LOG = "_setMaskedLog";
    public static final String SET_RESULT_XML = "_setResultXml";
    public static final String QUESTION = "?";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private MerchantContext context;
    private String responseHeader = null;
    private String response = null;
    public static final String SLASH = "/";
    public static final String METHOD_NAME_GET_SERVICE_TYPE = "getServiceType";
    public static final String METHOD_NAME_GET_SERVICE_COMMAND = "getServiceCommand";
    public static final String METHOD_NAME_GET_SERVICE_OPTION_TYPE = "getServiceOptionType";
    public static final String HYPHEN = "-";
    public static final String SERVICE_COMMAND_SEARCH = "Search";
    public static final String SEARCH_SERVER = "search";
    public static final String DUMMY_SERVER = "test";

    private Transaction() {
    }

    public Transaction(MerchantContext merchantContext) {
        this();
        this.context = merchantContext;
    }

    @Override
    public Object execute() {
        Object object = null;
        IBaseDto iBaseDto = this.context.getBaseDto();
        try {
            String string;
            Object object2;
            JSONObject jSONObject;
            MerchantConfig merchantConfig = this.context.getMerchantConfig();
            String string2 = merchantConfig.getProperty("MDK_VERSION");
            String string3 = merchantConfig.getProperty("MDK_DTO_VERSION");
            this.logger.debug("========== Transaction#execute() start [" + string2 + SLASH + string3 + "] ==========");
            try {
                jSONObject = Class.forName(this.context.getResponseDtoName());
                object = jSONObject.newInstance();
            }
            catch (Exception exception) {
                this.logger.error("!!!!!!!!!! Unable to create response dto(" + this.context.getResponseDtoName() + "). Abnormal dto, check jar file !!!!!!!!!!");
                throw new MdkLocalException("Response dto creation failed. " + this.getOriginalMessage(exception), "MF99", exception);
            }
            merchantConfig.checkMerchantConfig();
            jSONObject = this.createJsonObject(iBaseDto);
            StringBuffer stringBuffer = new StringBuffer(jSONObject.toString());
            String string4 = MdkUtil.maskJson(stringBuffer.toString());
            try {
                object2 = iBaseDto.getClass().getMethod(SET_MASKED_LOG, String.class);
                ((Method)object2).invoke((Object)iBaseDto, string4);
            }
            catch (Exception exception) {
                this.logger.error("!!!!!!!!!! Unable to set log message to request dto. Abnormal dto, check jar file !!!!!!!!!!");
                throw new MdkLocalException("Respose dto does not have method. " + this.getOriginalMessage(exception), "MA99", exception);
            }
            if (stringBuffer.toString().equals("{}")) {
                stringBuffer.insert(stringBuffer.length() - 1, this.editJsonFormat("txnVersion", this.context.getMerchantConfig().getProperty("MDK_VERSION")));
            } else {
                stringBuffer.insert(stringBuffer.length() - 1, "," + this.editJsonFormat("txnVersion", this.context.getMerchantConfig().getProperty("MDK_VERSION")));
            }
            stringBuffer.insert(stringBuffer.length() - 1, "," + this.editJsonFormat("dummyRequest", this.context.getMerchantConfig().getProperty("DUMMY_REQUEST")));
            stringBuffer.insert(stringBuffer.length() - 1, "," + this.editJsonFormat("merchantCcid", this.context.getMerchantConfig().getProperty("MERCHANT_CCID")));
            string4 = MdkUtil.maskJson(stringBuffer.toString());
            object2 = null;
            try {
                object2 = this.createSendUrl(iBaseDto);
                merchantConfig.checkServerUrl((String)object2);
            }
            catch (Exception exception) {
                this.logger.error("!!!!!!!!!! Unable to create url !!!!!!!!!!");
                throw new MdkLocalException("send url does not create. " + this.getOriginalMessage(exception), "MA99", exception);
            }
            this.logger.info("=========== connect url   ==> " + (String)object2);
            this.logger.info("=========== user agent    ==> " + merchantConfig.getUserAgent());
            this.logger.info("=========== request data  ==> " + string4.toString());
            this.context.setOriginalJsonStr(stringBuffer.toString());
            try {
                stringBuffer = new StringBuffer(new String(stringBuffer.toString().getBytes("UTF-8"), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.logger.error("!!!!!!!!!! UTF-8 is not supported in your server. !!!!!!!!!!");
                throw new MdkLocalException("Encode error" + this.getOriginalMessage(unsupportedEncodingException), "MB99", unsupportedEncodingException);
            }
            try {
                string = HashUtils.getInstance().getDigest(new String[]{merchantConfig.getProperty("MERCHANT_CCID"), stringBuffer.toString(), merchantConfig.getProperty("MERCHANT_SECRET_KEY")});
                stringBuffer.append("," + this.editJsonFormat("authHash", string));
            }
            catch (Exception exception) {
                this.logger.error("!!!!!!!!!! Unable to calculate message digest. !!!!!!!!!!");
                throw new MdkLocalException("Error has occurred while calculating message digest. " + this.getOriginalMessage(exception), "MA04", exception);
            }
            stringBuffer.insert(0, "{\"params\":");
            stringBuffer.append("}");
            string = URLEncoder.encode(stringBuffer.toString(), "UTF-8");
            this.context.setJsonStr(string);
            this.send((String)object2);
            this.setResponseDto(object, this.response);
            this.setResponseJson(object);
        }
        catch (Exception exception) {
            object = this.errorProcess(iBaseDto, object, exception);
        }
        this.logger.debug("========== Transaction#execute() end ==========");
        return object;
    }

    private JSONObject createJsonObject(Object object) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException {
        JSONObject jSONObject = new JSONObject();
        this.createJsonObject(object, jSONObject);
        return jSONObject;
    }

    private void createJsonObject(Object object, JSONObject jSONObject) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException {
        List list = ReflectUtil.getDeclaredMethodsList(object, "^get[A-Z].*$");
        for (int i = 0; i < list.size(); ++i) {
            Object[] objectArray;
            Object object2;
            String string;
            Method method = (Method)list.get(i);
            if (!ReflectUtil.isCorrectGetter(method) || (string = method.getName()).equals(METHOD_NAME_GET_SERVICE_TYPE) || string.equals(METHOD_NAME_GET_SERVICE_COMMAND)) continue;
            String string2 = MdkUtil.toLowerFieldName(method.getName().substring("get".length()));
            Class<?> clazz = method.getReturnType();
            if (clazz.isArray()) {
                object2 = new JSONArray();
                if (clazz == String[].class) {
                    objectArray = (String[])ReflectUtil.executeGetter(method, object);
                    if (objectArray == null) continue;
                    object2.addAll(Arrays.asList(objectArray));
                    jSONObject.put((Object)string2, object2);
                    continue;
                }
                objectArray = (Object[])ReflectUtil.executeGetter(method, object);
                if (objectArray == null) continue;
                for (int j = 0; j < objectArray.length; ++j) {
                    JSONObject jSONObject2 = new JSONObject();
                    this.createJsonObject(objectArray[j], jSONObject2);
                    object2.add((Object)jSONObject2);
                }
                jSONObject.put((Object)string2, object2);
                continue;
            }
            if (clazz == String.class) {
                object2 = (String)ReflectUtil.executeGetter(method, object);
                if (object2 == null) continue;
                jSONObject.put((Object)string2, object2);
                continue;
            }
            object2 = ReflectUtil.executeGetter(method, object);
            if (object2 == null) continue;
            objectArray = new JSONObject();
            this.createJsonObject(object2, (JSONObject)objectArray);
            jSONObject.put((Object)string2, (Object)objectArray);
        }
    }

    private void setResponseDto(Object object, String string) throws Exception {
        string = this.removeResultMark(string);
        JSONObject jSONObject = (JSONObject)new JSONParser().parse(string);
        this.setResponseDto(object, jSONObject);
    }

    private void setResponseDto(Object object, JSONObject jSONObject) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException, InstantiationException {
        List list = ReflectUtil.getMethodsList(object, "^set[A-Z].*$");
        for (int i = 0; i < list.size(); ++i) {
            Object object2;
            Object object3;
            String string;
            Method method = (Method)list.get(i);
            if (!ReflectUtil.isCorrectSetter(method) || !jSONObject.containsKey((Object)(string = MdkUtil.toLowerFieldName(method.getName().substring("set".length())))) || (object3 = jSONObject.get((Object)string)) == null) continue;
            Class<?> clazz = method.getParameterTypes()[0];
            if (clazz.isArray()) {
                int n;
                Object object4;
                if (clazz == String[].class) {
                    object2 = (JSONArray)object3;
                    object4 = Array.newInstance(String.class, object2.size());
                    ReflectUtil.executeSetter(method, object, object4);
                    for (n = 0; n < object2.size(); ++n) {
                        Array.set(object4, n, String.valueOf(object2.get(n)));
                    }
                    continue;
                }
                object2 = (JSONArray)object3;
                object4 = Array.newInstance(clazz.getComponentType(), object2.size());
                ReflectUtil.executeSetter(method, object, object4);
                for (n = 0; n < object2.size(); ++n) {
                    Object obj = clazz.getComponentType().newInstance();
                    Array.set(object4, n, obj);
                    this.setResponseDto(obj, (JSONObject)object2.get(n));
                }
                continue;
            }
            if (clazz == String.class) {
                ReflectUtil.executeSetter(method, object, String.valueOf(object3));
                continue;
            }
            object2 = clazz.newInstance();
            ReflectUtil.executeSetter(method, object, object2);
            this.setResponseDto(object2, (JSONObject)object3);
        }
    }

    private String removeResultMark(String string) throws Exception {
        String string2 = string;
        int n = string2.indexOf("\"result\":");
        int n2 = string2.length();
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = n; i < n2; ++i) {
            char c = string2.charAt(i);
            if (bl) {
                bl = false;
                continue;
            }
            if (c == '\\') {
                bl = true;
                continue;
            }
            if (c == '\"') {
                bl2 = !bl2;
                continue;
            }
            if (bl2) continue;
            if (c == '{') {
                ++n3;
                continue;
            }
            if (c != '}' || --n3 != 0) continue;
            string2 = string2.substring(0, i) + string2.substring(i + 1);
            string2 = string2.substring(0, n) + string2.substring(n + "\"result\":{".length());
            return string2;
        }
        throw new Exception();
    }

    private String createSendUrl(Object object) throws Exception {
        MerchantConfig merchantConfig = this.context.getMerchantConfig();
        String string = merchantConfig.getProperty("SERVER_URL");
        Method method = object.getClass().getMethod(METHOD_NAME_GET_SERVICE_TYPE, null);
        String string2 = (String)method.invoke(object, null);
        Method method2 = object.getClass().getMethod(METHOD_NAME_GET_SERVICE_COMMAND, null);
        String string3 = (String)method2.invoke(object, null);
        String string4 = this.context.getMerchantConfig().getProperty("ADD_URL_PAYMENT");
        String string5 = this.context.getMerchantConfig().getProperty("ADD_URL_PAYMENT_VERSION");
        String string6 = this.context.getMerchantConfig().getProperty("PAYNOWID_SERVICE_TYPE");
        HashSet<String> hashSet = new HashSet<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string6, ",");
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(stringTokenizer.nextToken());
        }
        if (hashSet.contains(string2)) {
            string4 = this.context.getMerchantConfig().getProperty("ADD_URL_VTID");
            string5 = this.context.getMerchantConfig().getProperty("ADD_URL_VTID_VERSION");
            String string7 = this.context.getMerchantConfig().getProperty("PAYNOWID_API_CONTEXT");
            if (string7 != null && !string7.isEmpty()) {
                string4 = string7;
            }
        }
        if (string4.equals(merchantConfig.getProperty("ADD_URL_PAYMENT")) && string3.equals(SERVICE_COMMAND_SEARCH)) {
            string4 = string4 + HYPHEN + SEARCH_SERVER;
        }
        if ("1".equals(merchantConfig.getProperty("DUMMY_REQUEST"))) {
            string4 = "test-" + string4;
        }
        return string.concat(SLASH + string4 + SLASH + string5 + SLASH + string3 + SLASH + string2);
    }

    private String editJsonFormat(String string, String string2) {
        return "\"" + string + "\":\"" + string2 + "\"";
    }

    private void send(String string) throws MdkLocalException {
        block5: {
            MerchantConfig merchantConfig = this.context.getMerchantConfig();
            SSLConfigurator sSLConfigurator = this.createSSLConfigurator();
            String string2 = null;
            try {
                URL uRL = new URL(string);
                SettlementDemandServlet settlementDemandServlet = new SettlementDemandServlet(sSLConfigurator, merchantConfig.getUserAgent());
                settlementDemandServlet.execute(2, uRL, this.context.getJsonStr());
                string2 = settlementDemandServlet.getResultHeader();
                this.responseHeader = string2 != null ? string2 : "";
                string2 = settlementDemandServlet.getResultBody();
                this.response = string2 != null ? string2 : "";
                Matcher matcher = PATTERN_HTTP_RETURN.matcher(this.responseHeader);
                if (matcher.find()) {
                    String string3 = matcher.group(1);
                    int n = Integer.parseInt(string3);
                    if (n != 200) {
                        String string4 = Transaction.httpError(n);
                        this.logger.error("!!!!!!!!!! Http response : Http response header       ==> " + this.responseHeader + " !!!!!!!!!!");
                        this.logger.error("!!!!!!!!!! Http response : Http response message      ==> " + this.response + " !!!!!!!!!!");
                        throw new MdkLocalException("Http response error. Value " + n + ". ", string4);
                    }
                    break block5;
                }
                this.logger.error("!!!!!!!!!! Http response format error, no httpReturn . Http response header ==> " + this.responseHeader + " !!!!!!!!!!");
                throw new MdkLocalException("Http response format error", "MF99");
            }
            catch (MdkLocalException mdkLocalException) {
                throw mdkLocalException;
            }
            catch (Exception exception) {
                throw this.getSendException(exception);
            }
        }
    }

    private SSLConfigurator createSSLConfigurator() {
        MerchantConfig merchantConfig = this.context.getMerchantConfig();
        SSLConfigurator sSLConfigurator = new SSLConfigurator();
        sSLConfigurator.setProtocol(merchantConfig.getProperty("SSL_PROTOCOL"));
        sSLConfigurator.setConnectionTimeoutSec(merchantConfig.getConnectionTimeout());
        sSLConfigurator.setReadTimeoutSec(merchantConfig.getReadTimeout());
        sSLConfigurator.setKeystoreType(merchantConfig.getProperty("SSL_KEYSTORE_TYPE"));
        sSLConfigurator.setKeystoreAlgorithm(KeyManagerFactory.getDefaultAlgorithm());
        sSLConfigurator.setTruststorePath(merchantConfig.getProperty("SSL_TRUSTSTORE_FILE"));
        sSLConfigurator.setTruststorePass(merchantConfig.getProperty("SSL_TRUSTSTORE_PASSWORD"));
        sSLConfigurator.setTruststoreType(merchantConfig.getProperty("SSL_TRUSTSTORE_TYPE"));
        sSLConfigurator.setTruststoreAlgorithm(KeyManagerFactory.getDefaultAlgorithm());
        return sSLConfigurator;
    }

    public static String httpError(int n) {
        String string = null;
        switch (n) {
            case 500: {
                string = "MF05";
                break;
            }
            case 502: {
                string = "MF06";
                break;
            }
            case 503: {
                string = "MF07";
                break;
            }
            default: {
                string = "MF99";
            }
        }
        return string;
    }

    private MdkLocalException getSendException(Exception exception) {
        Throwable throwable = exception;
        String string = null;
        String string2 = null;
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        this.logger.debug("========== Instance of exception is " + throwable.getClass().getName() + " ==========");
        if (throwable instanceof InterruptedIOException) {
            string = "Socket timeout. ";
            string2 = "MF03";
        } else if (throwable instanceof SocketException) {
            string = "Connect was not established. ";
            string2 = "MF02";
        } else if (throwable instanceof IOException) {
            string = "Key error or socket write/read error. ";
            string2 = "MF04";
        } else if (this.isSocketFactoryError(throwable)) {
            string = "SSLSocketFactory creation error has occurred. ";
            string2 = "MB03";
        } else if (throwable.getClass().getName().equals("javax.xml.ws.soap.SOAPFaultException")) {
            string = "Error occurred while encryption. " + this.getOriginalMessage(exception);
            string2 = "MA04";
        } else {
            string = "Error has occurred while sending or receiving message. ";
            string2 = "MF99";
        }
        return new MdkLocalException(string + this.getOriginalMessage(exception), string2, exception);
    }

    private boolean isSocketFactoryError(Throwable throwable) {
        return throwable instanceof KeyStoreException || throwable instanceof NoSuchAlgorithmException || throwable instanceof CertificateException || throwable instanceof FileNotFoundException || throwable instanceof KeyManagementException || throwable instanceof UnrecoverableKeyException;
    }

    private void setResponseJson(Object object) throws MdkLocalException {
        String string = null;
        try {
            string = MdkUtil.maskJson(this.response);
            Method method = object.getClass().getMethod(SET_RESULT_XML, String.class);
            method.invoke(object, string);
        }
        catch (Exception exception) {
            this.logger.error("!!!!!!!!!! Unable to set result json to dto, wrong dto jar file. ");
            throw new MdkLocalException("Bad responseDto. " + this.getOriginalMessage(exception), "MA99", exception);
        }
        this.logger.info("=========== response data ==> " + MdkUtil.deleteRN(string));
    }

    private Object errorProcess(Object object, Object object2, Exception exception) {
        Object object3 = null;
        if (object.toString() != null) {
            this.logger.error("!!!!!!!!!! Error request data is                      ==> " + object.toString() + " !!!!!!!!!!");
        }
        if (object2 != null && object2.toString() != null) {
            this.logger.error("!!!!!!!!!! Error response data is                     ==> " + object2.toString() + " !!!!!!!!!!");
        }
        this.logger.error("!!!!!!!!!! Stack Trace is below !!!!!!!!!!", (Throwable)exception);
        try {
            if (object2 != null) {
                this.setErrorDto(object2, exception);
            }
            object3 = object2;
        }
        catch (MdkLocalException mdkLocalException) {
            this.logger.error("!!!!!!!!!! Stack Trace is below !!!!!!!!!!", (Throwable)mdkLocalException);
            object3 = null;
        }
        return object3;
    }

    public void setErrorDto(Object object, Exception exception) throws MdkLocalException {
        Class<?> clazz = object.getClass();
        String string = "failure";
        String string2 = null;
        String string3 = null;
        if (exception instanceof MdkLocalException) {
            string2 = ((MdkLocalException)exception).getErrorCode() + VRESULT_RIGHT0;
            string3 = ((MdkLocalException)exception).getMerrMsg();
        } else {
            string2 = "MA99000000000000";
            string3 = MdkLocalException.convertErrorCode("MA99");
        }
        Class[] classArray = new Class[]{String.class};
        try {
            Method method = clazz.getMethod("setVResultCode", classArray);
            method.invoke(object, string2);
            method = clazz.getMethod("setMerrMsg", classArray);
            method.invoke(object, string3);
            method = clazz.getMethod("setMstatus", classArray);
            method.invoke(object, string);
        }
        catch (Exception exception2) {
            this.logger.error("!!!!!!!!!! fail to set error information to response dto. !!!!!!!!!!");
            throw new MdkLocalException("Response dto is broken. " + this.getOriginalMessage(exception2), "MB99", exception2);
        }
    }

    private String getOriginalMessage(Exception exception) {
        return exception.getMessage() != null ? exception.getMessage() : "";
    }
}

