package jp.ill.photon.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipUtil {

	/**
	 * zipファイルを解凍します。<br>
	 * 
	 * @param zipFile 解凍するZIPファイル
	 * @param outputDir 解凍先ディレクトリ
	 * @param charset 文字コード(ファイル名またはディレクトリ名に使用される文字コード)
	 * @return 出力ディレクトリ直下に解凍されたファイルリスト
	 */
	public static List<File> unZip(File zipFile, File outputDir, String charset)
			throws Exception {

		// 出力ディレクトリ直下に解凍されたファイルまたディレクトリのセット
		List<File> fileList = new ArrayList<File>();

		ZipFile zip = null;
		try {
			// 文字コードを指定することで文字化けを回避
			zip = new ZipFile(zipFile, Charset.forName(charset));

			// 格納先ディレクトリを作成
			outputDir.mkdirs();

			Enumeration<?> zipEnum = zip.entries();
			while (zipEnum.hasMoreElements()) {
				// 解凍するアイテムを取得
				ZipEntry entry = (ZipEntry) zipEnum.nextElement();

				if (!entry.isDirectory()) {
					// 解凍対象がファイルの場合
					File file = new File(outputDir, entry.getName());
					fileList.add(file);

					// 解凍対象のファイルを書き出し
					FileOutputStream fos = null;
					InputStream is = null;

					fos = new FileOutputStream(file, false);
					is = zip.getInputStream(entry);

					byte[] buf = new byte[1024];
					int size = 0;
					while ((size = is.read(buf)) != -1) {
						fos.write(buf, 0, size);
					}
					fos.flush();
					/* アラジンECtoB 初期バージョンリリース #2717 ADD START */
					fos.close();
					/* アラジンECtoB 初期バージョンリリース #2717 ADD END */

				}
			}

			return fileList;
		} catch (Exception e) {
			throw e;
		} finally {
			if (zip != null) {
				try {
					zip.close();
				} catch (IOException e) {
					throw e;
				}
			}
		}

	}

	/**
	 * zipファイルを解凍します.<br />
	 * outputBasePathの値にタイムスタンプを付けたフォルダに格納する
	 * 
	 * @param zipFile 解凍するZIPファイル
	 * @param outputFile 解凍先ディレクトリ
	 * @return 出力ディレクトリ直下に解凍されたファイルリスト
	 * @throws IOException
	 */
	public static List<File> unZip(File zipFile, File outputFile)
			throws Exception {
		return unZip(zipFile, outputFile, "Windows-31J");
	}
}
