package jp.ill.photon.util;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class UtilTools {

	/**
	 * strが空かどうかをチェック
	 *
	 * @param str
	 * @return true：nullもしくは空の場合　　false：nullもしくは空以外の場合
	 */
	public static boolean isEmpty(String str) {
		if (str != null && !str.isEmpty()) {
			return false;
		}

		return true;
	}

	/**
	 * BigDecimalの掛け算.
	 *
	 * @param kazu
	 * @param kazu2
	 * @return String 演算後の文字列
	 */
	public static String multiplyBigDecimal(String kazu, String kazu2) {
		return multiplyBigDecimal(kazu, kazu2, false);
	}

	public static String multiplyBigDecimal(String kazu, String kazu2, boolean isRound) {
		try {
			// kazu1
			BigDecimal kazuB = new BigDecimal(kazu);

			// kazu2
			BigDecimal kazuB2 = new BigDecimal(kazu2);

			// 返却値
			BigDecimal total = new BigDecimal(0);

			total = kazuB.multiply(kazuB2);

			if (isRound) {
				return total.setScale(0, RoundingMode.DOWN).toString();
			} else {
				// 2017/05/15 ootah ここでは丸めない
				return total.toString();
			}
		} catch (Exception e) {
			return "0";
		}
	}

	/**
	 * BigDecimalの加算.
	 *
	 * @param kazu
	 * @param kazu2
	 * @return String 演算後の文字列
	 */
	public static String addBigDecimal(String kazu, String kazu2) {

		// Aladdin-EC ファッション版開発 20141107 MOD-S
		return addBigDecimal(kazu, kazu2, false);
		// try {
		// // kazu1
		// BigDecimal kazuB = new BigDecimal(kazu);
		//
		// // kazu2
		// BigDecimal kazuB2 = new BigDecimal(kazu2);
		//
		// // 返却値
		// BigDecimal total = new BigDecimal(0);
		//
		// total = kazuB.add(kazuB2);
		//
		// return total.setScale(0, RoundingMode.DOWN).toString();
		// } catch (Exception e) {
		// return "0";
		// }
		// Aladdin-EC ファッション版開発 20141107 MOD-E

	}

	/**
	 * BigDecimalの加算. (桁数対応版)
	 *
	 * @param kazu
	 * @param kazu2
	 * @param preserveDigit 小数点桁数を残す場合はtrue, 残さない (整数化する) 場合はfalse
	 * @return String 演算後の文字列
	 */
	public static String addBigDecimal(	String kazu,
										String kazu2,
										boolean preserveDigit) {

		try {
			// kazu1
			BigDecimal kazuB = new BigDecimal(kazu.replace(",", ""));

			// kazu2
			BigDecimal kazuB2 = new BigDecimal(kazu2.replace(",", ""));

			// 返却値
			BigDecimal total = new BigDecimal(0);

			total = kazuB.add(kazuB2);

			if (preserveDigit) {
				return total.setScale(10, RoundingMode.DOWN).toString();
			} else {
				return total.setScale(0, RoundingMode.DOWN).toString();
			}
		} catch (Exception e) {
			return "0";
		}
	}

	/**
	 * Doubleの加算.
	 *
	 * @param kazu
	 * @param kazu2
	 * @return String 演算後の文字列
	 */
	public static String addDouble(String kazu, String kazu2) {

		try {
			// kazu1
			Double kazud = Double.parseDouble(kazu) + Double.parseDouble(kazu2);

			return kazud.toString();
		} catch (Exception e) {
			return "0";
		}
	}

}
