package jp.ill.photon.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;

import org.apache.commons.lang3.StringUtils;

public class StringFormatUtil {

	public static final String NUM_FORMAT = "###,###,###,###,###.#########";
	public static final String NUMNC_FORMAT = "###############.#########";
	public static final String YEN = "&yen;	";

	public static String formatByType(String typeName, String value) {
		if (typeName == null || typeName.isEmpty()) {
			return value;
		}

		String result = value;
		if (typeName.equals("num")) {
			result = num(value);
		} else if (typeName.equals("numnc")) {
			result = numnc(value);
		} else if (typeName.equals("money")) {
			result = money(value);
		}

		return result;
	}

	/**
	 *
	 * フォーマット（カンマ付）
	 *
	 * @param value
	 * @return フォーマットされた値
	 */
	public static String num(String value) {
		try {
			BigDecimal val = BigDecimal.ZERO;
			if (!StringUtils.isEmpty(value)) {
				val = new BigDecimal(value);
			}
			DecimalFormat df = new DecimalFormat(NUM_FORMAT);
			return df.format(val);
		} catch (NumberFormatException e) {
			return value;
		}
	}

	/**
	 *
	 * フォーマット（カンマ無）
	 *
	 * @param value
	 * @return フォーマットされた値
	 */
	public static String numnc(String value) {
		try {
			BigDecimal val = BigDecimal.ZERO;
			if (!StringUtils.isEmpty(value)) {
				val = new BigDecimal(value);
			}
			DecimalFormat df = new DecimalFormat(NUMNC_FORMAT);
			return df.format(val);
		} catch (NumberFormatException e) {
			return value;
		}
	}

	/**
	 *
	 * フォーマット（カンマ付）
	 *
	 * @param value
	 * @return フォーマットされた値
	 */
	public static String money(String value) {
		try {
			return YEN + num(value);
		} catch (NumberFormatException e) {
			return value;
		}
	}

}
