package jp.ill.photon.util;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class ParamBuilder {

	/**
	 * 引数をMapに変換して返す
	 * 
	 * @param name
	 * @param type
	 * @param val
	 * @return
	 */
	public static Map<String, Object> toP(	String name,
											String type,
											Object val) {
		Map<String, Object> param = new HashMap<>();
		param.put("name", name);
		param.put("type", type);
		param.put("val", val);
		return param;
	}

	public static Map<String, Object> toP(	String name,
											String type,
											String dataType,
											Object val) {
		Map<String, Object> param = new HashMap<>();
		param.put("name", name);
		param.put("type", type);
		param.put("data_type", dataType);
		param.put("val", val);
		return param;
	}

	/**
	 * 引数のMapリストをPhotonモジュール用パラメータ形式に変換して返す
	 * 
	 * @param srcParams
	 * @return
	 */
	@SafeVarargs
	public static Map<String, Object> createJsonTypeParams(Map<String, Object>... srcParams) {
		Map<String, Object> params = new LinkedHashMap<>();
		Map<String, Object> p = null;
		for (Map<String, Object> param : srcParams) {
			p = new HashMap<>();
			p.put("type", param.get("type"));
			p.put("val", param.get("val"));
			if (param.containsKey("data_type")) {
				p.put("data_type", param.get("data_type"));
			}
			params.put(String.valueOf(param.get("name")), p);
		}

		return params;
	}
}
