package jp.ill.photon.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import org.apache.commons.lang.StringUtils;

import jp.ill.photon.dao.builder.DomaSQLQueryBuilder;
import jp.ill.photon.dto.ActionDto;

public class OutputParamUtil {
	/** タイプ */
	public static String TYPE_CHECKBOX = "checkbox";
	public static String TYPE_RADIO = "radio";
	public static String TYPE_BUTTON = "button";
	public static String TYPE_FILE = "file";

	/**
	* col_listを基にcol_mapを作成
	*
	* @param src
	* @return
	*/
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public static List<Map<String, Object>> makeColList(Map<String, Object> columnList, ActionDto dto) {

		List<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
		if (columnList == null) {
			return null;
		}

		// disp_mapのみ、typeとvalから取得したマップに置き換える
		List<Map<String, Object>> list = (List<Map<String, Object>>) columnList.get("list");
		if (list != null) {
			for (Map<String, Object> map : list) {

				Map<String, Object> newMap = new HashMap<String, Object>();

				for (Map.Entry<String, Object> e : map.entrySet()) {
					if ("disp_map".equals(e.getKey())) {
						if (e.getValue() != null) {

							Map dispMapInfo = (Map) e.getValue();
							String type = (String) dispMapInfo.get("type");
							Object val = dispMapInfo.get("val");

							if (e.getValue() instanceof Map) {
								Map<String, Object> valMap = (Map<String, Object>) ParamUtil.getParamValueByType(
										type,
										val,
										dto);
								newMap.put(e.getKey(), valMap);

							} else {
								List<Map<String, Object>> valList = (List<Map<String, Object>>) ParamUtil.getParamValueByType(
										type,
										val,
										dto);

								if (valList != null) {
									Map<String, Object> valMap = new HashMap<String, Object>();
									for (Map<String, Object> mp : valList) {
										valMap.put((String) mp.get("list_value"), (String) mp.get("list_caption"));
									}
									newMap.put(e.getKey(), valMap);

								}
							}
						}
					} else {
						newMap.put(e.getKey(), e.getValue());

					}
				}
				ret.add(newMap);

			}
		}

		return ret;

	}

	/**
	* データの各明細にリンク生成用情報を追加する
	*
	* @param rowList
	* @param linkInfo
	* @return
	*/
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public static List<Map<String, Object>> addLinkInfoToRowList(
																	List<Map<String, Object>> rowList,
																	Map<String, Object> linkInfo,
																	ActionDto dto) {

		Map<String, Object> linkTypeInfo = null;
		Map<String, Object> paramMap = null;
		Map<String, Object> linkQueryMap = null;
		Map<String, Object> funcMap = null;

		List<Map<String, Object>> convertedList = new ArrayList<Map<String, Object>>();
		if (rowList != null) {
			for (Map<String, Object> row : rowList) {

				linkQueryMap = new HashMap<String, Object>();
				funcMap = new HashMap<String, Object>();

				for (Map.Entry<String, Object> entry : linkInfo.entrySet()) {

					linkTypeInfo = (Map) entry.getValue();
					String type = (String) linkTypeInfo.get("type");

					if ("edit".equals(type)) {
						paramMap = (Map) ((Map) linkTypeInfo.get("val")).get("params");
						linkQueryMap.put(
								entry.getKey(),
								createLinkQuery(row, paramMap, dto));

					} else if ("func".equals(type)) {
						Map fncInfo = (Map) linkTypeInfo.get("func_info");
						funcMap.put(
								entry.getKey(),
								createFuncStr(row, fncInfo, dto));

					}
				}
				row.put("link_query", linkQueryMap);
				row.put("func", funcMap);
				convertedList.add(row);
			}
		}

		return convertedList;
	}

	/**
	* URL用のパラメータクエリを生成する
	*
	* @param row
	* @param paramMap
	* @return
	*/
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public static String createLinkQuery(
										Map<String, Object> row,
											Map<String, Object> paramMap,
											ActionDto dto) {

		StringBuffer paramQuery = new StringBuffer();
		for (Map.Entry<String, Object> param : paramMap.entrySet()) {

			if (paramQuery.length() > 0) {
				paramQuery.append("&");
			}

			paramQuery.append(param.getKey());
			paramQuery.append("=");

			Map<String, Object> map = (Map) param.getValue();
			String type = (String) map.get("type");
			String val = (String) map.get("val");

			if ("row".equals(type)) {
				if (row.containsKey(param.getKey())) {
					paramQuery.append(row.get(val));
				}

			} else {
				Object value = ParamUtil.getParamValueByType(
						type,
						val,
						dto);
				paramQuery.append((String) value);

			}
		}

		return paramQuery.toString();
	}

	/**
	* ファンクション文字列を作成する
	*
	* @param row
	* @param fncInfo
	* @return
	*/
	@SuppressWarnings("unchecked")
	public static String createFuncStr(
									Map<String, Object> row,
									Map<String, Object> fncInfo,
									ActionDto dto) {

		StringBuffer fncStr = new StringBuffer();

		String fncName = (String) fncInfo.get("name");
		fncStr.append(fncName);
		fncStr.append("(");

		List<Map<String, Object>> params = (List<Map<String, Object>>) fncInfo.get("params");

		if (params != null) {

			int cnt = 0;

			for (Map<String, Object> param : params) {

				String type = (String) param.get("type");
				String val = (String) param.get("val");

				if (cnt > 0) {
					fncStr.append(",");
				}

				if ("row".equals(type)) {
					if (row.containsKey(val)) {
						fncStr.append("'" + row.get(val) + "'");
						cnt++;
					}

				} else {
					Object value = ParamUtil.getParamValueByType(
							type,
							val,
							dto);
					fncStr.append("'" + (String) value + "'");
					cnt++;
				}
			}
		}

		fncStr.append(")");

		return fncStr.toString();

	}

	/**
	* データの各明細にオブジェクト生成用情報を追加する
	*
	* @param rowList
	* @param objectInfo
	* @return
	*/
	@SuppressWarnings({})
	public static List<Map<String, Object>> addObjectInfoToRowList(
																List<Map<String, Object>> rowList,
																Map<String, Object> objectInfo,
																ActionDto dto) {

		List<Map<String, Object>> convertedList = new ArrayList<Map<String, Object>>();
		if (rowList != null) {

			for (Map<String, Object> row : rowList) {

				// 入力項目セット
				Map<String, Object> forms_input = new LinkedHashMap<String, Object>();
				setInputParametersFromStaticJson(objectInfo, forms_input, row, dto);

				row.put("object_info", forms_input);
				convertedList.add(row);

			}

		}
		return convertedList;
	}

	/**
	 * 入力項目のstatic_jsonプロパティからフォーム情報をセットする
	 *
	 * @param src static_json
	 * @param dst フォーム情報をセットする先
	 *
	 * */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public static void setInputParametersFromStaticJson(
													Map<String, Object> src,
													Map<String, Object> dst,
													Map<String, Object> row,
													ActionDto dto) {

		if (src != null) {

			Map<String, Object> paramValuesInfo = null;
			Map<String, Object> paramInputsInfo = null;

			for (Map.Entry<String, Object> param : src.entrySet()) {

				String key = param.getKey();

				Map mp = (Map) param.getValue();
				paramValuesInfo = (Map<String, Object>) mp.get("params");
				paramInputsInfo = (Map<String, Object>) mp.get("inputs");
				Map<String, Object> actionIdInfo = (Map<String, Object>) mp.get("action_id");

				Map<String, Object> valMap = new HashMap<String, Object>();

				if (actionIdInfo != null && !actionIdInfo.isEmpty()) {
					valMap.put("action_id", ParamUtil.getParamStrValueByType(actionIdInfo, dto));
				}

				// params属性が存在するときには
				// 配下のパラメータを全て結合し、data-link属性にセットする
				// data-json属性にもセットすること
				if (paramValuesInfo != null && !paramValuesInfo.isEmpty()) {

					StringBuffer sbDataLink = new StringBuffer();
					Map<String, Object> dataJson = new HashMap<String, Object>();
					for (Map.Entry<String, Object> e : paramValuesInfo.entrySet()) {

						if (sbDataLink.length() > 0) {
							sbDataLink.append("&");
						}

						Map<String, Object> item = (Map) e.getValue();
						String type = (String) item.get("type");
						Object val = item.get("val");
						Object value = null;

						if ("row".equals(type)) {
							if (row.containsKey(e.getKey())) {
								value = row.get(val);
							}
						} else {
							value = ParamUtil.getParamValueByType(type, val, dto);
						}

						if (value != null) {
							sbDataLink.append(e.getKey() + "=" + (String) value);
						}
						dataJson.put(e.getKey(), (String) value);

					}

					if (sbDataLink.length() > 0) {
						valMap.put("data_link", sbDataLink.toString());
					}
					valMap.put("data_json", JsonUtil.mapToJson(dataJson));

				}

				String inputType = (String) paramInputsInfo.get("type");
				valMap.put("type", inputType);

				// 特殊な処理をしない設定値はそのままvalMapにセットする
				for (Map.Entry<String, Object> e : paramInputsInfo.entrySet()) {
					// 特殊な処理をするかどうか
					if (!needOriginalProcess(inputType, key)) {
						valMap.put(e.getKey(), e.getValue());
					}
				}

				if (TYPE_CHECKBOX.equals(inputType) ||
						TYPE_RADIO.equals(inputType)) {

					valMap.put("list", getList((String) paramInputsInfo.get("list_type"), paramInputsInfo.get("list"), dto));

				}

				if (TYPE_FILE.equals(inputType)) {

					String filePath = getFilePath(
							(Map) paramInputsInfo.get("file_dir"),
							(Map) paramInputsInfo.get("file_sub_dir"),
							(Map) paramInputsInfo.get("file_name"),
							row,
							dto);
					valMap.put("file_name", filePath);
					valMap.put("file_image_disp_width", ParamUtil.getParamStrValueByType(paramInputsInfo.get("file_image_disp_width"), dto));
					valMap.put("file_image_use_flg", ParamUtil.getParamStrValueByType(paramInputsInfo.get("file_image_use_flg"), dto));

				}

				valMap.put("name", key);

				if (paramInputsInfo.containsKey("html_attr")) {
					valMap.put("html_attr", getHtmlAttr(paramInputsInfo.get("html_attr")));
				}

				dst.put(key, valMap);

			}

		}

	}

	/**
	 * 特殊な処理が必要か取得
	 *
	 * @param inputType
	 * @param key
	 * @return 特殊な処理が必要か
	 *
	 * */
	@SuppressWarnings("serial")
	public static boolean needOriginalProcess(String inputType, String key) {

		if (TYPE_CHECKBOX.equals(inputType) ||
				TYPE_RADIO.equals(inputType)) {

			List<String> list = new ArrayList<String>() {
				{
					add("list_type");
					add("list");
				}
			};
			return list.contains(key);

		}

		if (TYPE_FILE.equals(inputType)) {

			List<String> list = new ArrayList<String>() {
				{
					add("file_store_path_system_setting_id");
					add("file_context_path_system_setting_id");
					add("file_name_select_query");
					add("file_image_use_flg");
					add("file_image_disp_width");
					add("file_extension_list");
					add("file_path");
				}
			};
			return list.contains(key);

		}

		return false;
	}

	/**
	 * 指定されたlistTypeから、リストを作成
	 *
	 * @param listType
	 * @param list
	 *
	 * */
	@SuppressWarnings({ "unchecked", "serial" })
	public static List<Map<String, String>> getList(String listType, Object list, ActionDto dto) {

		List<Map<String, String>> ret = new ArrayList<Map<String, String>>();

		if ("static".equals(listType)) {

			// staticのときは、"list"属性に定義されているマップを使用
			ret = (List<Map<String, String>>) list;

		} else if ("dto".equals(listType)) {

			// dtoのときは、dtoの中から、"list"属性に指定されているプロパティを指定してマップを取得
			String key = (String) list;
			List<Map<String, Object>> resultList = (List<Map<String, Object>>) ParamUtil.getParamValueByType("dto", key, dto);
			if (resultList != null && !resultList.isEmpty()) {
				for (Map<String, Object> data : resultList) {
					ret.add(new HashMap<String, String>() {
						{
							put("list_value", (String) data.get("value"));
							put("list_caption", (String) data.get("caption"));
						}
					});
				}
			}

		} else if ("query".equals(listType)) {

			Map<String, Object> map = (Map<String, Object>) list;
			String query = (String) map.get("query");
			List<Map<String, String>> condList = (List<Map<String, String>>) map.get("cond");
			Map<String, Object> params = new HashMap<String, Object>();

			for (Map<String, String> mp : condList) {
				String value = (String) ParamUtil.getParamValueByType(mp.get("transfer_type"), mp.get("transfer_val"), dto);
				params.put(mp.get("key"), value);
			}

			List<Map<String, Object>> resultList = new DomaSQLQueryBuilder().getListResult(query, params, dto);
			if (resultList != null && !resultList.isEmpty()) {
				for (Map<String, Object> data : resultList) {
					ret.add(new HashMap<String, String>() {
						{
							put("list_value", (String) data.get("value"));
							put("list_caption", (String) data.get("caption"));
						}
					});
				}
			}

		}

		return ret;

	}

	/**
	 * 指定された設定から、ファイル項目設定情報を作成
	 *
	 * @param fileDir
	 * @param fileSubDir
	 * @param fileName
	 * @param row
	 *
	 * */
	public static String getFilePath(
								Map<String, Object> fileDir,
								Map<String, Object> fileSubDir,
								Map<String, Object> fileName,
								Map<String, Object> row,
								ActionDto dto) {

		String ret = null;

		String fileDirVal = getParamStrValueByRecType(fileDir, row, dto);
		String fileSubDirVal = getParamStrValueByRecType(fileSubDir, row, dto);
		String fileNameVal = getParamStrValueByRecType(fileName, row, dto);

		StringJoiner sj = new StringJoiner("/");

		if (!StringUtils.isEmpty(fileDirVal)) {
			sj.add(fileDirVal);
		}
		if (!StringUtils.isEmpty(fileSubDirVal)) {
			sj.add(fileSubDirVal);
		}
		ret = sj.toString();
		ret += "/";
		if (!StringUtils.isEmpty(fileNameVal)) {
			ret += fileNameVal;
		}

		return ret;

	}

	/**
	 * 指定された設定から、ファイル項目設定情報を作成
	 *
	 * @param mp
	 * @param row
	 *
	 * @return パラメータ値
	 *
	 * */
	public static String getParamStrValueByRecType(Map<String, Object> mp, Map<String, Object> row, ActionDto dto) {
		String ret = null;
		if ("row".equals((String) mp.get("type"))) {
			ret = (String) row.get((String) mp.get("val"));
		} else {
			ret = ParamUtil.getParamStrValueByType(mp, dto);
		}
		return ret;
	}

	/**
	 * "html_attr"属性設定取得
	 *
	 * @param src
	 * @return "html_attr"属性設定
	 *
	 * */
	@SuppressWarnings("unchecked")
	public static Map<String, String> getHtmlAttr(Object src) {

		Map<String, String> ret = new HashMap<String, String>();
		if (src != null) {
			ret = (Map<String, String>) src;
		}
		return ret;

	}
}
