package jp.ill.photon.util;

import java.util.List;
import java.util.Map;

import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.message.ActionDtoMessage;

import org.apache.commons.lang3.StringUtils;

public class MessageUtil {

	// DTO内で、メッセージマスタのデータが入っているパス
	private static final String MESSAGE_DATA_KEY = "common.mesg.%s.format";

	/***
	 *
	 * メッセージを組み立てる
	 *
	 * @param map モジュールでセットされたメッセージオブジェクト
	 * @param dto アクションDTO。中にメッセージマスタから取得したデータがセットされている前提
	 *
	 */
	@SuppressWarnings("unchecked")
	public static void buildMessage(Map<String, Object> map, ActionDto dto) {

		if (map != null) {

			for (Map.Entry<String, Object> e : map.entrySet()) {

				String key = e.getKey();

				List<ActionDtoMessage> list = (List<ActionDtoMessage>) e.getValue();
				if (list != null) {

					for (ActionDtoMessage item : list) {

						String replacedMessage = (String) dto.get( StringUtils.replace(MESSAGE_DATA_KEY, "%s", item.getMessageId()) );
						if (!StringUtils.isEmpty(replacedMessage)) {
							Map<String, Object> params = item.getParams();
							if (params != null) {
								for (String paramKey : params.keySet()) {
									String replaceStr = ParamUtil.getParamStrValueByType(params.get(paramKey), dto);
									replacedMessage = StringUtils.replace(replacedMessage, paramKey, replaceStr );
								}
							}
							item.setMessage(replacedMessage);
						}

					}

				}

				map.put(key, list);

			}

		}

	}

}
