package jp.ill.photon.util;

import java.util.HashMap;
import java.util.Map;

public class MapUtil {

	/**
	 * 2つのマップをマージする
	 *
	 * @param first
	 * @param second
	 * @return
	 */
	public static Map<String, Object> mergeMaps(Map<String, Object> first,
												Map<String, Object> second) {
		if (second == null) {
			return first;
		}

		if (first == null) {
			return second;
		}

		Object value = null;
		for (Map.Entry<String, Object> entry : first.entrySet()) {
			value = second.getOrDefault(entry.getKey(), null);
			if (value == null) {
				second.put(entry.getKey(), entry.getValue());
			}
		}

		return second;
	}

	/***
	 *
	 * 2つのマップをマージする.<br />
	 * firstの中にsecondのキーが存在していたら、その子供を取得し、再度サーチ<br />
	 * firstの中にsecondのキーが存在していない場合は、値にあたる部分を追加<br />
	 *
	 * @param first
	 * @param second
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public static Map<String, Object> mergeMapHierarchically(Map<String, Object> first,
												Map<String, Object> second) {

		Map<String, Object> workFirst = new HashMap<String, Object>(first);
		Map<String, Object> workSecond = new HashMap<String, Object>(second);

		for (Map.Entry<String, Object> e : workSecond.entrySet()) {

			if (workFirst.containsKey(e.getKey())) {

				Object objFirstChild = workFirst.get(e.getKey());
				Object objSecondChild = workSecond.get(e.getKey());

				if (( objFirstChild instanceof Map ) &&
						( objSecondChild instanceof Map )) {
					workFirst.put(e.getKey(),
							mergeMapHierarchically(
									(Map<String, Object>) objFirstChild,
									(Map<String, Object>) objSecondChild));
				}

			} else {

				workFirst.putAll(workSecond);

			}

		}

		return workFirst;

	}

}
