package jp.ill.photon.util;

import java.io.PrintWriter;
import java.io.StringWriter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * ログ用ユーティリティクラス
 * 
 * @author s_imai
 */
public class LogUtil {

	/** ロガー */
	private final Logger logger;

	/** シングルトン設定 */
	private static final LogUtil instance = new LogUtil();

	/** コンストラクタ設定 */
	public LogUtil() {
		// Loggerを作成する。
		logger = LoggerFactory.getLogger(LogUtil.class);
	}

	public LogUtil(Class clazz) {
		// Loggerを作成する。
		logger = LoggerFactory.getLogger(clazz);
	}

	/** インスタンスを渡すメソッド */
	public static LogUtil getInstance() {
		return instance;
	}

	/**
	 * デバッグレベルのログ書き出し 開発時チェック用、運用時は出力しない
	 * 
	 * @param msg
	 */
	public void debug(String msg) {
		logger.debug(msg);
	}

	/**
	 * 情報レベルのログ書き出し 参考情報、実運用時は出力しない
	 * 
	 * @param msg
	 */
	public void info(String msg) {
		logger.info(msg);
	}

	/**
	 * 警告レベルのログ書き出し アプリケーション続行は可能
	 * 
	 * @param msg
	 */
	public void warn(String msg) {
		logger.warn(msg);
	}

	/**
	 * 障害レベルのログ書き出し アプリケーション続行は不可能
	 * 
	 * @param msg
	 */
	public void error(String msg) {
		logger.error(msg);
	}

	/**
	 * 障害レベルのログ書き出し アプリケーション続行は不可能
	 * 
	 * @param msg
	 */
	public void error(String msg, Exception e) {
		logger.error(msg + "\n" + getStackTrace(e));
	}

	/**
	 * スタックトレースの中身を返却する
	 * 
	 * @param e エラー
	 * @return スタックトレース文字列
	 */
	public String getStackTrace(Exception e) {

		// 引数がnullの場合
		if (e == null) {
			return "";
		}

		StringWriter sw = new StringWriter();
		PrintWriter pw = new PrintWriter(sw);
		e.printStackTrace(pw);
		pw.flush();
		return sw.toString();
	}

}
