package jp.ill.photon.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ListUtil {

	/**
	 * 2つのリストを1つにまとめて（zipして）返す
	 * 
	 * @param src1
	 * @param src2
	 * @return
	 */
	public static List<Map<String, String>> zip(List<String> src1,
												List<String> src2) {

		List<Map<String, String>> result = new ArrayList<>();

		if (src1 == null || src2 == null) {
			return result;
		}

		List<String> baseList = null;
		if (src1.size() > src2.size()) {
			baseList = src2;
		} else {
			baseList = src1;
		}

		Map<String, String> zipped = null;
		for (int i = 0; i < baseList.size(); i++) {
			zipped = new HashMap<>();
			zipped.put("1", src1.get(i));
			zipped.put("2", src2.get(i));
			result.add(zipped);
		}

		return result;
	}

	/**
	 * リストをインデックス番号をキーとしたマップに変換する
	 * 
	 * @param list
	 * @return
	 */
	public static Map<String, Object> toMap(List<Object> list) {
		Map<String, Object> newMap = new LinkedHashMap<>();

		if (list == null || list.size() == 0) {
			return newMap;
		}

		for (int i = 0; i < list.size(); i++) {
			newMap.put(String.valueOf(i), list.get(i));
		}

		return newMap;
	}

	public static List<Integer> rangeClosed(int start, int end) {
		return IntStream.rangeClosed(start, end).boxed()
				.collect(Collectors.toCollection(ArrayList::new));
	}

	public static List<?> objectToList(Object src) {
		return (List) src;
	}
}
