package jp.ill.photon.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import jp.ill.photon.dto.ActionDto;

/**
 * リソースユーティリティクラス
 *
 * @author 
 */
public class LabelUtil {

	/**
	 * 対応文字置き換え<br>
	 * リソース名などキーに対応する文字列(%%key%%)を置き換えます。<br>
	 * 外部からリソース名のマップを渡します。
	 *
	 * @param str 置き換え処理を行う文字列
	 * @param dto データオブジェクト
	 * @return String 置き換え処理の結果
	 **/
	@SuppressWarnings("unchecked")
	public static String replaceKeyPattern(String str, ActionDto dto) {
		Map<Object, Object> common = (Map<Object, Object>) dto.get("common");
		Map<Object, Object> labels = (Map<Object, Object>) common.get("label");
		Map<String, String> keys = new HashMap<String, String>();
		String result = str;

		for (Entry<Object, Object> entry : labels.entrySet()) {
			Map<Object, Object> tmp = (Map<Object, Object>) entry.getValue();
			keys.put(entry.getKey().toString(), tmp.get("note").toString());
		}

		if (keys.isEmpty())
			return result;
		for (Map.Entry<String, String> e : keys.entrySet()) {
			result = result.replace("%%" + e.getKey() + "%%", e.getValue());
		}
		return result;
	}
}
