package jp.ill.photon.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.seasar.doma.FetchType;
import org.seasar.doma.internal.jdbc.sql.SqlParser;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.jdbc.query.SqlSelectQuery;

import jp.ill.photon.dao.DomaConfig;
import jp.ill.photon.dto.ActionDto;

public class JudgeExecutableModuleUtil {

	/** ログ用変数 */
	protected final static LogUtil logger = new LogUtil(
			JudgeExecutableModuleUtil.class);

	/** データタイプ */
	public static final class DataTypes {
		public static final String TEXT = "text";
		public static final String LIST = "list";
		public static final String MAP = "map";
	}

	@SuppressWarnings({ "unchecked", "rawtypes" })
	public static boolean isExecutable(	String cond,
										Map<String, Object> params,
										ActionDto dto) {

		// SQLを読み込んでDomaのSQLParserで解析
		SqlParser sp = new SqlParser(
				"/*%if " + cond + "  */ true /*%else*/ false /*%end*/");
		SqlSelectQuery sq = new SqlSelectQuery();
		sq.setConfig(DomaConfig.singleton());
		sq.setCallerClassName(JudgeExecutableModuleUtil.class.getName());
		sq.setCallerMethodName("isExecutable");
		sq.setFetchType(FetchType.LAZY);
		sq.setSqlLogType(SqlLogType.FORMATTED);
		sq.setSqlNode(sp.parse());

		// パラメータ埋め込み
		if (params != null) {
			for (Map.Entry<String, Object> e : params.entrySet()) {
				String key = e.getKey();
				Map<String, Object> mp = (Map<String, Object>) e.getValue();
				String type = (String) mp.get("data_type");
				Object planeValue = ParamUtil.getParamObjectValueByType(mp,
						dto);
				Object value = null;
				Class clazz = null;
				if (DataTypes.LIST.equals(type)) {
					clazz = List.class;
					List<Object> list = new ArrayList<Object>();
					List<Object> planeValueList = (List<Object>) planeValue;
					if (planeValueList != null) {
						for (Object item : planeValueList) {
							list.add(item);
						}
						value = list;
					}
				} else if (DataTypes.MAP.equals(type)) {
					clazz = Map.class;
					Map<String, Object> map = new LinkedHashMap<>();
					Map<String, Object> planeValueMap = (Map<String, Object>) planeValue;
					if (planeValueMap != null) {
						for (Map.Entry<String, Object> item : planeValueMap
								.entrySet()) {
							map.put(item.getKey(), item.getValue());
						}
						value = map;
					}
				} else {
					clazz = String.class;
					value = (planeValue == null) ? null : planeValue.toString();
				}
				sq.addParameter(key, clazz, value);
			}
		}

		try {
			sq.prepare();
		} catch (Exception e) {
			logger.error(String.format("---->[error]:[%s]", e.getMessage()), e);
			return false;
		}

		return Boolean.parseBoolean(sq.getSql().toString());

	}

}
