package jp.ill.photon.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;

public class JsonUtil {

	private static ObjectMapper mapper = null;
	private static TypeReference<HashMap<String, Object>> typeRef = null;

	static {
		mapper = new ObjectMapper();
		typeRef = new TypeReference<HashMap<String, Object>>() {
		};
	};

	/**
	 * JSON文字列をMapに変換する
	 *
	 * @param json
	 * @return
	 */
	public static Map<String, Object> jsonToMap(String json) {
		Map<String, Object> map = null;
		try {
			map = mapper.readValue(json, typeRef);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return map;
	}

	/**
	 * ObjectをJSON文字列に変換する
	 *
	 * @param dataMap
	 * @return
	 */
	public static String mapToJson(Object obj) {
		String json = "";
		try {
			json = mapper.writeValueAsString(obj);
		} catch (JsonProcessingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return json;
	}

	/**
	 * JSON文字列をリストに変換する
	 *
	 * @param json
	 * @return
	 */
	@SuppressWarnings("rawtypes")
	public static List jsonToList(String json) {
		List list = null;
		TypeReference<ArrayList> typeRefList = new TypeReference<ArrayList>() {
		};
		try {
			list = mapper.readValue(json, typeRefList);
		} catch (IOException e) {
			e.printStackTrace();
		}
		return list;
	}

	/**
	 * 指定されたJSON文字列はMapに変換可能か？
	 *
	 * @param json
	 * @return true:変換可能 / false:変換不可能
	 */
	public static boolean isAbleToConverToMap(String json) {
		Map<String, Object> map = null;
		try {
			map = mapper.readValue(json, typeRef);
		} catch (IOException e) {
			return false;
		}
		return true;
	}

	/**
	 * 指定されたJSON文字列はリストに変換可能か？
	 *
	 * @param json
	 * @return true:変換可能 / false:変換不可能
	 */
	@SuppressWarnings("rawtypes")
	public static boolean isAbleToConverToList(String json) {
		List list = null;
		TypeReference<ArrayList> typeRefList = new TypeReference<ArrayList>() {
		};
		try {
			list = mapper.readValue(json, typeRefList);
		} catch (IOException e) {
			return false;
		}
		return true;
	}

	/**
	 * ObjectをJSON文字列に変換する
	 *
	 * @param dataMap
	 * @return
	 */
	public static String mapToJsonSnakeCaseKey(Object obj) {
		String json = "";
		try {
			json = mapper.writeValueAsString(obj);

			Map<String, Object> newJsonMap = new HashMap<>();
			Map<String, Object> jsonMap = jsonToMap(json);
			for (Entry<String, Object> entry : jsonMap.entrySet()) {
				newJsonMap.put(StringUtil.camelToSnake(entry.getKey()).toLowerCase(), entry.getValue());
			}
			json = mapToJson(newJsonMap);

		} catch (JsonProcessingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return json;
	}

}
