package jp.ill.photon.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Escape methods
 *
 * @author s_laurent
 *
 */


public final class EscapeChars {

	private static final Pattern SCRIPT = Pattern.compile(
			   "<SCRIPT>", Pattern.CASE_INSENSITIVE
			  );
	private static final Pattern SCRIPT_END = Pattern.compile(
			   "</SCRIPT>", Pattern.CASE_INSENSITIVE
			 );

	private static final Pattern MERGE_MULTILINEBREAKS = Pattern.compile("(\\r?\\n){2,}");
	private static final String  MERGE_SINGLELINEBREAK = "\\r?\\n";
	private static final String  WHITESPACE = " ";

	private EscapeChars(){
		 // NO-OP (prevent construction)
	 }

 /**
    Escape characters for CSV Exporting.

    */
	public static String forCSV(String text){

		String result = "";

		if(!Objects.isNull(text)){
			result = MERGE_MULTILINEBREAKS.matcher(text).replaceAll("$1");
			result = result.replaceAll(MERGE_SINGLELINEBREAK, WHITESPACE);
		}

		return result.toString();

	}

 /**
  Escape all special characters in a URL.

 */
 public static String forHrefAmpersand(String aURL){
   final StringBuilder result = new StringBuilder();
   final StringCharacterIterator iterator = new StringCharacterIterator(aURL);
   char character =  iterator.current();
   while (character != CharacterIterator.DONE ){if
             (character == ' ') {result.append("%20");}
    else if (character == '!') {result.append("%21");}
    else if (character == '"') {result.append("%22");}
    else if (character == '#') {result.append("%23");}
    else if (character == '$') {result.append("%24");}
    else if (character == '%') {result.append("%25");}
    else if (character == '&') {result.append("%26");}
    else if (character == '\''){result.append("%27");}
    else if (character == '(') {result.append("%28");}
    else if (character == ')') {result.append("%29");}
    else if (character == '*') {result.append("%2A");}
    else if (character == '+') {result.append("%2B");}
    else if (character == ',') {result.append("%2C");}
    else if (character == '-') {result.append("%2D");}
    else if (character == '.') {result.append("%2E");}
    else if (character == '/') {result.append("%2F");}
    else if (character == ':') {result.append("%3A");}
    else if (character == ';') {result.append("%3B");}
    else if (character == '<') {result.append("%3C");}
    else if (character == '=') {result.append("%3D");}
    else if (character == '>') {result.append("%3E");}
    else if (character == '?') {result.append("%3F");}
    else if (character == '@') {result.append("%40");}
    else if (character == '[') {result.append("%5B");}
    else if (character == '\\'){result.append("%5C");}
    else if (character == ']') {result.append("%5D");}
    else if (character == '^') {result.append("%5E");}
    else if (character == '_') {result.append("%5F");}
    else if (character == '`') {result.append("%60");}
    else if (character == '{') {result.append("%7B");}
    else if (character == '|') {result.append("%7C");}
    else if (character == '}') {result.append("%7D");}
    else if (character == '~') {result.append("%7E");}
    else if (character == '`') {result.append("%E2%82%AC");}
    else if (character == '‚') {result.append("%E2%80%9A");}
    else if (character == 'ƒ') {result.append("%C6%92");}
    else if (character == '„') {result.append("%E2%80%9E");}
    else if (character == '…'){result.append("%E2%80%A6");}
    else if (character == '†'){result.append("%E2%80%A0");}
    else if (character == '‡'){result.append("%E2%80%A1");}
    else if (character == 'ˆ') {result.append("%CB%86");}
    else if (character == '‰'){result.append("%E2%80%B0");}
    else if (character == 'Š') {result.append("%C5%A0");}
    else if (character == '‹') {result.append("%E2%80%B9");}
    else if (character == 'Œ') {result.append("%C5%92");}
  /*else if (character == '0') {result.append("%30");}
    else if (character == '1') {result.append("%31");}
    else if (character == '2') {result.append("%32");}
    else if (character == '3') {result.append("%33");}
    else if (character == '4') {result.append("%34");}
    else if (character == '5') {result.append("%35");}
    else if (character == '6') {result.append("%36");}
    else if (character == '7') {result.append("%37");}
    else if (character == '8') {result.append("%38");}
    else if (character == '9') {result.append("%39");}
    else if (character == 'A') {result.append("%41");}
    else if (character == 'B') {result.append("%42");}
    else if (character == 'C') {result.append("%43");}
    else if (character == 'D') {result.append("%44");}
    else if (character == 'E') {result.append("%45");}
    else if (character == 'F') {result.append("%46");}
    else if (character == 'G') {result.append("%47");}
    else if (character == 'H') {result.append("%48");}
    else if (character == 'I') {result.append("%49");}
    else if (character == 'J') {result.append("%4A");}
    else if (character == 'K') {result.append("%4B");}
    else if (character == 'L') {result.append("%4C");}
    else if (character == 'M') {result.append("%4D");}
    else if (character == 'N') {result.append("%4E");}
    else if (character == 'O') {result.append("%4F");}
    else if (character == 'P') {result.append("%50");}
    else if (character == 'Q') {result.append("%51");}
    else if (character == 'R') {result.append("%52");}
    else if (character == 'S') {result.append("%53");}
    else if (character == 'T') {result.append("%54");}
    else if (character == 'U') {result.append("%55");}
    else if (character == 'V') {result.append("%56");}
    else if (character == 'W') {result.append("%57");}
    else if (character == 'X') {result.append("%58");}
    else if (character == 'Y') {result.append("%59");}
    else if (character == 'Z') {result.append("%5A");}
    else if (character == 'a') {result.append("%61");}
    else if (character == 'b') {result.append("%62");}
    else if (character == 'c') {result.append("%63");}
    else if (character == 'd') {result.append("%64");}
    else if (character == 'e') {result.append("%65");}
    else if (character == 'f') {result.append("%66");}
    else if (character == 'g') {result.append("%67");}
    else if (character == 'h') {result.append("%68");}
    else if (character == 'i') {result.append("%69");}
    else if (character == 'j') {result.append("%6A");}
    else if (character == 'k') {result.append("%6B");}
    else if (character == 'l') {result.append("%6C");}
    else if (character == 'm') {result.append("%6D");}
    else if (character == 'n') {result.append("%6E");}
    else if (character == 'o') {result.append("%6F");}
    else if (character == 'p') {result.append("%70");}
    else if (character == 'q') {result.append("%71");}
    else if (character == 'r') {result.append("%72");}
    else if (character == 's') {result.append("%73");}
    else if (character == 't') {result.append("%74");}
    else if (character == 'u') {result.append("%75");}
    else if (character == 'v') {result.append("%76");}
    else if (character == 'w') {result.append("%77");}
    else if (character == 'x') {result.append("%78");}
    else if (character == 'y') {result.append("%79");}
    else if (character == 'z') {result.append("%7A");}*/
    else {
      //the char is not a special one
      //add it to the result as is
      result.append(character);
      }
    character = iterator.next();
    }
    return result.toString();
  }

 /**
   Synonym for <tt>URLEncoder.encode(String, "UTF-8")</tt>.

  */
  @Deprecated
  public static String forURL(String aURLFragment){
    String result = null;
    try {
      result = URLEncoder.encode(aURLFragment, "UTF-8");
    }
    catch (UnsupportedEncodingException ex){
      throw new RuntimeException("UTF-8 not supported", ex);
    }
    return result;
  }

 /**
  Escape characters for text appearing as XML data, between tags.

 */
 @Deprecated
 public static String forXML(String aText){
   final StringBuilder result = new StringBuilder();
   final StringCharacterIterator iterator = new StringCharacterIterator(aText);
   char character =  iterator.current();
   while (character != CharacterIterator.DONE ){
     if (character == '<') {
       result.append("&lt;");
     }
     else if (character == '>') {
       result.append("&gt;");
     }
     else if (character == '\"') {
       result.append("&quot;");
     }
     else if (character == '\'') {
       result.append("&#039;");
     }
     else if (character == '&') {
        result.append("&amp;");
     }
     else {
       //the char is not a special one
       //add it to the result as is
       result.append(character);
     }
     character = iterator.next();
   }
   return result.toString();
 }

 /**
  Escapes characters for text appearing as data in the
  <a href='http://www.json.org/'>Javascript Object Notation</a>
  (JSON) data interchange format.

 */
 public static String forJSON(String aText){
   final StringBuilder result = new StringBuilder();
   StringCharacterIterator iterator = new StringCharacterIterator(aText);
   char character = iterator.current();
   while (character != StringCharacterIterator.DONE){
     if( character == '\"' ){
       result.append("\\\"");
     }
     else if(character == '\\'){
       result.append("\\\\");
     }
     else if(character == '/'){
       result.append("\\/");
     }
     else if(character == '\b'){
       result.append("\\b");
     }
     else if(character == '\f'){
       result.append("\\f");
     }
     else if(character == '\n'){
       result.append("\\n");
     }
     else if(character == '\r'){
       result.append("\\r");
     }
     else if(character == '\t'){
       result.append("\\t");
     }
     else {
       //the char is not a special one
       //add it to the result as is
       result.append(character);
     }
     character = iterator.next();
   }
   return result.toString();
 }

 /**
  Return <tt>aText</tt> with all <tt>'<'</tt> and <tt>'>'</tt> characters
  replaced by their escaped equivalents.
 */
 @Deprecated
 public static String toDisableTags(String aText){
   final StringBuilder result = new StringBuilder();
   final StringCharacterIterator iterator = new StringCharacterIterator(aText);
   char character =  iterator.current();
   while (character != CharacterIterator.DONE ){
     if (character == '<') {
       result.append("&lt;");
     }
     else if (character == '>') {
       result.append("&gt;");
     }
     else {
       //the char is not a special one
       //add it to the result as is
       result.append(character);
     }
     character = iterator.next();
   }
   return result.toString();
 }


 /**
  Replace characters having special meaning in regular expressions
  with their escaped equivalents, preceded by a '\' character.

 */
 @Deprecated
 public static String forRegex(String aRegexFragment){
   final StringBuilder result = new StringBuilder();

   final StringCharacterIterator iterator =
     new StringCharacterIterator(aRegexFragment)
   ;
   char character =  iterator.current();
   while (character != CharacterIterator.DONE ){
     /*
      All literals need to have backslashes doubled.
     */
     if
              (character == '.')  {result.append("\\.");}
     else if (character == '\\') {result.append("\\\\");}
     else if (character == '?')  {result.append("\\?");}
     else if (character == '*')  {result.append("\\*");}
     else if (character == '+')  {result.append("\\+");}
     else if (character == '&')  {result.append("\\&");}
     else if (character == ':')  {result.append("\\:");}
     else if (character == '{')  {result.append("\\{");}
     else if (character == '}')  {result.append("\\}");}
     else if (character == '[')  {result.append("\\[");}
     else if (character == ']')  {result.append("\\]");}
     else if (character == '(')  {result.append("\\(");}
     else if (character == ')')  {result.append("\\)");}
     else if (character == '^')  {result.append("\\^");}
     else if (character == '$')  {result.append("\\$");}
     else {
       //the char is not a special one
       //add it to the result as is
       result.append(character);
     }
     character = iterator.next();
   }
   return result.toString();
 }

 /**
  Escape <tt>'$'</tt> and <tt>'\'</tt> characters in replacement strings.
  <P>Synonym for <tt>Matcher.quoteReplacement(String)</tt>.

 */
 @Deprecated
 public static String forReplacementString(String aInput){
   return Matcher.quoteReplacement(aInput);
 }

 /**
  Disable all <tt><SCRIPT></tt> tags in <tt>aText</tt>.
  <P>Insensitive to case.

 */
 @Deprecated
 public static String forScriptTagsOnly(String aText){
   String result = null;
   Matcher matcher = SCRIPT.matcher(aText);
   result = matcher.replaceAll("&lt;SCRIPT>");
   matcher = SCRIPT_END.matcher(result);
   result = matcher.replaceAll("&lt;/SCRIPT>");
   return result;
 }

 /**
  Escape characters for text appearing in HTML markup.

 */
 @Deprecated
 public static String forHTML(String aText){
   final StringBuilder result = new StringBuilder();
   final StringCharacterIterator iterator = new StringCharacterIterator(aText);
   char character =  iterator.current();
   while (character != CharacterIterator.DONE ){if
  	       (character == '<')  {result.append("&lt;");}
     else if (character == '>')  {result.append("&gt;");}
     else if (character == '&')  {result.append("&amp;");}
     else if (character == '\"') {result.append("&quot;");}
     else if (character == '\t') {addCharEntity(9, result);}
     else if (character == '!')  {addCharEntity(33, result);}
     else if (character == '#')  {addCharEntity(35, result);}
     else if (character == '$')  {addCharEntity(36, result);}
     else if (character == '%')  {addCharEntity(37, result);}
     else if (character == '\'') {addCharEntity(39, result);}
     else if (character == '(')  {addCharEntity(40, result);}
     else if (character == ')')  {addCharEntity(41, result);}
     else if (character == '*')  {addCharEntity(42, result);}
     else if (character == '+')  {addCharEntity(43, result);}
     else if (character == ',')  {addCharEntity(44, result);}
     else if (character == '-')  {addCharEntity(45, result);}
     else if (character == '.')  {addCharEntity(46, result);}
     else if (character == '/')  {addCharEntity(47, result);}
     else if (character == ':')  {addCharEntity(58, result);}
     else if (character == ';')  {addCharEntity(59, result);}
     else if (character == '=')  {addCharEntity(61, result);}
     else if (character == '?')  {addCharEntity(63, result);}
     else if (character == '@')  {addCharEntity(64, result);}
     else if (character == '[')  {addCharEntity(91, result);}
     else if (character == '\\') {addCharEntity(92, result);}
     else if (character == ']')  {addCharEntity(93, result);}
     else if (character == '^')  {addCharEntity(94, result);}
     else if (character == '_')  {addCharEntity(95, result);}
     else if (character == '`')  {addCharEntity(96, result);}
     else if (character == '{')  {addCharEntity(123, result);}
     else if (character == '|')  {addCharEntity(124, result);}
     else if (character == '}')  {addCharEntity(125, result);}
     else if (character == '~')  {addCharEntity(126, result);}
     else {
       //the char is not a special one
       //add it to the result as is
       result.append(character);
     }
     character = iterator.next();
   }
   return result.toString();
 }

 private static void addCharEntity(Integer aIdx, StringBuilder aBuilder){
   String padding = "";
   if( aIdx <= 9 ){
      padding = "00";
   }
   else if( aIdx <= 99 ){
     padding = "0";
   }
   else {
     //no prefix
   }
   String number = padding + aIdx.toString();
   aBuilder.append("&#" + number + ";");
 }
}