package jp.ill.photon.util;

/**
 * 日付チェック用ユーティリティクラス.
 */
public class DateCheckUtil {

	/** 比較演算子 */
	protected static class OperatorType {
		public static final String EQUALS = "==";
		public static final String NOT_EQUALS = "!=";
		public static final String GREATER = ">";
		public static final String GREATER_OR_EQUALS = ">=";
		public static final String LESS_OR_EQUALS = "<=";
		public static final String LESS = "<";
	}

	/**
	 * 共通
	 * ------------------------------------------------------------------------------------------------------
	 */
	/**
	 * 汎用日付チェック
	 *
	 * @param dateCheckDiv 日付区分
	 * @param value1 チェック対象値1
	 * @param value2 チェック対象値2
	 * @param sign 比較演算子
	 * @return チェック結果(true: OK, false: NG)
	 */
	public static boolean dateCheck(String value1, String value2, String sign) {

		// 日付が設定されていない場合
		if (UtilTools.isEmpty(value1) || UtilTools.isEmpty(value2)) {
			return false;
		}

		value1 = value1.trim();
		value2 = value2.trim();
		if (UtilTools.isEmpty(value1) || UtilTools.isEmpty(value2)) {
			return false;
		}

		// 比較タイプが設定されていない場合
		if (UtilTools.isEmpty(sign)) {
			return false;
		}

		long date1 = DateUtil.toSqlTimestamp(value1).getTime();
		long date2 = DateUtil.toSqlTimestamp(value2).getTime();

		if (OperatorType.EQUALS.equals(sign)) {
			return (date1 == date2);

		} else if (OperatorType.NOT_EQUALS.equals(sign)) {
			return (date1 != date2);

		} else if (OperatorType.GREATER.equals(sign)) {
			return (date1 > date2);

		} else if (OperatorType.GREATER_OR_EQUALS.equals(sign)) {
			return (date1 >= date2);

		} else if (OperatorType.LESS_OR_EQUALS.equals(sign)) {
			return (date1 <= date2);

		} else if (OperatorType.LESS.equals(sign)) {
			return (date1 < date2);

		}

		return true;

	}

}
