package jp.ill.photon.util;

import java.util.ArrayList;
import java.util.List;

public class CsvUtil {

	/**
	 * 特定の区切り文字で区切られたテキストをリストに変換して返す（囲み文字対応版）
	 *
	 ** @param delimiter
	 * @param encloser
	 * @param src
	 * @return
	 */
	public static List<String> csvTextToList(	String delimiter,
												String encloser,
												String src) {

		StringBuilder chunk = new StringBuilder();
		List<String> newSrc = new ArrayList<>();
		String s = null;
		String lastS = "";
		boolean isInEncloserChunk = false;
		boolean lastCharIsEncloser = false;
		for (int i = 0; i < src.length(); i++) {
			s = StringUtil.defaultString(src.charAt(i), "");
			if (chunk.length() > 0) {
				lastS = String.valueOf(chunk.charAt(chunk.length() - 1));
			} else {
				lastS = "";
			}

			// 囲み文字要素内
			if (isInEncloserChunk) {
				if (s.equals(delimiter)) {
					if (chunk.length() == 0 && !lastCharIsEncloser) {
						// chunkが空で囲み文字要素の中で区切り文字が出現したら要素としての区切り文字
						newSrc.add(delimiter);
						lastCharIsEncloser = false;
						continue;
					}

					// 囲み文字あり要素の中で前の文字が囲み文字で区切り文字が出現したらそこが区切り
					if (lastCharIsEncloser) {
						newSrc.add(chunk.toString());
						chunk = new StringBuilder();
						isInEncloserChunk = false;
						lastCharIsEncloser = false;
						continue;
					}
				}

				if (s.equals(encloser)) {
					// 囲み文字あり要素の中で囲み文字が2連続で出現したら文字として扱う
					if (lastCharIsEncloser) {
						chunk.append(encloser);
						lastCharIsEncloser = false;
						continue;
					}

					// 囲み文字あり要素の中で囲み文字が出現したら囲み文字出現フラグを立てる
					lastCharIsEncloser = true;
					continue;
				}
			}

			// 囲み文字要素外
			if (!isInEncloserChunk) {

				if (s.equals(delimiter)) {
					if (chunk.length() == 0) {
						// chunkが空で区切り文字が出現したら空要素
						newSrc.add("");
						lastCharIsEncloser = false;
						continue;
					}

					// 囲み文字なしの要素の中で区切り文字が出現したらそこが区切り
					newSrc.add(chunk.toString());
					chunk = new StringBuilder();
					lastCharIsEncloser = false;
					continue;
				}

				if (s.equals(encloser)) {
					// chunkが空で前の文字が囲み文字でない時に囲み文字が出現したら囲み文字あり要素開始
					if (chunk.length() == 0 && !lastCharIsEncloser) {
						isInEncloserChunk = true;
						continue;
					}
				}
			}

			// 上記以外はchunkに追加
			chunk.append(s);
			lastCharIsEncloser = false;
		}
		newSrc.add(chunk.toString());

		return newSrc;
	}

}
