package jp.ill.photon.util;

import java.security.MessageDigest;
import java.util.Base64;

import org.apache.commons.codec.digest.DigestUtils;


public class CryptUtil {
	/**
	 * パスワードを暗号化(ハッシュ化)
	 *
	 * @param plainPassword パスワード文字列
	 * @param projectCryptKey 暗号化の際に付加する任意文字列(案件ごとに異なる)
	 * @return 暗号化した文字列(キーが設定されていない場合はそのまま返します)
	 */
	public static String digestPassword(String plainPassword,
										String projectCryptKey) {
		String result = plainPassword;
		// 入力チェック
		if (plainPassword == null || "".equals(plainPassword)) {
			return "";
		}
		if (projectCryptKey == null || "".equals(projectCryptKey)) {
			return result;
		}

		try {
			// ダイジェスト用のクラスを初期化
			MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");

			// プロジェクト固有の暗号化キーの設定
			messageDigest.update(projectCryptKey.getBytes());

			// 値の設定
			messageDigest.update(plainPassword.getBytes());

			// 最終的なハッシュ値を取得
			byte[] digestValue = messageDigest.digest();

			// 16進数文字列に変換して返す
			result = (byteToHexString(digestValue));
		} catch (Exception e) {
		}
		return result;
	}

	/**
	 * バイト配列を16進表記に変換する
	 *
	 * @param str 文字列
	 * @param projectCryptKey 暗号化の際に不可する任意文字列(案件ごとに異なる)
	 * @return 変換後の文字列
	 */
	public static String byteToHexString(byte[] hash) {
		StringBuilder builder = new StringBuilder();
		for (byte b : hash) {
			String str = String.format("%02x", b); // 16進数文字列へ変換
			builder.append(str);
		}
		return builder.toString();
	}

	/* Aladdin-EC 3rdリリース #7275 START */
	/**
	 * Base64エンコードした文字列取得.
	 *
	 * @param planeStr 文字列
	 * @return 変換後の文字列
	 */
	public static String getBase64EncodedStr(String planeStr) {
		// Aladdin-EC ３次課題対応_7285 EDIT-S
		if (planeStr == null || planeStr.length() == 0) {
			return "";
		}
		// Aladdin-EC ３次課題対応_7285 EDIT-E
		byte[] inData = planeStr.getBytes();
		return Base64.getEncoder().encodeToString(inData);
	}

	/**
	 * Base64をデコードした文字列取得.
	 *
	 * @param planeStr 文字列
	 * @return 変換後の文字列
	 */
	public static String getBase64DecodedStr(String planeStr) {
		// Aladdin-EC ３次課題対応_7285 EDIT-S
		if (planeStr == null || planeStr.length() == 0) {
			return "";
		}
		// Aladdin-EC ３次課題対応_7285 EDIT-E
		byte[] decoded = Base64.getDecoder().decode(planeStr);
		return new String(decoded);
	}
	/* Aladdin-EC 3rdリリース #7275 END */

	/**
	 * 引数の値をMD5（SJIS）に変換する.
	 *
	 * @param data 変換元文字列
	 * @return MD5への変換後文字列
	 */
	public static String createMd5Sjis(String data) {
		try {
			return DigestUtils.md5Hex(data.getBytes("MS932"));
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}

	/**
	 * 引数の値をMD5（UTF8）に変換する.
	 *
	 * @param data 変換元文字列
	 * @return MD5への変換後文字列
	 */
	public static String createMd5Utf(String data) {
		try {
			return DigestUtils.md5Hex(data.getBytes("UTF-8"));
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}

}
